/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal;

import java.util.Map;

public class WebAppConfig {
    private static final String DEFAULT_SITEMAP = "default";
    private static final String DEFAULT_ICON_TYPE = "png";
    private static final boolean DEFAULT_HTML_CACHE_DISABLED = false;
    private String defaultSitemap = "default";
    private String iconType = "png";
    private boolean htmlCacheDisabled = false;

    public void applyConfig(Map<String, Object> configProps) {
        String configIconType = (String)configProps.get("iconType");
        String configDefaultSitemap = (String)configProps.get("defaultSitemap");
        Object configHtmlCacheDisabled = configProps.get("disableHtmlCache");
        if (configDefaultSitemap == null) {
            configDefaultSitemap = DEFAULT_SITEMAP;
        }
        if (configIconType == null) {
            configIconType = DEFAULT_ICON_TYPE;
        } else if (!configIconType.equalsIgnoreCase("svg") && !configIconType.equalsIgnoreCase(DEFAULT_ICON_TYPE)) {
            configIconType = DEFAULT_ICON_TYPE;
        }
        if (configHtmlCacheDisabled != null && "true".equalsIgnoreCase(configHtmlCacheDisabled.toString())) {
            this.htmlCacheDisabled = true;
        }
        this.iconType = configIconType;
        this.defaultSitemap = configDefaultSitemap;
    }

    public String getDefaultSitemap() {
        return this.defaultSitemap;
    }

    public String getIconType() {
        return this.iconType;
    }

    public boolean isHtmlCacheDisabled() {
        return this.htmlCacheDisabled;
    }
}

