angular.module("PaperUI.controllers",["PaperUI.constants"]).controller("BodyController",["$rootScope","$scope","$http","$location","$timeout","eventService","toastService","discoveryResultRepository","thingTypeRepository","bindingRepository","itemRepository","restConfig","util","titleService",function(e,t,n,i,o,r,a,s,l,c,u,g,f,p){t.scrollTop=0,$(window).scroll(function(){t.$apply(function(e){t.scrollTop=$("body").scrollTop()})}),t.isBigTitle=function(){return t.scrollTop<80&&!e.simpleHeader},p.onTitle(function(t){e.title=t}),p.onSubtitles(function(e){t.subtitles=e}),t.setTitle=function(t){e.title=t},t.setSubtitle=function(e){t.subtitles=[],$.each(e,function(e,n){t.subtitles.push(n)})},t.setHeaderText=function(e){t.headerText=e},e.$on("$routeChangeStart",function(){t.subtitles=[],t.headerText=null}),t.generateUUID=function(){var e=(new Date).getTime(),t="xxxxxxxx".replace(/[x]/g,function(t){var n=(e+16*Math.random())%16|0;return e=Math.floor(e/16),("x"==t?n:3&n|8).toString(16)});return t};var d="";r.onEvent("smarthome/inbox/*/added",function(e,t){a.showDefaultToast("New Inbox Entry: "+t.label,"Show Inbox","inbox/search")}),r.onEvent("smarthome/webaudio/playurl",function(e,t){if(d!==t){var i;if(window.AudioContext=window.AudioContext||window.webkitAudioContext,"undefined"!=typeof window.AudioContext)try{i=new AudioContext;var o=null;n({url:t,method:"GET",responseType:"arraybuffer"}).then(function(e){i.decodeAudioData(e.data,function(e){o=e;var t=i.createBufferSource();t.buffer=e,t.connect(i.destination),t.onended=function(){i.close()},t.start(0)})})}catch(r){i&&i.close()}else angular.element("#audioSink").attr("src",t);d=t}}),t.getNumberOfNewDiscoveryResults=function(){var e=0;if(!t.data.discoveryResults)return e;for(var n=0;n<t.data.discoveryResults.length;n++){var i=t.data.discoveryResults[n];"NEW"===i.flag&&e++}return e},n.get(g.restPath+"/links/auto").then(function(t){void 0!==t.data&&(e.advancedMode=!t.data,window.localStorage.setItem("paperui.advancedMode",!t.data))}),s.getAll(),c.getAll()}]).controller("PreferencesPageController",["$rootScope","$scope","$window","$location","toastService",function(e,t,n,i,o){t.setHeaderText("Edit user preferences.");var r=window.localStorage,a=r.getItem("paperui.language");t.language=a?a:"english",t.save=function(){r.setItem("paperui.language",t.language),o.showSuccessToast("Preferences saved successfully."),setTimeout(function(){n.location.reload()},1500)},t.getSelected=function(e){return $("select#"+e+" option:selected").val()}}]).controller("NavController",["$scope","$location","$http","restConfig","moduleConfig",function(e,t,n,i,o){e.opened=null,e.extensionEnabled,e.ruleEnabled,e.open=function(t){e.opened=t},e.isActive=function(n){var i=n===t.path().split("/")[1];return i||e.opened===n},e.isSubActive=function(e){var n=e===t.path().split("/")[2];return n},e.isHidden=function(e){return(o[e].hasOwnProperty("visible")?o[e].visible:o[e])===!1},e.getLabel=function(e){var t=o&&o[e]?o[e]:"";return t&&t.hasOwnProperty("label")&&t.label?t.label:"Extensions"},e.$on("$routeChangeSuccess",function(){$("body").removeClass("sml-open"),$(".mask").remove(),e.opened=null}),n.get(i.restPath).then(function(t){if(e.extensionEnabled=!1,e.ruleEnabled=!1,t.data&&t.data.links)for(var n=0;n<t.data.links.length;n++)"extensions"===t.data.links[n].type?e.extensionEnabled=!0:"rules"===t.data.links[n].type&&(e.ruleEnabled=!0)})}]);var firmwareFilterModule=angular.module("PaperUI.filters.firmware",[]);firmwareFilterModule.constant("FIRMWARE_STATUS",{UNKNOWN:"UNKNOWN",UP_TO_DATE:"UP_TO_DATE",UPDATE_AVAILABLE:"UPDATE_AVAILABLE",UPDATE_EXECUTABLE:"UPDATE_EXECUTABLE"}),firmwareFilterModule.constant("UPDATE_STEP",{DOWNLOADING:"DOWNLOADING",WAITING:"WAITING",TRANSFERRING:"TRANSFERRING",UPDATING:"UPDATING",REBOOTING:"REBOOTING"}),firmwareFilterModule.filter("firmwareStatusFormat",["FIRMWARE_STATUS",function(e){return function(t){switch(t){case e.UNKNOWN:return"Unknown";case e.UP_TO_DATE:return"Up to date";case e.UPDATE_AVAILABLE:return"Update available";case e.UPDATE_EXECUTABLE:return"Ready to install"}}}]).filter("firmwareStatusClass",["FIRMWARE_STATUS",function(e){return function(t){switch(t){case e.UNKNOWN:return"grey";case e.UP_TO_DATE:return"online";case e.UPDATE_AVAILABLE:return"orange";case e.UPDATE_EXECUTABLE:return"blue"}}}]).filter("firmwareUpdateStep",["UPDATE_STEP",function(e){return function(t){switch(t){case e.DOWNLOADING:return"Downloading";case e.WAITING:return"Waiting";case e.TRANSFERRING:return"Transfering";case e.UPDATING:return"Updating";case e.REBOOTING:return"Rebooting"}}}]),function(){"use strict";angular.module("PaperUI.control",["ngRoute","ngMaterial","PaperUI.services"])}(),function(){"use strict";angular.module("PaperUI.control").directive("locationValidation",function(){return{restrict:"A",require:"ngModel",link:function(e,t,n,i){function o(e){if(!e)return!1;var t=e.split(",");if(t.length<2||t.length>3)return!1;var n=t[0],i=t[1];return n&&i&&n>=-90&&n<=90&&i>=-180&&i<=180}var r=t[0].required;i.$parsers.unshift(function(e){var t=e&&e.length>0,n=!t&&!r||o(e);return i.$setValidity("locationValidation",n),n?e:void 0}),i.$formatters.unshift(function(e){var t=e&&e.length>0,n=!t&&!r||o(e);return i.$setValidity("locationValidation",n),e})}}})}(),function(){"use strict";angular.module("PaperUI.control").directive("hueColor",function(){return{restrict:"A",link:function(e,t,n,i){n.$observe("hueColor",function(e){var n=tinycolor({h:e,s:1,v:1}).toHsv();t.find(".md-thumb").css("backgroundColor",tinycolor(n).toHexString())})}}})}(),function(){"use strict";angular.module("PaperUI.things",["PaperUI.constants","PaperUI.controllers.firmware","PaperUI.controllers.configurableServiceDialog"])}(),function(){"use strict";function e(){return{restrict:"E",scope:{},bindToController:{thing:"=",isEditing:"=?",form:"=?"},controller:t,controllerAs:"$ctrl",templateUrl:"partials/things/directive.thingConfiguration.html"}}function t(e,t,n,i){function o(){return e(function(){u.thing.thingTypeUID&&c(u.thing.thingTypeUID)})}function r(){return u.supportedBridgeTypeUIDs&&u.supportedBridgeTypeUIDs.length>0}function a(){return u.bridges&&u.bridges.length>0}function s(){var e=u.supportedBridgeTypeUIDs[0];if(u.supportedBridgeTypeUIDs.length>1){var n=e.substring(0,e.indexOf(":"));t.path("inbox/setup/thing-types/"+n)}else t.path("inbox/setup/add/"+e)}function l(e){i.getAll(function(t){u.bridges=t.filter(function(t){return e.includes(t.thingTypeUID)})})}function c(e){n.getByUid({thingTypeUID:e}).$promise.then(function(e){e.supportedBridgeTypeUIDs&&e.supportedBridgeTypeUIDs.length>0&&(u.supportedBridgeTypeUIDs=e.supportedBridgeTypeUIDs,l(e.supportedBridgeTypeUIDs))})}var u=this;this.bridges=[],this.supportedBridgeTypeUIDs=[],this.needsBridge=r,this.hasBridge=a,this.createBridge=s,this.$onInit=o}angular.module("PaperUI.things").directive("thingConfiguration",e),t.$inject=["$q","$location","thingTypeService","thingRepository"]}(),function(){"use strict";function e(){return{restrict:"E",scope:{},replace:!0,bindToController:{profileModel:"=",channel:"=",itemType:"="},controllerAs:"$ctrl",templateUrl:"partials/things/directive.profile-selection.html",controller:t}}function t(e){function t(){return e.getByChannel({channelTypeUID:i.channel.channelTypeUID,itemType:i.itemType}).$promise.then(function(e){i.profileList=e.sort(function(e,t){return"system:default"===e.uid?-1:"system:default"===t.uid?1:e.uid<t.uid?-1:e.uid>t.uid?1:0})})}function n(e){return void 0==i.profileModel?"system:default"==e:e==i.profileModel||e=="system:"+i.profileModel}var i=this;this.profileList,this.selectProfile=n,this.$onInit=t}angular.module("PaperUI.things").directive("profileSelection",e),t.$inject=["profileTypeService"]}(),angular.module("PaperUI.directive.searchField",[]).directive("searchField",function(){return{restrict:"E",scope:{model:"=",placeholder:"=?"},templateUrl:"partials/directives/directive.searchField.html",link:function(e,t,n,i){e.placeholder=n.placeholder?n.placeholder:"Search",e.clearSearchField=function(t){t&&27!==t.keyCode||(e.model="")}}}}),function(){"use strict";angular.module("PaperUI.directive.parameterDescription",[]).component("parameterDescription",{bindings:{description:"="},templateUrl:"partials/configuration/directive.parameterDescription.html",controller:function(){var e=this;this.isShowMore=!1,this.showMore=function(t,n){n.stopImmediatePropagation(),e.isShowMore=t}}})}(),function(){"use strict";function e(){function e(e){e.location&&(t.model=e.location)}var t=this;this.onMapUpdate=e}angular.module("PaperUI.directive.locationParameter",["PaperUI.control"]).component("locationParameter",{bindings:{model:"=",parameter:"=",form:"<"},templateUrl:"partials/configuration/directive.locationParameter.html",controller:e})}(),function(){"use strict";function e(){function e(e,t){if(t)return t.name?t.name:"thing"==e.context?t.UID:"channel"==e.context?t.id:void 0}this.getName=e}angular.module("PaperUI.directive.configDescription",[]).component("configDescription",{bindings:{configuration:"=",parameters:"=",expertMode:"=?",configArray:"=?",form:"=?"},templateUrl:"partials/configuration/directive.configDescription.html",controller:e})}(),function(){"use strict";angular.module("PaperUI.bindings",["ngRoute","ngMaterial","PaperUI.directive.searchField","PaperUI.services"])}(),function(){"use strict";function e(e,t,n,i,o){function r(){return i.getAll(!0).then(function(e){return c.bindings=e,c.bindings})}function a(t){e.path(t)}function s(e,t){t.stopPropagation(),n.show({controller:"ConfigureBindingDialogController",templateUrl:"partials/bindings/dialog.configurebinding.html",targetEvent:t,hasBackdrop:!0,locals:{binding:e}})}function l(e){return!!e.configDescriptionURI}var c=this;this.bindings=[],this.extensionServiceAvailable=!1,this.navigateTo=a,this.configure=s,this.isConfigurable=l,this.refresh=r,t.isAvailable(function(e){c.extensionServiceAvailable=e}),o.setTitle("Configuration"),o.setSubtitles(["Bindings"]),r()}angular.module("PaperUI.bindings").component("bindingsList",{templateUrl:"partials/bindings/directive.bindings-list.html",controller:e}),e.$inject=["$location","extensionService","$mdDialog","bindingRepository","titleService"]}(),function(){"use strict";function e(){function e(e,t){return function(n){if(t&&t.length>0){for(var i=0;i<e.length;i++)if(n[e[i]]&&n[e[i]].toUpperCase().indexOf(t.toUpperCase())!=-1)return!0;return!1}return!0}}function t(e){e&&27!==e.keyCode||(n.filter.text="")}var n=this;this.filter={text:""},this.clearFilter=t,this.filterItems=e}angular.module("PaperUI.bindings").component("bindingThingtypes",{bindings:{binding:"="},templateUrl:"partials/bindings/directive.binding-thingtypes.html",controller:e})}(),function(){"use strict";angular.module("PaperUI.bindings").component("bindingOverview",{bindings:{binding:"="},templateUrl:"partials/bindings/directive.binding-overview.html"})}(),function(){"use strict";function e(e,t,n,i,o,r,a){function s(){a.setTitle("Configuration");var t=e.bindingId;r.getOne(function(e){return e.id===t},function(e){a.setSubtitles(["Bindings",e.name]),g.binding=e,g.binding.thingTypes=[],o.getAll(function(t){angular.forEach(t,function(t){t.UID.split(":")[0]===e.id&&g.binding.thingTypes.push(t)})})})}function l(e){t.path(e)}function c(e){i.show({controller:"ConfigureBindingDialogController",templateUrl:"partials/bindings/dialog.configurebinding.html",targetEvent:e,hasBackdrop:!0,locals:{binding:g.binding}})}function u(){return!!g.binding.configDescriptionURI}var g=this;this.binding,this.isConfigurable=u,this.configure=c,this.navigateTo=l,this.$onInit=s}angular.module("PaperUI.bindings").component("bindingDetail",{templateUrl:"partials/bindings/directive.binding-details.html",controller:e}),e.$inject=["$routeParams","$location","$mdExpansionPanel","$mdDialog","thingTypeRepository","bindingRepository","titleService"]}(),angular.module("PaperUI.controllers.setup",[]).controller("SetupPageController",["$scope","$location","thingTypeRepository","bindingRepository",function(e,t,n,i){function o(){n.getAll(function(t){$.each(t,function(t,n){e.thingTypes[n.UID]=n})})}e.navigateTo=function(e){t.path("inbox/"+e)},e.navigateToConfig=function(e){t.path("configuration/"+e)},e.thingTypes=[],e.getThingTypeLabel=function(t){return e.thingTypes&&0!=Object.keys(e.thingTypes).length?e.thingTypes[t]?e.thingTypes[t].label:"Unknown device":void n.setDirty(!1)},o()}]).controller("InboxController",["$scope","$timeout","$mdDialog","$q","inboxService","discoveryResultRepository","thingTypeRepository","thingService","toastService",function(e,t,n,i,o,r,a,s,l){e.setHeaderText("Shows a list of found things in your home."),e.showScanDialog=function(e){n.show({controller:"ScanDialogController",templateUrl:"partials/setup/dialog.scan.html",targetEvent:e})},e.refresh=function(){r.getAll(!0)}}]).controller("InboxEntryController",["$scope","$mdDialog","$q","inboxService","discoveryResultRepository","thingTypeRepository","thingService","toastService","thingRepository","configDescriptionService",function(e,t,n,i,o,r,a,s,l,c){function u(){if(e.bindings=[],e.data&&e.data.discoveryResults&&e.data.bindings&&e.data.bindings.length>0)for(var t=0;t<e.data.bindings.length;t++){var n=$.grep(e.data.discoveryResults,function(n){return n.bindingType==e.data.bindings[t].id});n.length>0&&e.bindings.push(e.data.bindings[t])}}e.approve=function(n,a,u){t.show({controller:"ApproveInboxEntryDialogController",templateUrl:"partials/setup/dialog.approveinboxentry.html",targetEvent:u,locals:{discoveryResult:o.find(function(e){return e.thingUID===n})}}).then(function(t){i.approve({thingUID:n,enableChannels:!e.advancedMode},t.label).$promise.then(function(){l.setDirty(!0);var t=r.find(function(e){return a===e.UID}),i=!1;l.getOne(function(e){return e.UID===n},function(r){c.getByUri({uri:"thing-type:"+t.UID},function(e){if(e.parameters)for(var t=0;t<e.parameters.length;t++){var n=e.parameters[t];if(n.required){if(!r.configuration.hasOwnProperty(n.name)){i=!0;break}if(""===r.configuration[n.name]){i=!0;break}}}}).$promise["finally"](function(){i?(e.navigateToConfig("things/edit/"+n),s.showDefaultToast("Thing added and must be configured")):(s.showDefaultToast("Thing added.","Show Thing","configuration/things/view/"+n),t&&t.bridge?e.navigateTo("setup/search/"+n.split(":")[0]):o.getAll(!0))})})})})},e.ignore=function(t){i.ignore({thingUID:t},function(){e.refresh()})},e.unignore=function(t){i.unignore({thingUID:t},function(){e.refresh()})},e.remove=function(n,r){var a=o.find(function(e){return e.thingUID===n}),l=t.confirm().title("Remove "+a.label).content("Would you like to remove the discovery result from the inbox?").ariaLabel("Remove Discovery Result").ok("Remove").cancel("Cancel").targetEvent(r);t.show(l).then(function(){i.remove({thingUID:n},function(){e.refresh(),s.showSuccessToast("Inbox entry removed")})})},e.bindings,e.$watch("data.discoveryResults",function(e){e&&u()}),e.clearAll=function(){e.searchText="",e.$broadcast("ClearFilters")}}]).controller("ScanDialogController",["$scope","$rootScope","$timeout","$mdDialog","discoveryService","bindingRepository",function(e,t,n,i,o,r){e.supportedBindings=[],e.activeScans=[],e.scan=function(t){e.activeScans.push(t),o.scan({bindingId:t},function(n){var i=parseInt(n.timeout);i=1e3*(isNaN(i)?3:i),setTimeout(function(){e.$apply(function(){e.activeScans.splice(e.activeScans.indexOf(t),1)})},i)})},r.getAll(),e.getSupportedBindingIdsSortedByName=function(){return e.supportedBindings.sort(function(t,n){return e.getBindingById(t).name.localeCompare(e.getBindingById(n).name)})},e.getBindingById=function(e){for(var n=0;n<t.data.bindings.length;n++){var i=t.data.bindings[n];if(i.id===e)return i}return{}},o.getAll(function(t){e.supportedBindings=t}),e.close=function(){i.hide()}}]).controller("ApproveInboxEntryDialogController",["$scope","$mdDialog","discoveryResult","thingTypeRepository",function(e,t,n,i){e.discoveryResult=n,e.label=n.label,e.thingType=null,e.thingTypeUID=n.thingTypeUID,i.getOne(function(t){return t.UID===e.thingTypeUID},function(t){e.thingType=t}),e.close=function(){t.cancel()},e.approve=function(e){t.hide({label:e})}}]).controller("ManualSetupConfigureController",["$scope","$routeParams","$mdDialog","$location","toastService","bindingRepository","thingTypeService","thingService","thingRepository","configService","linkService",function(e,t,n,i,o,r,a,s,l,c,u){function g(){var e=(new Date).getTime(),t="xxxxxxxx".replace(/[x]/g,function(t){var n=(e+16*Math.random())%16|0;return e=Math.floor(e/16),("x"==t?n:3&n|8).toString(16)});return t}var f=t.thingTypeUID;e.thingType=null,e.thing={UID:null,thingTypeUID:f,configuration:{},item:{label:null,groupNames:[]}},e.thingID=null,e.addThing=function(t){t.UID=t.thingTypeUID+":"+t.ID,t.configuration=c.setConfigDefaults(t.configuration,e.parameters,!0),s.add(t,function(){o.showDefaultToast("Thing added.","Show Thing","configuration/things/view/"+t.UID),i.path("configuration/things")})},a.getByUid({thingTypeUID:f},function(t){e.setTitle("Configure "+t.label),e.setHeaderText(t.description),e.thingType=t,e.parameters=c.getRenderingModel(t.configParameters,t.parameterGroups),e.thing.ID=g(),e.thing.item.label=t.label,e.thing.label=t.label,c.setDefaults(e.thing,e.thingType)})}]).controller("SetupWizardController",["$scope","discoveryResultRepository",function(e,t){e.showIgnored=!1,e.toggleShowIgnored=function(){e.showIgnored=!e.showIgnored},e.refresh=function(){t.getAll(!0)},e.refresh(),e.filter=function(t){return e.showIgnored||"NEW"===t.flag},e.areEntriesIgnored=function(e){return $.grep(e,function(e){return"IGNORED"===e.flag}).length>0}}]).controller("SetupWizardBindingsController",["$scope","bindingRepository","discoveryService",function(e,t,n){e.setSubtitle(["Choose Binding"]),e.setHeaderText("Choose a Binding for which you want to add new things."),t.getAll(),e.selectBinding=function(t){n.getAll(function(n){n.indexOf(t)>=0?e.navigateTo("setup/search/"+t):e.navigateTo("setup/thing-types/"+t)})}}]).controller("SetupWizardSearchBindingController",["$scope","discoveryResultRepository","discoveryService","thingTypeRepository","bindingRepository",function(e,t,n,i,o){e.showIgnored=!1,e.toggleShowIgnored=function(){e.showIgnored=!e.showIgnored},e.bindingId=e.path[4];var r=o.find(function(t){return t.id===e.bindingId});e.setSubtitle([r?r.name:"","Search"]),e.setHeaderText("Searching for new things for the "+(r?r.name:"")+"."),e.discoverySupported=!0,n.getAll(function(t){t.indexOf(e.bindingId)>=0&&(e.discoverySupported=!0,e.scan(e.bindingId))}),e.scanning=!1,e.filter=function(t){return(e.showIgnored||"NEW"===t.flag)&&t.thingUID.split(":")[0]===e.bindingId},e.scan=function(t){e.scanning=!0,n.scan({bindingId:t},function(t){var n=parseInt(t.timeout);n=1e3*(isNaN(n)?10:n),setTimeout(function(){e.$apply(function(){e.scanning=!1})},n)})},e.refresh=function(){t.getAll(!0)},e.refresh()}]).controller("SetupWizardThingTypesController",["$scope","bindingRepository",function(e,t){e.bindingId=e.path[4];var n=t.find(function(t){return t.id===e.bindingId});e.setSubtitle([n?n.name:"","Choose Thing"]),e.setHeaderText("Choose a Thing from the "+(n?n.name:"")+" which you want to add."),e.selectThingType=function(t){e.navigateTo("setup/add/"+t)},e.filter=function(t){return t.UID.split(":")[0]===e.bindingId&&t.listed}}]),angular.module("PaperUI.control").controller("ControlPageController",["$scope","$location","$routeParams","$timeout","itemRepository","thingTypeRepository","thingRepository","channelTypeRepository",function(e,t,n,i,o,r,a,s){function l(){var t=[];t.push(o.getAll()),t.push(s.getAll()),t.push(r.getAll()),t.push(a.getAll()),Promise.all(t).then(function(){a.getAll(function(t){if(e.tabs=c(t),g){var n=e.tabs.find(function(e){return e.name===g.toUpperCase()});e.selectedTabIndex=n?e.tabs.indexOf(n):0}})})}function c(e){if(!e)return[];var t=[];angular.forEach(e,function(e){var n=e.location?e.location.toUpperCase():"OTHER";e.location=n,t[n]||(t[n]={name:n,things:[]}),t[n].things.push(e)});var n=[],i=Object.keys(t).sort();return angular.forEach(i,function(e){n.push(t[e])}),n}function u(e){i(function(){new Masonry("#"+e,{})},100,!1)}e.tabs=[],e.selectedTabIndex,l();var g=n.tab;e.onSelectedTab=function(e){u(e.tabName),t.path("/control").search("tab",e.tabName)},e.refresh=l}]),function(){"use strict";function e(e){function t(){r.item=angular.copy(r.item),e.updateStateText(r.item),r.longEditMode=r.item.stateText>7,e.onStateChange(r.item.name,function(t){r.item.state=t.value,e.updateStateText(r.item),r.longEditMode=r.item.stateText>7})}function n(){return"Number"===r.item.groupType?"number":""}function i(){r.editMode=!0}function o(){e.sendCommand(r.item,r.item.state),r.editMode=!1}var r=this;this.getIcon=e.getIcon,this.getLabel=e.getLabel,this.isOptionList=e.isOptionList,this.editState=i,this.updateState=o,this.inputType=n,this.$onInit=t}angular.module("PaperUI.control").component("stringControl",{bindings:{item:"<"},templateUrl:"partials/control/string/component.control.string.html",controller:e}),e.$inject=["controlItemService"]}(),function(){"use strict";function e(e,t){function n(){o.item=angular.copy(o.item),"UNDEF"!==o.item.state&&"NULL"!==o.item.state||(o.item.state="-"),e.onStateChange(o.item.name,function(t){o.item.state=t.value,e.updateStateText(o.item)})}function i(){e.sendCommand(o.item,o.item.state)}var o=this;this.updateState=i,this.getIcon=e.getIcon,this.getLabel=e.getLabel,this.isOptionList=e.isOptionList,this.$onInit=n}angular.module("PaperUI.control").component("switchControl",{bindings:{item:"<"},templateUrl:"partials/control/switch/component.control.switch.html",controller:e}),e.$inject=["controlItemService","eventService"]}(),function(){"use strict";function e(e){function t(){r.item=angular.copy(r.item),"UNDEF"===r.item.state||"NULL"===r.item.state?r.item.state="-":r.item.state=parseInt(r.item.state),e.updateStateText(r.item),e.onStateChange(r.item.name,function(t){r.item.state=parseInt(t.value),e.updateStateText(r.item)})}function n(t){e.sendCommand(r.item,t)}function i(){r.editMode=!0}function o(){e.sendCommand(r.item,r.item.state),r.editMode=!1}var r=this;this.editMode=!1,this.editState=i,this.updateState=o,this.sendCommand=n,this.getIcon=e.getIcon,this.getLabel=e.getLabel,this.isOptionList=e.isOptionList,this.$onInit=t}angular.module("PaperUI.control").component("rollershutterControl",{bindings:{item:"<"},templateUrl:"partials/control/rollershutter/component.control.rollershutter.html",controller:e}),e.$inject=["controlItemService"]}(),function(){"use strict";function e(e,t){function n(){l.item=angular.copy(l.item),"UNDEF"!==l.item.state&&"NULL"!==l.item.state||(l.item.state="-"),e.onStateChange(l.item.name,function(t){l.item.state=t.value,e.updateStateText(l.item)})}function i(){l.isInterrupted=!1,l.time=(new Date).getTime(),t(function(){l.isInterrupted||l.sendCommand("REWIND",!1)},300)}function o(){var e=(new Date).getTime();l.time+300>e?(l.isInterrupted=!0,l.sendCommand("PREVIOUS",!1)):t(function(){l.sendCommand("PLAY",!1)})}function r(){l.isInterrupted=!1,l.time=(new Date).getTime(),t(function(){l.isInterrupted||l.sendCommand("FASTFORWARD",!1)},300)}function a(){var e=(new Date).getTime();l.time+300>e?(l.isInterrupted=!0,l.sendCommand("NEXT",!1)):t(function(){l.sendCommand("PLAY",!1)})}function s(t,n){e.sendCommand(l.item,t),n&&(l.item.state=t)}var l=this;this.isInterrupted,this.time,this.sendCommand=s,this.onPrevDown=i,this.onPrevUp=o,this.onNextDown=r,this.onNextUp=a,this.getIcon=e.getIcon,this.getLabel=e.getLabel,this.isOptionList=e.isOptionList,this.$onInit=n}angular.module("PaperUI.control").component("playerControl",{bindings:{item:"<"},templateUrl:"partials/control/player/component.control.player.html",controller:e}),e.$inject=["controlItemService","$timeout"]}(),function(){"use strict";function e(e){function t(){r.item=angular.copy(r.item),"UNDEF"!==r.item.state&&"NULL"!==r.item.state||(r.item.state="-"),o(r.item.state),e.onStateChange(r.item.name,function(e){var t=e.value;o(t)})}function n(){r.editMode=!0}function i(){var t=r.item.unit?r.item.state+" "+r.item.unit:r.item.state;e.sendCommand(r.item,t),r.editMode=!1}function o(t){var n=""+t;n.indexOf(" ")>0&&(r.item.unit=n.substring(n.indexOf(" ")+1),t=n.substring(0,n.indexOf(" ")));var i=Number(t);isNaN(i)||(t=i),r.item.state=t,e.updateStateText(r.item)}var r=this;this.editMode=!1,this.editState=n,this.updateState=i,this.getIcon=e.getIcon,this.getLabel=e.getLabel,this.isOptionList=e.isOptionList,this.$onInit=t}angular.module("PaperUI.control").component("numberControl",{bindings:{item:"<"},templateUrl:"partials/control/number/component.control.number.html",controller:e}),e.$inject=["controlItemService"]}(),function(){"use strict";function e(e,t){function n(){return t.getMapSource()?(f.hasMapSource=!0,void(f.mapId=u())):(f.hasMapSource=!1,void(f.redrawMap=function(){}))}function i(e){e.model&&(f.model=e.model.currentValue,s(f.model))}function o(){setTimeout(function(){if(!f.map){var e="map-"+f.mapId,t=f.readOnly?null:r;f.map=a(e,t)}f.model&&f.model.length>0?(s(f.model),f.map.getView().setZoom(14)):s([0,0]),f.map.updateSize()},100)}function r(t){var n=c(f.model),i=n[2],o=ol.proj.toLonLat(t),r=o[1]+","+o[0];null!=i&&(r+=","+i),e(function(){f.onUpdate({$event:{location:r}})},0)}function a(e,n){var i=new ol.layer.Tile({source:t.getMapSource()});f.point=new ol.geom.Point(ol.proj.fromLonLat([0,0]));var o=l(f.point),r=[];n&&(r=ol.interaction.defaults().extend([new g(n)]));var a=new ol.Map({layers:[i,o],target:e,view:new ol.View({center:ol.proj.fromLonLat([0,0]),zoom:2}),interactions:r});return a}function s(e){if(f.hasMapSource){var t=c(e),n=t[0],i=t[1];if(!isNaN(n)&&!isNaN(i)){var o=ol.proj.fromLonLat([i,n]);f.map.getView().setCenter(o),f.point.setCoordinates(o)}}}function l(e){var t=new ol.style.Style({image:new ol.style.Icon({anchor:[.5,51],anchorXUnits:"fraction",anchorYUnits:"pixels",src:"img/logo_pointer.png"}),stroke:new ol.style.Stroke({width:3,color:[255,0,0,1]}),fill:new ol.style.Fill({color:[0,0,255,.6]})}),n=new ol.Feature(e),i=new ol.layer.Vector({source:new ol.source.Vector({features:[n]}),style:t});return i}function c(e){var t=(""+e).split(",");if(t.length<2)return[];var n=parseFloat(t[0]),i=parseFloat(t[1]),o=null;return t.length>2&&(o=parseFloat(t[2])),[n,i,o]}function u(){return Math.random().toString(36).substring(2,6)+"-"+Math.random().toString(36).substring(2,6)}var g=function(e){ol.interaction.Pointer.call(this,{handleDownEvent:g.prototype.handleDownEvent,handleDragEvent:g.prototype.handleDragEvent,handleMoveEvent:g.prototype.handleMoveEvent,handleUpEvent:g.prototype.handleUpEvent}),this.coordinate_=null,this.cursor_="pointer",this.feature_=null,this.previousCursor_=void 0,this.callback_=e};ol.inherits(g,ol.interaction.Pointer),g.prototype.handleDownEvent=function(e){var t=e.map,n=t.forEachFeatureAtPixel(e.pixel,function(e){return e});return n&&(this.coordinate_=e.coordinate,this.feature_=n),!!n},g.prototype.handleDragEvent=function(e){var t=e.coordinate[0]-this.coordinate_[0],n=e.coordinate[1]-this.coordinate_[1],i=this.feature_.getGeometry();i.translate(t,n),this.coordinate_[0]=e.coordinate[0],this.coordinate_[1]=e.coordinate[1]},g.prototype.handleMoveEvent=function(e){if(this.cursor_){var t=e.map,n=t.forEachFeatureAtPixel(e.pixel,function(e){return e}),i=e.map.getTargetElement();n?i.style.cursor!=this.cursor_&&(this.previousCursor_=i.style.cursor,i.style.cursor=this.cursor_):void 0!==this.previousCursor_&&(i.style.cursor=this.previousCursor_,this.previousCursor_=void 0)}},g.prototype.handleUpEvent=function(){return this.callback_(this.coordinate_),this.coordinate_=null,this.feature_=null,!1};var f=this;this.hasMapSource,this.mapId,this.map,this.point,this.$onInit=o,this.$onChanges=i,n()}angular.module("PaperUI.control").component("mapComponent",{bindings:{model:"<",readOnly:"<",onUpdate:"&"},templateUrl:"partials/control/map/component.control.map.html",controller:e}),e.$inject=["$timeout","mapSourceService"]}(),function(){"use strict";function e(e){function t(e){e.item&&(l.item=angular.copy(this.item),l.formattedState=i())}function n(){e.onStateChange(l.item.name,function(t){l.item.state=t.value,e.updateStateText(l.item),l.formattedState=i()})}function i(){if("UNDEF"!==l.item.state&&"NULL"!==l.item.state){var e=l.item.state.split(","),t=parseFloat(e[0]),n=parseFloat(e[1]),i=parseFloat(e[2]);return t+"°N, "+n+"°E"+(isNaN(i)?"":", "+i+"m")}return"- °N, - °E, - m"}function o(){l.editMode=!0}function r(){l.editMode=!1,e.sendCommand(l.item,l.item.state),l.formattedState=i()}function a(e,t){if(l.item.name)return l.item.label;if(l.item.category){var n=categories[l.item.category];if(n)return n.label?n.label:l.item.category}return t}function s(e){e.location&&(l.item.state=e.location,l.updateState())}var l=this;this.formattedState,this.editMode=!1,this.categories=[],this.editState=o,this.updateState=r,this.getLabel=a,this.onMapUpdate=s,this.$onChanges=t,this.$onInit=n}angular.module("PaperUI.control").component("locationControl",{bindings:{item:"<"},templateUrl:"partials/control/location/component.control.location.html",controller:e}),e.$inject=["controlItemService"]}(),function(){"use strict";function e(e){function t(){i.item=angular.copy(i.item),i.item.imageLoaded=!0,e.onStateChange(i.item.name,function(t){i.item.state=t.value,e.updateStateText(i.item)})}function n(){e.sendCommand(i.item,"REFRESH")}var i=this;this.getLabel=e.getLabel,this.refreshCameraImage=n,this.$onInit=t}angular.module("PaperUI.control").component("imageControl",{bindings:{item:"="},templateUrl:"partials/control/image/component.control.image.html",controller:e}),e.$inject=["controlItemService"]}(),function(){"use strict";function e(e,t){function n(){s.item=angular.copy(s.item),r(),"UNDEF"!==s.item.state&&"NULL"!==s.item.state||(s.item.state="-"),e.onStateChange(s.item.name,function(t){"OnOff"!==t.type&&(s.item.state=t.value,r(),e.updateStateText(s.item))})}function i(){e.sendCommand(s.item,s.state.switchState?"ON":"OFF")}function o(){a&&t.cancel(a),a=t(function(){e.sendCommand(s.item,s.item.state),r(s.item.state),a=void 0},300)}function r(){s.state.switchState=s.item.state>0}var a,s=this;this.state={switchState:""},this.getIcon=e.getIcon,this.getLabel=e.getLabel,this.isOptionList=e.isOptionList,this.showSwitch=e.showSwitch,this.setBrightness=o,this.setSwitch=i,this.$onInit=n}angular.module("PaperUI.control").component("dimmerControl",{bindings:{item:"<"},templateUrl:"partials/control/dimmer/component.control.dimmer.html",controller:e}),e.$inject=["controlItemService","$timeout"]}(),function(){"use strict";function e(e){function t(){i.item=angular.copy(i.item),"UNDEF"!==i.item.state&&"NULL"!==i.item.state||(i.item.state="-"),e.onStateChange(i.item.name,function(t){i.item.state=t.value,e.updateStateText(i.item)})}function n(){e.sendCommand(i.item,i.item.state)}var i=this;this.updateState=n,this.getIcon=e.getIcon,this.getLabel=e.getLabel,this.isOptionList=e.isOptionList,this.$onInit=t}angular.module("PaperUI.control").component("contactControl",{bindings:{item:"<"},templateUrl:"partials/control/contact/component.control.contact.html",controller:e}),e.$inject=["controlItemService"]}(),function(){"use strict";function e(e,t){function n(){c.item=angular.copy(c.item),i(c.item.state),"UNDEF"!==c.item.state&&"NULL"!==c.item.state||(c.item.state="-"),e.onStateChange(c.item.name,function(e){c.item.state=e.value,i(c.item.state)})}function i(e){var t=e.split(",");3==t.length?(c.state.hue=t[0],c.state.saturation=t[1],c.state.brightness=t[2]):(c.state.hue=0,c.state.saturation=0,c.state.brightness=0)}function o(){s(c.state.brightness)}function r(){s(a())}function a(){return Math.ceil(c.state.hue)+","+Math.ceil(c.state.saturation)+","+Math.ceil(c.state.brightness)}function s(n){l&&t.cancel(l),l=t(function(){e.sendCommand(c.item,n),l=void 0},300)}var l,c=this;this.state={hue:"",saturation:"",brightness:""},this.getIcon=e.getIcon,this.getLabel=e.getLabel,this.isOptionList=e.isOptionList,this.setBrightness=o,this.setColor=r,
this.$onInit=n}angular.module("PaperUI.control").component("colorControl",{bindings:{item:"<"},templateUrl:"partials/control/color/component.control.color.html",controller:e}),e.$inject=["controlItemService","$timeout"]}(),function(){"use strict";function e(e,t,n,i){function o(){s()}function r(t){e.path(t)}function a(){c.onSelectionUpdate({$event:{tabName:c.tab.name}})}function s(){var e=[];t.getAll().then(function(t){angular.forEach(c.tab.things,function(i){n.getOne(function(e){return e.UID===i.thingTypeUID},function(n){var o=l(i,n,t);o&&(e.push(o),e=e.sort(function(e,t){return e.label<t.label?-1:e.label>t.label?1:0}),c.things=e)},!1)})})}function l(e,t,n){e.thingChannels=i.getThingChannels(e,t,n,!0),angular.forEach(e.thingChannels,function(e){e.channels=e.channels.filter(function(e){return e.linkedItems.length>0})});var o=!1;if(angular.forEach(e.thingChannels,function(e){angular.forEach(e.channels,function(e){e.linkedItems&&e.linkedItems.length>0&&(o=!0)})}),o)return e}var c=this;this.things=[],this.navigateTo=r,this.onTabSelect=a,this.$onInit=o}angular.module("PaperUI.control").component("tabControl",{bindings:{tab:"<",onSelectionUpdate:"&"},templateUrl:"partials/control/component.control.tab.html",controller:e}),e.$inject=["$location","channelTypeRepository","thingTypeRepository","thingConfigService"]}(),function(){"use strict";angular.module("PaperUI.control").component("itemStateDropdown",{bindings:{item:"=",onChange:"&"},templateUrl:"partials/control/component.control.stateDropdown.html"})}(),function(){"use strict";function e(e,t,n,i,o){function r(){a()}function a(){n.getOne(function(e){return e.name==l.itemName},function(e){e.stateText=i.getItemStateText(e),e.readOnly=s(e),l.item=e})}function s(e){return!!e.stateDescription&&e.stateDescription.readOnly}var l=this;this.item,this.$onInit=r}angular.module("PaperUI.control").component("itemControl",{bindings:{itemName:"<"},templateUrl:"partials/control/component.control.item.html",controller:e}),e.$inject=["thingRepository","channelTypeRepository","itemRepository","util","imageService"]}(),function(){"use strict";function e(e,t,n,i){function o(t,i){n.onEvent("smarthome/items/"+t+"/statechanged",function(t,n){e(function(){i(n)},0)})}function r(e){if(e){var t=g[e];if(t)return t.showSwitch}return!1}function a(e){return e&&e.stateDescription&&e.stateDescription.options.length>0}function s(e,t){if(e.label)return e.label;if(e.category){var n=g[e.category];if(n)return n.label?n.label:e.category}return t}function l(e,t){var n=t?t:"radio_button_unchecked";return e&&g[e]&&g[e].icon?g[e].icon:n}function c(e){e.stateText=i.getItemStateText(e)}function u(e,n){t.sendCommand({itemName:e.name},n),c(e)}var g={Alarm:{},Battery:{},Blinds:{},ColorLight:{label:"Color",icon:"wb_incandescent"},Contact:{},DimmableLight:{label:"Brightness",icon:"wb_incandescent",showSwitch:!0},CarbonDioxide:{label:"CO2"},Door:{},Energy:{},Fan:{},Fire:{},Flow:{},GarageDoor:{},Gas:{},Humidity:{},Light:{},Motion:{},MoveControl:{},Player:{},PowerOutlet:{},Pressure:{},Rain:{},Recorder:{},Smoke:{},SoundVolume:{label:"Volume",icon:"volume_up"},Switch:{},Temperature:{label:"Temperature"},Water:{},Wind:{},Window:{},Zoom:{}};return{sendCommand:u,getIcon:l,getLabel:s,isOptionList:a,showSwitch:r,updateStateText:c,onStateChange:o}}angular.module("PaperUI.control").factory("controlItemService",e),e.$inject=["$timeout","itemService","eventService","util"]}(),function(){"use strict";function e(e){e.when("/control",{templateUrl:"partials/control/control.html",controller:"ControlPageController",title:"Control",simpleHeader:!0,reloadOnSearch:!1})}angular.module("PaperUI.control").config(["$routeProvider",e])}();var firmwareControllers=angular.module("PaperUI.controllers.firmware",["PaperUI.filters.firmware"]);firmwareControllers.controller("FirmwareController",["$scope","$mdDialog","toastService","eventService","thingService","FIRMWARE_STATUS",function(e,t,n,i,o,r){e.updatingFirmware=!1,e.percentComplete=0,e.updateStep,e.firmwareStatus,e.firmwares=[],e.fvdetails=!1;var a=e.path[4],s=function(t){e.firmwareStatus=null,t&&o.getFirmwareStatus({thingUID:t},function(t){e.firmwareStatus=t});var t=e.$parent.thing.thingUID;t&&o.getFirmwares({thingUID:t},function(t){e.firmwares=t})};s(a),e.installFirmware=function(t){e.updatingFirmware||o.installFirmware({thingUID:a,firmwareVersion:t},function(){e.updatingFirmware=!0,e.percentComplete=0},function(e){n.showDefaultToast("Error: "+e.data.error.message)})},e.showChangelog=function(n){var i=e.firmwares.filter(function(e){return e.version===n})[0].changelog;t.show({controller:"ChangelogDialogController",templateUrl:"partials/firmware/dialog.changelog.html",targetEvent:event,hasBackdrop:!0,locals:{changelog:i,firmwareVersion:n}})},e.isFirmwareUpdateable=function(e){return e&&e.status==r.UPDATE_EXECUTABLE&&e.updatableVersion},e.hasChangelog=function(t){if(t&&t.updatableVersion){var n=e.firmwares.filter(function(e){return e.version===t.updatableVersion})[0].changelog;return void 0!==n&&null!==n&&""!==n}return!1},i.onEvent("smarthome/things/*/firmware/update/progress",function(t,n){n&&n.progress&&(100==n.progress&&(e.updatingFirmware=!1),e.$apply(function(){e.percentComplete=n.progress,e.updateStep=n.progressStep}))}),i.onEvent("smarthome/things/*/firmware/update/result",function(t,i){i&&"SUCCESS"==i.result?(e.$parent.getThing(function(){s(a)}),n.showDefaultToast("Firmware updated successfully.")):(e.$parent.getThing(function(){s(a)}),n.showDefaultToast("Firmware update failed."))}),i.onEvent("smarthome/things/*/firmware/status",function(t,n){n&&(e.firmwareStatus.status=n.firmwareStatus,n.updatableFirmwareUID&&n.updatableFirmwareUID.firmwareVersion?e.firmwareStatus.updateableVersion=n.updatableFirmwareUID.firmwareVersion:e.firmwareStatus.updateableVersion=null)})}]).controller("ChangelogDialogController",["$scope","$mdDialog","firmwareVersion","changelog",function(e,t,n,i){e.changelog=i,e.firmwareVersion=n,e.close=function(){t.hide()}}]),angular.module("PaperUI.controllers.rules",["ui.sortable","PaperUI.controllers.extension"]).controller("RulesPageController",["$scope","$location","$mdDialog","toastService","$timeout","templateRepository",function(e,t,n,i,o,r){function a(n){r.getOne(function(e){return e.uid==n},function(n){n?t.path("rules/template/"+n.uid):(i.showDefaultToast("Rule template could not be found."),e.inProgress=!1)})}e.navigateTo=function(e){t.path("rules/"+e)},e.inProgress=!1,e.openDialog=function(e,t,i){n.show({controller:e,templateUrl:t,targetEvent:i.event,hasBackdrop:!0,locals:i})},e.getRuleJSON=function(e,t,n,i){var o={tags:[],conditions:e.getModuleJSON("condition"),description:i,name:n,triggers:e.getModuleJSON("trigger"),configDescriptions:[],actions:e.getModuleJSON("action")};return t&&(o.uid=t),o},e.installRuleExtenstion=function(t,n){n?a(t):(e.install(t),o(function(){e.inProgress=!1},3e4),e.inProgress=!0)},e.$on("RuleExtensionFailed",function(){e.inProgress=!1}),e.$on("RuleExtensionInstalled",function(e,t){a(t)})}]).controller("RulesController",["$scope","$timeout","ruleRepository","ruleService","toastService","extensionService","sharedProperties",function(e,t,n,i,o,r,a){function s(e){return"DISABLED"!==e.status.statusDetail}e.setHeaderText("Shows all rules."),e.ruleOptions=["New rule","Rule from template"],e.rules=[],e.isEnabled=s,e.refresh=function(t){n.getAll(null,t).then(function(t){e.rules=t}),r.getAll(function(t){var n=$.grep(t,function(e){return"ruletemplate"==e.type}).length>0;n&&e.ruleOptions.push("Rule from catalog")})},e.configure=function(t){e.navigateTo("configure/"+t.uid)},e.remove=function(t,n){n.stopImmediatePropagation(),e.openDialog("RuleRemoveController","partials/dialog.remove.html",{event:n,rule:t})},e.refresh(!1),e.removePart=function(e,t){a.removeFromArray(e,t)},e.toggleEnabled=function(e,t){t.stopImmediatePropagation();var n=!s(e);i.setEnabled({ruleUID:e.uid},n.toString(),function(){n?o.showDefaultToast("Rule enabled."):o.showDefaultToast("Rule disabled.")})},e.ruleOptionSelected=function(t,n){0==n?e.navigateTo("new"):1==n?e.openDialog("TemplateDialogController","partials/rules/dialog.ruletemplate.html",{event:t}):e.navigateTo("catalog")},e.runRule=function(e,t){if(t.stopImmediatePropagation(),s(e)){var n=e.uid;i.runRule({ruleUID:n},function(e){o.showDefaultToast("Rule executed.")})}},e.getRuleStatus=function(e){var t=e.status.statusDetail,n=e.status.status+(t&&"NONE"!==t?" - "+t:"");return n}}]).controller("NewRuleController",["$scope","itemRepository","ruleService","ruleRepository","toastService","$mdDialog","sharedProperties","moduleTypeService",function(e,t,n,i,o,r,a,s){function l(e){s.getByType({mtype:"trigger"}).$promise.then(function(t){a.setModuleTypes(t),a.addArray("trigger",e.triggers),a.addArray("action",e.actions),a.addArray("condition",e.conditions)})}e.setSubtitle(["New Rule"]),t.getAll(),a.reset(),e.editing=!1;var c=e.path[3];e.path[3]?(i.getOne(function(e){return e.uid===c},function(t){e.name=t.name,e.description=t.description,e.status=t.status,l(t)}),e.setTitle("Edit "+c),e.setSubtitle([]),e.editing=!0):a.getParams().length>0&&a.getParams()[0]&&(e.name=a.getParams()[0].label,e.description=a.getParams()[0].description,l(a.getParams()[0])),e.saveUserRule=function(){var t=e.getRuleJSON(a,null,e.name,e.description);n.add(t).$promise.then(function(){o.showDefaultToast("Rule added."),e.navigateTo("")})},e.updateUserRule=function(){var t=e.getRuleJSON(a,e.path[3],e.name,e.description);n.update({ruleUID:e.path[3]},t).$promise.then(function(){o.showDefaultToast("Rule updated."),e.navigateTo("")})},e.openNewModuleDialog=function(t,n){e.openDialog("addModuleDialogController","partials/rules/dialog.addmodule.html",{event:t,module:{},ruleID:e.path[3]||"",type:n})},e.openUpdateModuleDialog=function(t,n,i){e.openDialog("addModuleDialogController","partials/rules/dialog.addmodule.html",{event:t,module:i,ruleID:e.path[3]||"",type:n})},e.aTriggers=a.getTriggersArray(),e.aActions=a.getActionsArray(),e.aConditions=a.getConditionsArray(),e.sortableOptions={handle:".draggable",update:function(e,t){},axis:"y"}}]).controller("RuleConfigureController",["$scope","ruleRepository","ruleService","toastService",function(e,t,n,i){e.setSubtitle(["Configure"]);var o=e.path[3];t.getOne(function(e){return e.uid===o},function(t){e.setSubtitle(["Configure "+t.name])}),n.getModuleConfigParameter({ruleUID:o},function(t){e.script=t.content}),e.save=function(){n.setModuleConfigParameter({ruleUID:o},e.script,function(){i.showDefaultToast("Rule updated successfully."),e.navigateTo("")})}}]).controller("RuleTemplateController",["$scope","$location","templateRepository","ruleService","configService","toastService",function(e,t,n,i,o,r){e.setTitle("Configure rule");var a=e.path[3];a&&n.getOne(function(e){return e.uid==a},function(t){t&&(e.parameters=o.getRenderingModel(t.configDescriptions),e.name=t.label,e.description=t.description,e.configuration=o.setConfigDefaults({},e.parameters),e.templateUID=t.uid)}),e.saveRule=function(){e.configuration=o.replaceEmptyValues(e.configuration);var n={templateUID:e.templateUID,name:e.name,description:e.description,configuration:e.configuration};i.add(n).$promise.then(function(){r.showDefaultToast("Rule added."),t.path("rules/")})}}]).controller("TemplateDialogController",["$scope","$mdDialog","toastService","templateRepository","$location",function(e,t,n,i,o){i.getAll(function(t){e.templateData=t}),e.openConfig=function(e){t.hide(),o.path("rules/template/"+e)},e.close=function(){t.hide()}}]).controller("RuleRemoveController",["$scope","$mdDialog","toastService","ruleService","rule",function(e,t,n,i,o){e.rule=o,e.remove=function(e){i.remove({ruleUID:e},function(){t.hide(),n.showDefaultToast("Rule removed.")},function(){t.hide()})},e.close=function(){t.hide()}}]).controller("addModuleDialogController",["$rootScope","$scope","$mdDialog","moduleTypeService","sharedProperties","$filter","configService","module","ruleID","type",function(e,t,n,i,o,r,a,s,l,c){function u(e,n){i.getByType({mtype:e}).$promise.then(function(i){var o=f(i,{visibility:"VISIBLE"});"trigger"===e&&"trigger"!==c||(t.moduleData=o),n?(t.triggerData=o,t.module&&n()):u("trigger",d)})}function g(e,t){return f(e,{uid:t})}var f=r("filter");t.moduleData,t.triggerData,u(c,"trigger"===c?d:null),t.id=s.id,t.type=c,t.description="",t.module="",t.step=1,t.editMode=!1,t.configuration={},t.parameters=[];var p={};t.items=[],t.selectChip=function(e,n){var i=$('textarea[name="'+n+'"]')[0],o=i.value.substring(0,i.selectionStart),r=i.value.substring(i.selectionStart,i.value.length);t.configuration[n]=o+e.name+r};var d=function(){if(t.moduleData){var e=g(t.moduleData,t.module);e&&e.length>0&&(t.parameters=a.getRenderingModel(e[0].configDescriptions));var n=!1;angular.forEach(t.parameters,function(e){o.updateParams(e),n=$.grep(e.parameters,function(e){return"script"==e.context}).length>0});var i=o.searchArray(o.getModuleArray(c),t.id);if(i!==-1&&(t.configuration=a.convertValues(o.getModuleArray(c)[i].configuration),angular.copy(t.configuration,p)),t.configuration=a.setConfigDefaults(t.configuration,t.parameters),n&&"trigger"!==c){var r=o.getModuleArray("trigger");if(angular.forEach(r,function(e,n){var i=g(t.triggerData,e.type);i&&i.length&&(t.items=t.items.concat(i[0].outputs))}),"action"==c)for(var s=o.getModuleArray("action"),l=o.searchArray(s,t.id),u=0;u<l;u++){var f=g(t.moduleData,s[u].type)[0];f&&f.outputs&&f.outputs.length&&(t.items=t.items.concat(f.outputs))}}}};t.id&&(t.editMode=!0,t.module=s.type,t.name=s.label,t.description=s.description,d(),t.step=2),t.parameters=o.getParams(),t.close=function(){o.resetParams();var e=o.searchArray(o.getModuleArray(c),t.id);e!==-1&&(o.getModuleArray(c)[e].configuration=p),n.hide()},t.saveModule=function(){var e=g(t.moduleData,t.module);if(null!=e&&e.length>0){e[0].label=t.name;var i=a.setConfigDefaults(t.configuration,t.parameters,!0);i=a.replaceEmptyValues(i);var r={id:t.id,label:t.name,description:t.description,type:e[0].uid,configuration:i};o.updateModule(t.type,r)}o.resetParams(),n.hide()},t.deleteModule=function(e){o.removeFromArray(e,t.id),o.resetParams(),n.hide()},t.secondStep=function(){var e=g(t.moduleData,t.module);null!==e&&e.length&&(t.name=e[0].label,t.description=e[0].description,d(),t.step=2)}}]).directive("mdChips",function(){return{restrict:"E",require:"mdChips",link:function(e,t,n,i){function o(){for(var e=t[0].getElementsByClassName("md-chip-content"),n=0;n<e.length;n++)e[n].addEventListener("blur",function(){i.$scope.$apply()})}setTimeout(o,500)}}}).directive("dragdrop",function(){return{restrict:"AE",replace:!0,template:'<span class="draggable md-icon-reorder"></span>',link:function(e,t,n){var i=function(e){var t=e.changedTouches[0],n=document.createEvent("MouseEvent");n.initMouseEvent({touchstart:"mousedown",touchmove:"mousemove",touchend:"mouseup"}[e.type],!0,!0,window,1,t.screenX,t.screenY,t.clientX,t.clientY,!1,!1,!1,!1,0,null),t.target.dispatchEvent(n),e.preventDefault()};t[0].addEventListener("touchstart",i,!0),t[0].addEventListener("touchmove",i,!0),t[0].addEventListener("touchend",i,!0),t[0].addEventListener("touchcancel",i,!0)}}}).directive("scriptarea",function(){return{restrict:"A",require:"ngModel",link:function(e,t,n,i){function o(){var e=document.getElementsByName(n.name);if(e&&e.length>0){var t=e[0].value;t&&(t.length<r.ngMinlength||t.length>r.ngMaxlength)?a.addClass("border-invalid"):void 0!==t&&""!=t||!r.ngRequired?a.removeClass("border-invalid"):a.addClass("border-invalid")}}t.ready(function(){setTimeout(function(){t[0].style.cssText="height:auto;",t[0].style.cssText="height:"+t[0].scrollHeight+"px"},500)});var r=n,a=t,s=function(e){t[0].style.cssText="height:auto;",t[0].value.length<1?t[0].style.cssText="height:35px":t[0].style.cssText="height:"+t[0].scrollHeight+"px",o()};t[0].addEventListener("keydown",s,!0),t[0].addEventListener("input",s,!0),t[0].addEventListener("cut",s),t[0].addEventListener("blur",function(){o()})}}}),angular.module("PaperUI.controllers.extension",["PaperUI.constants"]).controller("ExtensionPageController",["$scope","$routeParams","extensionService","bindingRepository","thingTypeRepository","eventService","toastService","$filter","$window","$timeout","$location","templateRepository",function(e,t,n,i,o,r,a,s,l,c,u,g){function f(){function t(t){var n=t;e.$watch(function(){return e.searchText[n]},function(t,n){!e.showCards||void 0!==t&&t===n||e.masonry(!0)})}for(var n=0;n<e.searchText.length;n++)t(n)}e.navigateTo=function(e){u.path("extensions/"+e)},e.selectedIndex;var p=t.tab;e.extensionTypes=[];var d=window.localStorage.getItem("paperui.extension.view");e.showCards=!!d&&"LIST"!=d.toUpperCase(),e.searchText=[],e.refresh=function(){n.getAllTypes(function(t){if(e.extensionTypes=[],e.searchText=new Array(t.length),f(),angular.forEach(t,function(t){e.extensionTypes.push({typeId:t.id,label:t.label,extensions:[],inProgress:!1})}),n.getAll(function(t){angular.forEach(t,function(t){var n=e.getType(t.type);void 0!==n&&n.extensions.push(t)}),angular.forEach(e.extensionTypes,function(e){e.extensions=s("orderBy")(e.extensions,"label")})}),p){var i=e.extensionTypes.find(function(e){return e.typeId.toUpperCase()===p.toUpperCase()});e.selectedIndex=i?e.extensionTypes.indexOf(i):0}})},e.onTabSelected=function(t){e.masonry(e.showCards),u.path("/extensions").search("tab",t.typeId)},e.changeView=function(t){t?window.localStorage.setItem("paperui.extension.view","card"):window.localStorage.setItem("paperui.extension.view","list"),e.showCards=t},e.getType=function(t){var n;return angular.forEach(e.extensionTypes,function(e){e.typeId===t&&(n=e)}),n},e.getExtension=function(t){var n;return angular.forEach(e.extensionTypes,function(e){angular.forEach(e.extensions,function(e){e.id===t&&(n=e)})}),n},e.refresh(),e.install=function(t){var r=e.getExtension(t);r.inProgress=!0,n.install({id:t}),i.setDirty(!0),o.setDirty(!0)},e.installExtensionFromURL=function(e){return n.installFromURL({url:e})},e.uninstall=function(t){var r=e.getExtension(t);r.inProgress=!0,n.uninstall({id:t}),i.setDirty(!0),o.setDirty(!0)},e.openExternalLink=function(e){e&&l.open(e,"_blank")},e.filterItems=function(t){return function(n){var i=e.searchText[e.selectedIndex];if(i&&i.length>0){for(var o=0;o<t.length;o++)if(n[t[o]]&&n[t[o]].toUpperCase().indexOf(i.toUpperCase())!=-1)return!0;return!1}return!0}},e.masonry=function(t){t&&c(function(){var t="#extensions-"+(e.selectedIndex?e.selectedIndex:0);new Masonry(t,{})},1,!0)},r.onEvent("smarthome/extensions/*",function(t,n){var i=n;n&&Array.isArray(n)&&(i=n[0]);var o=e.getExtension(i);if(o)if(o.inProgress=!1,t.indexOf("uninstalled")>-1)o.installed=!1,a.showDefaultToast("Extension "+o.label+" uninstalled.");else if(t.indexOf("installed")>-1)o.installed=!0,a.showDefaultToast("Extension "+o.label+" installed."),"ruletemplate"==o.type&&e.$broadcast("RuleExtensionInstalled",o.id);else{var r=Array.isArray(n)?n[1]:"Install or uninstall of extension "+o.label+" failed.";a.showDefaultToast(r),e.$broadcast("RuleExtensionFailed")}})}]).directive("droppable",["toastService",function(e){return{restrict:"A",link:function(t,n,i){t.ondrag=!1;var o=0;n[0].addEventListener("dragover",function(e){e.preventDefault()}),n[0].addEventListener("dragenter",function(e){e.preventDefault(),0==o&&t.$apply(function(){t.ondrag=!0}),o++}),n[0].addEventListener("dragleave",function(e){e.preventDefault(),o--,0==o&&t.$apply(function(){t.ondrag=!1})}),n[0].addEventListener("drop",function(n){n.preventDefault();var i=n.dataTransfer.getData("Text"),o=t.installExtensionFromURL(i);o.$promise.then(function(){e.showDefaultToast("Extension installed from URL"),t.ondrag=!1},function(){e.showDefaultToast("Extension installation from URL failed"),t.ondrag=!1})})}}}]),angular.module("PaperUI.things").controller("ViewThingController",["$scope","$mdDialog","$location","toastService","thingTypeService","thingRepository","thingService","linkService","channelTypeRepository","configService","thingConfigService","util","itemRepository","channelTypeService","configDescriptionService","profileTypeService",function(e,t,n,i,o,r,a,s,l,c,u,g,f,p,d,m){function h(t,n,o){s.link({itemName:t.itemName,channelUID:t.channelUID},t,function(){e.getThing(!0);var r=$.grep(e.items,function(e){return e.name==t.itemName});n.items=n.items?n.items:[],r.length>0?n.items.push(r[0]):n.items.push({name:o.itemName,label:o.label}),i.showDefaultToast("Channel linked")})}function v(t,n){var i=y(e.thing.label);if(t){var o=t.split("#");o.length>1&&o[0].length>0&&(i+="_"+y(o[0])),i+="_"+y(n)}return i}function y(e){var t="";if(e)for(var n=e.split(/[^a-zA-Z0-9_]/g),i=0;i<n.length;i++)n[i]&&n[i].length>0&&(t+=n[i][0].toUpperCase()+(n[i].length>1?n[i].substring(1,n[i].length):""));return t}function I(t){var n=t.filter(function(t){var n=e.getChannelTypeByUID(t.channelTypeUID);return n&&n.advanced});return n.length>0}function T(t){if(t.properties){var n=t.properties.firmwareVersion;Object.keys(t.properties).length>0&&!n||Object.keys(t.properties).length>1&&n?e.thing.hasProperties=!0:e.thing.hasProperties=!1}else e.thing.hasProperties=!1}function b(){o.getByUid({thingTypeUID:e.thingTypeUID},function(t){e.thingType=t,t&&(e.thingTypeChannels=t.channels&&t.channels.length>0?t.channels:t.channelGroups,e.setHeaderText(t.description)),e.refreshChannels(e.showAdvanced)})}e.setSubtitle(["Things"]);var D=e.path[4];e.thingTypeUID=null,e.advancedMode,e.thing,e.thingType,e.thingChannels=[],e.showAdvanced=!1,e.channelTypes,e.items,e.navigateTo=function(e){e.startsWith("/")?n.path(e):n.path("configuration/things/"+e)},l.getAll(function(t){e.channelTypes=t,e.refreshChannels(!1)}),f.getAll(function(t){e.items=t}),e.remove=function(n,i){i.stopImmediatePropagation(),t.show({controller:"RemoveThingDialogController",templateUrl:"partials/things/dialog.removething.html",targetEvent:i,hasBackdrop:!0,locals:{thing:n}}).then(function(){e.navigateTo("")})},e.enableChannel=function(t,n,o,r){var a=e.getChannelById(n);o.stopImmediatePropagation(),e.advancedMode||"TRIGGER"===a.kind?a.linkedItems&&a.linkedItems.length>0?e.getLinkedItems(a,o):e.linkChannel(n,o,r):0==a.linkedItems.length&&s.link({itemName:e.thing.UID.replace(/[^a-zA-Z0-9_]/g,"_")+"_"+n.replace(/[^a-zA-Z0-9_]/g,"_"),channelUID:e.thing.UID+":"+n},function(t){e.getThing(!0),i.showDefaultToast("Channel linked")})},e.disableChannel=function(t,n,o,r){var a=e.getChannelById(n);r.stopImmediatePropagation();var l=a.linkedItems[0];o&&""!==o||(o=l),e.advancedMode||"TRIGGER"===a.kind?e.unlinkChannel(n,o,r):s.unlink({itemName:e.thing.UID.replace(/[^a-zA-Z0-9_]/g,"_")+"_"+n.replace(/[^a-zA-Z0-9_]/g,"_"),channelUID:e.thing.UID+":"+n},function(){e.getThing(!0),i.showDefaultToast("Channel unlinked")})},e.editChannel=function(n,o,r,a){var l=e.getChannelById(o);a.stopImmediatePropagation(),s.getLink({itemName:r,channelUID:l.uid}).$promise.then(function(e){d.getByUri({uri:"link:"+r+" -> "+l.uid}).$promise.then(function(n){var o=e.configuration;t.show({controller:"ProfileEditDialogController",controllerAs:"$ctrl",templateUrl:"partials/things/dialog.link-edit.html",targetEvent:a,hasBackdrop:!0,locals:{linkConfigDescription:n,link:e,channel:l}}).then(function(t){if(t){var n=JSON.stringify(e.configuration)===JSON.stringify(o);n||(e.configuration&&"system:default"==e.configuration.profile&&delete e.configuration.profile,s.link({itemName:e.itemName,channelUID:e.channelUID},e,function(e){i.showDefaultToast("Link configuration updated")},function(){i.showDefaultToast("Could not update link configuration.")}))}})})})},e.linkChannel=function(n,i,o){var r=e.getChannelById(n),a=e.getChannelTypeByUID(r.channelTypeUID);link={channelUID:r.uid,configuration:{profile:void 0},itemName:void 0};var s={linkedItems:r.linkedItems&&r.linkedItems.length>0?r.linkedItems:"",acceptedItemTypes:r.acceptedItemTypes,category:a&&a.category?a.category:"",suggestedName:v(n,r.label),suggestedLabel:r.label,suggestedCategory:a&&a.category?a.category:"",preSelectCreate:o,allowNewItemCreation:e.advancedMode,link:link,channel:r};t.show({controller:"LinkChannelDialogController",templateUrl:"partials/things/dialog.linkchannel.html",targetEvent:i,hasBackdrop:!0,params:s}).then(function(e){if(e){link.itemName=e.itemName;var n=link.configuration.profile;n&&d.getByUri({uri:"profile:"+n}).$promise.then(function(n){t.show({controller:"ProfileEditDialogController",controllerAs:"$ctrl",templateUrl:"partials/things/dialog.profile-edit.html",targetEvent:i,hasBackdrop:!0,locals:{linkConfigDescription:void 0,link:link,channel:r}}).then(function(t){if(t)h(link,r,e);else{var n={profile:link.configuration.profile};link.configuration=n,h(link,r,e)}})},function(){h(link,r,e)})}})},e.getKeysArray=function(e){return Object.keys(e)},e.unlinkChannel=function(n,o,r){var a=e.getChannelById(n);t.show({controller:"UnlinkChannelDialogController",templateUrl:"partials/things/dialog.unlinkchannel.html",targetEvent:r,hasBackdrop:!0,locals:{itemName:o}}).then(function(){o&&s.unlink({itemName:o,channelUID:e.thing.UID+":"+n},function(){e.getThing(!0);var t=$.grep(a.items,function(e){return e.name==o});t.length>0&&a.items.splice(a.items.indexOf(t[0]),1),i.showDefaultToast("Channel unlinked")})})},e.getChannelById=function(t){if(e.thing)return $.grep(e.thing.channels,function(e,n){return t==e.id})[0]},e.getChannelTypeByUID=function(t){return u.getChannelTypeByUID(e.thingType,e.channelTypes,t)},e.getChannelFromChannelTypes=function(t){if(e.channelTypes)return u.getChannelFromChannelTypes(e.channelTypes,t)};var C=function(t){if(e.thingType&&e.thing&&e.channelTypes){e.isAdvanced=I(e.thing.channels);var n=u.getThingChannels(e.thing,e.thingType,e.channelTypes,t),i=[];return angular.forEach(n,function(e){angular.forEach(e.channels,function(e){if("TRIGGER"!==e.kind)return e.acceptedItemTypes=[e.itemType],!0;if(i[e.channelTypeUID])return e.acceptedItemTypes=i[e.channelTypeUID],!0;var t=[];p.getLinkableItemTypes({channelTypeUID:e.channelTypeUID},function(n){n&&n.length>0?angular.forEach(n,function(e){t.push(e)}):e.itemType&&t.push(e.itemType)}),i[e.channelTypeUID]=t,e.acceptedItemTypes=t})}),n}};e.refreshChannels=function(t){e.thingChannels=C(t)},e.getThing=function(t){r.getOne(function(e){return e.UID===D},function(t){angular.forEach(t.channels,function(t,n){t.showItems=!!e.thing&&e.thing.channels[n].showItems,t.items=e.thing?e.thing.channels[n].items:null}),e.thing=t,T(t),e.thingTypeUID=t.thingTypeUID,b(),e.setSubtitle(["Things",t.label])},t)},e.getThing(!0),e.configChannel=function(e,n,i){d.getByUri({uri:"channel:"+e.uid},function(o){t.show({controller:"ChannelConfigController",templateUrl:"partials/things/dialog.channelconfig.html",targetEvent:i,hasBackdrop:!0,locals:{channelType:o,channel:e,thing:n}})})},e.getLinkedItems=function(t){t.showItems=!t.showItems,(t.showItems&&null===t.items||void 0===t.items)&&(t.items=$.grep(e.items,function(e){return $.grep(t.linkedItems,function(t){return t==e.name}).length>0}))},e.showDescription=function(e,n){var i=e.description?e.description:e.channelType?e.channelType.description:null;i&&(popup=t.alert({title:e.label?e.label:e.channelType?e.channelType.label:e.id,textContent:i,ok:"Close"}),t.show(popup))},e.$watch("thing.channels",function(){e.refreshChannels(e.showAdvanced)}),e.isExtensible=function(){var t=e.thingType;return t&&t.extensibleChannelTypeIds&&t.extensibleChannelTypeIds.length>0},e.isExtensibleChannel=function(t){if(!t||!e.isExtensible())return!1;var n=t.split(":")[1];return e.thingType.extensibleChannelTypeIds.indexOf(n)>=0},e.addChannel=function(n){t.show({controller:"AddChannelController",templateUrl:"partials/things/dialog.addchannel.html",targetEvent:n,hasBackdrop:!0,locals:{thing:e.thing,thingType:e.thingType}})},e.removeChannel=function(n,i){i.stopImmediatePropagation(),t.show({controller:"RemoveChannelDialogController",templateUrl:"partials/things/dialog.removechannel.html",targetEvent:i,hasBackdrop:!0,locals:{thing:e.thing,channel:n}}).then(function(){e.getThing(!1)})}}]).controller("AddChannelController",["$scope","$mdDialog","toastService","channelTypeRepository","configService","thingService","thingType","thing",function(e,t,n,i,o,r,a,s){e.channelTypes=[],e.parameters=void 0,e.channelType=void 0,e.channelId=void 0,e.channelLabel=void 0,e.configuration={};var l=function(){angular.forEach(a.extensibleChannelTypeIds,function(t){var n=s.UID.split(":")[0]+":"+t;i.getOne(function(e){return e.UID===n},function(t){e.channelTypes.push(t)})})};e.$watch("channelType",function(){e.channelType&&(e.parameters=o.getRenderingModel(e.channelType.parameters,e.channelType.parameterGroups))}),e.close=function(){t.cancel()},e.save=function(){var i={uid:s.UID+":"+e.channelId,id:e.channelId,channelTypeUID:e.channelType.UID,itemType:e.channelType.itemType,label:e.channelLabel,configuration:e.configuration,defaultTags:e.channelType.tags,linkedItems:[]};s.channels.push(i),r.update({thingUID:s.UID},s,function(){t.hide(),n.showSuccessToast("Channel added.")},function(){t.hide(),n.showErrorToast("Error adding channel.")})},l()}]).controller("RemoveChannelDialogController",["$scope","$mdDialog","toastService","thingService","thing","channel",function(e,t,n,i,o,r){e.channel=r,e.close=function(){t.cancel()},e.remove=function(){var e=o.channels.indexOf(r);o.channels.splice(e,1),i.update({thingUID:o.UID},o,function(){t.hide(),n.showSuccessToast("Channel removed.")},function(){t.hide(),n.showErrorToast("Error removing channel.")})}}]),angular.module("PaperUI.things").controller("RemoveThingDialogController",["$scope","$mdDialog","toastService","thingService","thing",function(e,t,n,i,o){e.thing=o,o.statusInfo&&(e.isRemoving="REMOVING"===o.statusInfo.status),e.close=function(){t.cancel()},e.remove=function(r){var a=!!e.isRemoving;i.remove({thingUID:o.UID,force:a},function(){a?n.showDefaultToast("Thing removed (forced)."):n.showDefaultToast("Thing removal initiated."),t.hide()},function(){t.hide()})}}]).controller("LinkChannelDialogController",["$rootScope","$scope","$mdDialog","$filter","toastService","itemRepository","itemService","profileTypeRepository","sharedProperties","params",function(e,t,n,i,o,r,a,s,l,c){function u(){s.getAll().then(function(){var e=t.linkModel.configuration.profile;void 0===e||"system:default"===e?t.acceptedItemTypes=g(c.acceptedItemTypes):(profile=s.find(function(t){return t.uid==e}),t.acceptedItemTypes=profile.supportedItemTypes),r.getAll(function(e){t.items=e,t.acceptedItemTypes.length>0?t.itemsList=$.grep(t.items,function(e){return t.acceptedItemTypes.indexOf(e.type)!=-1}):t.itemsList=t.items,t.itemsList=$.grep(t.itemsList,function(e){return t.linkedItems.indexOf(e.name)==-1}),c.allowNewItemCreation&&t.itemsList.push({name:"_createNew",type:t.acceptedItemType}),t.itemsList=i("orderBy")(t.itemsList,"name")})})}t.itemName,t.linkedItems=c.linkedItems,t.advancedMode=e.advancedMode,t.category=c.category,t.itemFormVisible=!1,t.itemsList=[],t.channel=c.channel,t.linkModel=c.link;var g=function(e){var t=[],n=function(e){t.indexOf(e)<0&&t.push(e)};return angular.forEach(e,function(e){n(e),"Color"==e?(n("Switch"),n("Dimmer")):"Dimmer"==e?n("Switch"):0===e.indexOf("Number:")&&n("Number")}),t};u(),t.checkCreateOption=function(){"_createNew"==t.itemName?(t.itemFormVisible=!0,l.resetParams(),l.updateParams({linking:!0,acceptedItemType:t.acceptedItemTypes,suggestedName:c.suggestedName,suggestedLabel:c.suggestedLabel,suggestedCategory:c.suggestedCategory})):t.itemFormVisible=!1},t.createAndLink=function(){t.$broadcast("ItemLinkedClicked")},t.close=function(){n.cancel(),l.resetParams()},t.link=function(e,t){n.hide({itemName:e,label:t})},t.$on("ItemCreated",function(e,n){e.preventDefault(),n.status?t.link(n.itemName,n.label):(o.showDefaultToast("Some error occurred"),t.close())}),t.$watch(function(){return t.linkModel.configuration.profile},function(e){u()}),c.preSelectCreate&&(t.itemName="_createNew",t.checkCreateOption())}]).controller("UnlinkChannelDialogController",["$scope","$mdDialog","toastService","linkService","itemName",function(e,t,n,i,o){e.itemName=o,e.close=function(){t.cancel();
},e.unlink=function(){t.hide()}}]).controller("ChannelConfigController",["$scope","$mdDialog","toastService","thingService","configService","channelType","channel","thing",function(e,t,n,i,o,r,a,s){e.parameters=o.getRenderingModel(r.parameters,r.parameterGroups),e.configuration={},angular.copy(a.configuration,e.configuration),e.close=function(){t.cancel()},e.save=function(){a.configuration=e.configuration,i.update({thingUID:s.UID},s,function(){t.hide(),n.showDefaultToast("Channel updated")})}}]),angular.module("PaperUI.things").controller("EditThingController",["$scope","$mdDialog","$q","$location","toastService","thingRepository","configService","configDescriptionService","thingService",function(e,t,n,i,o,r,a,s,l){function c(){n(function(){e.$watch("configuration",function(){e.configuration&&e.thing&&(e.thing.configuration=e.configuration)}),r.getOne(function(e){return e.UID===g},function(t){e.thing=t,angular.copy(t,f),e.setSubtitle(["Things","Edit",t.label]),s.getByUri({uri:"thing:"+t.UID},function(t){t&&(e.parameters=a.getRenderingModel(t.parameters,t.parameterGroups),e.configuration=a.setConfigDefaults(e.thing.configuration,e.parameters))})},!0)})}function u(t){t.configuration=a.setConfigDefaults(t.configuration,e.parameters,!0),JSON.stringify(f.configuration)!==JSON.stringify(t.configuration)&&(t.configuration=a.replaceEmptyValues(t.configuration),l.updateConfig({thingUID:t.UID},t.configuration)),f.configuration=t.configuration,f.channels=t.channels,JSON.stringify(f)!==JSON.stringify(t)&&l.update({thingUID:t.UID},t),o.showDefaultToast("Thing updated"),e.navigateTo("view/"+t.UID)}e.setSubtitle(["Things"]),e.setHeaderText("Click the 'Save' button to apply the changes.");var g=e.path[4];e.thing,e.groups=[],e.isEditing=!0;var f={};e.parameters=void 0,e.configuration={},e.update=u,this.$onInit=c,e.navigateTo=function(e){e.startsWith("/")?i.path(e):i.path("configuration/things/"+e)}}]),function(){"use strict";function e(e,t,n,i,o,r,a,s,l,c){function u(){e.$watch(function(){return h.link.configuration.profile},function(e){m(e)});var t=a.find(function(e){return e.name==l.itemName});t&&(h.itemType=t.type)}function g(){d(),t.hide(!1)}function f(){return void 0!==h.parameterGroups}function p(){d(),t.hide(!0)}function d(){Object.keys(l.configuration).forEach(function(e){null===l.configuration[e]&&delete l.configuration[e]})}function m(e){if(void 0!==e){var t=e;e.includes(":")||(t="system:"+e),n.getByUri({uri:"profile:"+t}).$promise.then(function(e){h.parameterGroups=i.getRenderingModel(e.parameters,e.parameterGroups),l.configuration=i.setConfigDefaults(l.configuration,h.parameterGroups)},function(){l.configuration={profile:e},h.parameterGroups=void 0})}}var h=this;this.link=l,this.channel=c,this.linkConfigDescription=s,this.expertMode=!1,this.oldConfig=l.configuration,this.cancel=g,this.close=p,this.hasConfig=f,this.configuration=void 0,this.parameterGroups=void 0,u()}e.$inject=["$scope","$mdDialog","configDescriptionService","configService","linkService","toastService","itemRepository","linkConfigDescription","link","channel"],angular.module("PaperUI.things").controller("ProfileEditDialogController",e)}(),function(){"use strict";function e(e,t,n,i,o,r,a){function s(e){e.startsWith("/")?n.path(e):n.path("configuration/things/"+e)}function l(){a.onEvent("smarthome/things/*/removed",function(){c()}),c()}function c(){return i.getAll(function(e){angular.forEach(e,function(e){e.bindingType=e.thingTypeUID.split(":")[0]}),f.things=e,g()})}function u(){f.searchText="",e.$broadcast("ClearFilters")}function g(){o.getAll(function(e){var t=new Set;angular.forEach(f.things,function(n){var i=e.filter(function(e){return e.id===n.bindingType});t.add(i[0])}),f.bindings=Array.from(t)},!0)}var f=this;r.setTitle("Configuration"),r.setSubtitles(["Things"]),this.bindings=[],this.things,this.refresh=c,this.navigateTo=s,this.clearAll=u,this.$onInit=l}angular.module("PaperUI.things").component("thingsList",{templateUrl:"partials/things/component.things-list.html",controller:e}),e.$inject=["$scope","$timeout","$location","thingRepository","bindingRepository","titleService","eventService"]}(),function(){"use strict";function e(e,t,n,i,o,r,a){function s(){return o.onEvent("smarthome/things/"+m.thing.UID+"/statuschanged",function(e,n){t(function(){m.thing.statusInfo=n[0]},0)}),g()}function l(){o.removeListener("smarthome/things/"+m.thing.UID+"/statuschanged")}function c(t){t.startsWith("/")?e.path(t):e.path("configuration/things/"+t)}function u(){var e=m.thingTypes[m.thing.thingTypeUID];return e?e.label:""}function g(){return i.getAll(function(e){angular.forEach(e,function(e){m.thingTypes[e.UID]=e})})}function f(e,t){t.stopImmediatePropagation(),n.show({controller:"RemoveThingDialogController",templateUrl:"partials/things/dialog.removething.html",targetEvent:t,hasBackdrop:!0,locals:{thing:e}})}function p(){return m.thing&&"DISABLED"!==m.thing.statusInfo.statusDetail}function d(e){e.stopImmediatePropagation();var t=!m.isEnabled();r.enable({thingUID:m.thing.UID},t).$promise.then(function(){a.showDefaultToast("Thing "+(t?"enabled":"disabled"))})}var m=this;this.thingTypes=[],this.getThingTypeLabel=u,this.navigateTo=c,this.remove=f,this.toggleEnable=d,this.isEnabled=p,this.$onInit=s,this.$onDestroy=l}angular.module("PaperUI.things").component("thingEntry",{bindings:{thing:"<"},templateUrl:"partials/things/component.things-list-entry.html",controller:e}),e.$inject=["$location","$timeout","$mdDialog","thingTypeRepository","eventService","thingService","toastService"]}(),function(){"use strict";function e(){function e(){var e=t.statusInfo.statusDetail,n=t.statusInfo.status+(e&&"NONE"!==e?" - "+e:"");return n}var t=this;this.getThingStatus=e}angular.module("PaperUI.things").component("thingStatus",{bindings:{statusInfo:"<"},templateUrl:"partials/things/component.thing.statusInfo.html",controller:e})}(),function(){"use strict";function e(e){e.when("/configuration/things",{template:"<things-list />",title:"Configuration"}).when("/configuration/things/view/:thingUID",{templateUrl:"partials/things/configuration.things.view.html",controller:"ViewThingController",title:"Configuration"}).when("/configuration/things/edit/:thingUID",{templateUrl:"partials/things/configuration.things.html",controller:"EditThingController",title:"Configuration"})}angular.module("PaperUI.things").config(["$routeProvider",e])}(),angular.module("PaperUI.controllers.configuration",["PaperUI.constants","PaperUI.controllers.firmware","PaperUI.controllers.configurableServiceDialog"]).controller("ServicesController",["$scope","$routeParams","$mdDialog","$location","serviceConfigService","toastService",function(e,t,n,i,o,r){e.setSubtitle(["Services"]),e.setHeaderText("Shows all configurable services."),e.tabs=[],e.selectedTabIndex;var a=t.tab;e.navigateTo=function(e){i.path("/configuration/services/"+e)},e.refresh=function(){var t={};o.getAll(function(n){angular.forEach(n,function(e){return"system"===e.category||(void 0===t[e.category]&&(t[e.category]={services:[],category:e.category}),void t[e.category].services.push(e))});var i=[];if(angular.forEach(t,function(e){i.push(e)}),i=i.sort(function(e,t){return e.category<t.category?-1:e.category>t.category?1:0}),e.tabs=i,a){var o=e.tabs.find(function(e){return e.category.toUpperCase()===a.toUpperCase()});e.selectedTabIndex=o?e.tabs.indexOf(o):0}})},e.configure=function(e,t,i){n.show({controller:"ConfigurableServiceDialogController",templateUrl:"partials/services/dialog.configureservice.html",targetEvent:i,hasBackdrop:!0,locals:{serviceId:e,configDescriptionURI:t,multiple:!1}})},e.onSelectedTab=function(e){i.path("/configuration/services").search("tab",e.category)},e.refresh()}]).controller("MultiServicesController",["$scope","$mdDialog","$location","$routeParams","serviceConfigService","toastService",function(e,t,n,i,o,r){e.setSubtitle(["Services"]),e.setHeaderText("Shows all multiple configurable services."),e.servicePID=i.servicePID,e.serviceContexts=[],e.navigateTo=function(e){n.path("/configuration/services/"+e)},e.configure=function(n,i){t.show({controller:"ConfigurableServiceDialogController",templateUrl:"partials/services/dialog.configureservice.html",targetEvent:i,hasBackdrop:!0,locals:{serviceId:n,configDescriptionURI:e.serviceConfigDescriptionURI,multiple:!0}}).then(function(){e.refresh()})},e.deleteConfig=function(n,i){t.show({controller:"ServiceConfigRemoveController",templateUrl:"partials/dialog.remove.html",targetEvent:i,hasBackdrop:!0,locals:{serviceContext:n}}).then(function(){e.refresh()})},o.getById({id:e.servicePID},function(t){e.serviceLabel=t.label,e.setSubtitle(["Services",t.label]),e.serviceConfigDescriptionURI=t.configDescriptionURI}),e.refresh=function(){o.getContexts({id:e.servicePID},function(t){e.serviceContexts=t})},e.refresh()}]).controller("ServiceConfigRemoveController",["$scope","$mdDialog","$filter","$location","toastService","serviceConfigService","serviceContext",function(e,t,n,i,o,r,a){e.serviceContext=a,e.remove=function(){r.deleteConfig({id:a.id},function(){o.showDefaultToast("Service config removed.")}),t.hide()},e.close=function(){t.cancel()}}]),angular.module("PaperUI.controllers.configuration").controller("SystemController",["$scope","$mdDialog","serviceConfigService","toastService",function(e,t,n,i){e.setSubtitle(["System"]),e.setHeaderText("Shows all system configurations."),e.tabs=[],e.refresh=function(){n.getAll(function(t){e.services=$.grep(t,function(e){return e.category&&"SYSTEM"===e.category.toUpperCase()}),angular.forEach(e.services,function(e){e.found=!0})})},e.$on("noConfigDesc",function(t,n){var i=$.grep(e.services,function(e){return e.id==n});i[0].found=!1,t.stopPropagation(),t.preventDefault()}),e.refresh()}]).controller("ConfigureSystemServiceController",["$rootScope","$scope","$mdDialog","configService","serviceConfigService","configDescriptionService","toastService",function(e,t,n,i,o,r,a){function s(e){for(var t in e)e.hasOwnProperty(t)&&(void 0!==e[t]&&null!==e[t]||(e[t]=""));return e}t.editing=!1,t.service=null,t.parameters=[],t.configuration={},t.config={},t.serviceId,t.configDescriptionURI;var l={};t.getConfigDescription=function(){var e=t.serviceId,n=t.configDescriptionURI;n&&r.getByUri({uri:n},function(e){e&&(t.parameters=i.getRenderingModel(e.parameters,e.parameterGroups),t.configuration=i.setConfigDefaults(t.configuration,t.parameters),t.configuration=s(t.configuration),angular.copy(t.configuration,l))},function(){t.$emit("noConfigDesc",e)}),e&&(o.getById({id:e},function(e){t.service=e}),o.getConfigById({id:e}).$promise.then(function(e){e&&(t.configuration=i.convertValues(e),t.parameters&&t.parameters.length>0&&(t.configuration=i.setConfigDefaults(t.configuration,t.parameters),angular.copy(t.configuration,l)))}))},t.save=function(){if(JSON.stringify(t.configuration)!==JSON.stringify(l)){var n={},n=i.setConfigDefaults(t.configuration,t.parameters,!0);o.updateConfig({id:t.serviceId},n,function(){angular.copy(t.configuration,l),"org.eclipse.smarthome.links"===t.serviceId&&(e.advancedMode=jQuery.isEmptyObject(t.configuration)?e.advancedMode:!t.configuration.autoLinks),a.showDefaultToast("System config updated.")})}t.editing=!1},t.$watch("configuration",function(){t.configuration&&(JSON.stringify(t.configuration)!==JSON.stringify(l)?t.editing=!0:t.editing=!1)},!0)}]),function(){"use strict";angular.module("PaperUI.items",["ngRoute","ngMaterial","PaperUI.directive.searchField","PaperUI.services"])}(),function(){"use strict";function e(e,t,n,i,o,r){function a(){u.parameterGroups=i.getRenderingModel(u.configDescription.parameters,u.configDescription.parameterGroups),u.configuration=i.setConfigDefaults(u.configuration,u.parameterGroups),e.$watch(function(){return u.expertMode},function(e,t){e!=t&&(u.expertMode?u.configArray=i.getConfigAsArray(u.configuration,u.parameterGroups):u.configuration=i.getConfigAsObject(u.configArray,u.parameterGroups))})}function s(){t.hide()}function l(){u.configArray.push({name:"",value:void 0})}function c(){u.expertMode&&(u.configuration=i.getConfigAsObject(u.configArray,u.parameterGroups)),u.metadata.config=i.setConfigDefaults(u.configuration,u.parameterGroups,!0),t.hide()}var u=this;this.metadata=o,this.configDescription=r,this.parameterGroups=[],this.configuration=o.config,this.configArray=[],this.expertMode=!1,this.cancel=s,this.close=c,this.addParameter=l,a()}e.$inject=["$scope","$mdDialog","configDescriptionService","configService","metadata","configDescription"],angular.module("PaperUI.items").controller("ConfigurableMetadataDialogController",e)}(),function(){"use strict";function e(){return{restrict:"E",scope:{},bindToController:{item:"="},controllerAs:"$ctrl",templateUrl:"partials/items/directive.metadata-list.html",controller:t}}function t(e,t){function n(){return e.getAll({scheme:"metadata"},function(e){i.metadataConfigDescriptions=e,i.item.metadata||(i.item.metadata={}),i.metadataConfigDescriptions.forEach(function(e){var t=i.URI2Namespace(e.uri);i.item.metadata[t]||(i.item.metadata[t]={value:void 0,config:{}})})}).$promise}var i=this;this.metadataConfigDescriptions,this.URI2Namespace=t.URI2Namespace,this.$onInit=n}angular.module("PaperUI.items").directive("metadataList",e),t.$inject=["configDescriptionService","metadataService"]}(),function(){"use strict";function e(){return{restrict:"E",scope:{},bindToController:{configDescription:"=",metadata:"="},controllerAs:"$ctrl",templateUrl:"partials/items/directive.metadata-details.html",controller:t}}function t(e,t,n,i){function o(){e.$watch(function(e){return l.metadata?l.metadata.value:void 0},function(e,t){if(l.metadata.value&&""!==l.metadata.value){var n=l.metadata.value.replace(/\s/g,"_");return i.getByUri({uri:"metadata:"+l.namespace+":"+n}).$promise.then(function(n){l.configParameterDescription=n,t&&t!=e&&(l.metadata.config={})},function(){l.configParameterDescription=void 0})}})}function r(){return l.mainParameter.options&&l.mainParameter.options.length>0}function a(){return void 0!=l.configParameterDescription}function s(e){t.show({controller:"ConfigurableMetadataDialogController",controllerAs:"$ctrl",templateUrl:"partials/items/dialog.configure-metadata.html",targetEvent:e,hasBackdrop:!0,locals:{metadata:l.metadata,configDescription:l.configParameterDescription}})}var l=this;this.namespace=n.URI2Namespace(this.configDescription.uri),this.mainParameter=this.configDescription.parameters[0],this.configParameterDescription=void 0,this.hasOptions=r,this.hasParameters=a,this.editParameters=s,this.$onInit=o}angular.module("PaperUI.items").directive("metadata",e),t.$inject=["$scope","$mdDialog","metadataService","configDescriptionService"]}(),angular.module("PaperUI.items").controller("ItemSetupController",["$scope","$timeout","$location","$mdDialog","$filter","itemRepository","toastService","sharedProperties",function(e,t,n,i,o,r,a,s){e.navigateTo=function(e){n.path("configuration/"+e)},e.setSubtitle(["Items"]),e.setHeaderText("Shows all configured Items."),e.items=[],e.groups=[],e.types=[],e.refresh=function(){r.getAll(function(t){e.items=t;for(var n=[],i=[],o=0;o<t.length;o++)t[o].type&&"Group"==t[o].type&&n.push(t[o]),t[o].type&&i.indexOf(t[o].type)==-1&&i.push(t[o].type);e.groups=n,e.types=i},!0)},e.remove=function(t,n){n.stopImmediatePropagation(),i.show({controller:"ItemRemoveController",templateUrl:"partials/dialog.remove.html",targetEvent:n,hasBackdrop:!0,locals:{item:t}}).then(function(){e.refresh()})},e.getSrcURL=function(e,t){return e?"../icon/"+e.toLowerCase():t?"../icon/"+t.toLowerCase().replace("item",""):""},e.clearAll=function(){e.searchText="",e.$broadcast("ClearFilters")},e.createItem=function(t,n){s.updateParams({selectedType:t,selectedGroup:n?n.name:""}),e.navigateTo("item/create")},e.refresh()}]).controller("ItemConfigController",["$scope","$mdDialog","$filter","$location","$q","toastService","itemService","itemConfig","itemRepository","sharedProperties",function(e,t,n,i,o,r,a,s,l,c){function u(){return o(function(t,n){l.getAll().then(function(t){e.items=t}),c.getParams().length>0&&c.getParams()[0].linking?(e.linking=!0,e.types=c.getParams()[0].acceptedItemType):e.path&&e.path.length>4&&(m.itemName=e.path[4]),m.itemName?a.getByName({itemName:m.itemName,metadata:".*"},function(n){e.item=n,p(),angular.copy(e.item,m.originalItem),e.item["function"]||(e.item["function"]={name:""}),e.item.groupType||(e.item.groupType="None"),0===e.item.type.indexOf("Number:")&&(e.item.dimension=e.item.type.substring(7,e.item.type.length),e.item.type="Number"),e.configMode="edit",e.srcURL=e.getSrcURL(e.item.category,e.item.type),e.oldCategory=e.item.category,e.setTitle("Edit "+e.item.name),e.setSubtitle([]),t()}):(e.item={editable:!0},e.item.groupNames=[],e.setTitle&&e.setTitle("Configuration"),e.setSubtitle&&e.setSubtitle(["New Item"]),e.types.length>0&&(e.item.type=e.types[0]),c.getParams().length>0&&(c.getParams()[0].linking?(e.item.name=c.getParams()[0].suggestedName,e.item.label=c.getParams()[0].suggestedLabel,e.item.category=c.getParams()[0].suggestedCategory):(c.getParams()[0].selectedType&&(e.item.type=c.getParams()[0].selectedType),c.getParams()[0].selectedGroup&&(e.item.groupNames=e.item.groupNames?e.item.groupNames:[],e.item.groupNames.push(c.getParams()[0].selectedGroup)))),e.configMode="create",t())})}function g(t){"Group"!==e.item.type?(delete e.item["function"],delete e.item.groupType):f(),e.item.dimension&&""!==e.item.dimension&&(e.item.type=e.item.type+":"+e.item.dimension,delete e.item.dimension),e.item.editable&&JSON.stringify(e.item)!==JSON.stringify(m.originalItem)&&(""==e.item.category&&(e.item.category=null),a.create({itemName:e.item.name},e.item).$promise.then(function(){return d(e.item.name,e.item.metadata,m.originalItem)}).then(function(){r.showDefaultToast(t),l.setDirty(!0),e.linking?e.$emit("ItemCreated",{status:!0,itemName:e.item.name,label:e.item.label}):i.path("configuration/items"),c.resetParams()},function(t){e.linking?e.$emit("ItemCreated",{status:!1}):i.path("configuration/items"),c.resetParams()}))}function f(){if(e.item.groupType.indexOf("None")==-1){var t=e.item["function"].name.split("_");e.item["function"].name=t[0],t.length>1&&(e.item["function"].params=[t[1],t[2]])}else delete e.item.groupType;e.item["function"]&&!e.item["function"].name&&(e.item["function"]=null)}function p(){e.item["function"]&&e.item["function"].name&&e.item["function"].params&&(e.item["function"].name+="_"+e.item["function"].params[0]+"_"+e.item["function"].params[1])}function d(e,t,n,i){return o(function(s,l){var c=!1,u=[];if(!n.metadata||JSON.stringify(t)!==JSON.stringify(n.metadata))for(var g in t)if(t.hasOwnProperty(g)&&void 0!==t[g].value&&0!==t[g].value.length&&(!n.metadata||JSON.stringify(t[g])!==JSON.stringify(n.metadata[g]))){c=!0;var f=a.updateMetadata({itemName:e,namespace:g},t[g]).$promise.then(function(){i&&r.showDefaultToast(i)});u.push(f)}c?o.all(u).then(s()):s()})}e.items=[],e.oldCategory,e.types=s.types,e.groupTypes=s.groupTypes,e.dimensions=s.dimensions,e.functions=[],e.selectedMember=null,e.selectedParent=null,e.searchText=null,e.childItems=[],e.linking=!1;var m=this;this.itemName,this.originalItem={},this.$onInit=u,e.update=function(){var t="Item updated.";e.item.editable?g(t):(d(e.item.name,e.item.metadata,m.originalItem,t),i.path("configuration/items"))},e.create=function(){g("Item created.")},e.renderIcon=function(){e.oldCategory=e.item.category,e.srcURL=e.getSrcURL(e.item.category,e.item.type)},e.searchItem=function(t){var i={name:t,type:"Group"},o=n("filter")(e.items,i);return o=n("orderBy")(o,"name"),o.indexOf(e.item.name)!=-1&&o.splice(o.indexOf(e.item.name),1),o.map(function(e){return e.name})},e.openItem=function(){i.path("configuration/item/edit/"+e.selectedItem)},e.setParentItem=function(t){t?e.selectedParent=t:e.selectedParent=null},e.setMemberItem=function(t){t?e.selectedMember=t:e.selectedMember=null},e.boxClicked=function(){e.selectedItem=null},e.$on("ItemLinkedClicked",function(t,n){t.preventDefault(),e.create()}),e.$watch("item.groupType",function(){if(e.item){var t=e.item.groupType;switch(t){case"Number":case"Dimmer":case"Rollershutter":e.functions=s.arithmeticFunctions;break;case"Contact":e.functions=s.logicalOpenClosedFunctions;break;case"DateTime":e.functions=s.dateTimeFunctions;break;default:e.functions=s.logicalOnOffFunctions}}}),e.getSrcURL=function(e,t){return e?"../icon/"+e.toLowerCase():t?"../icon/"+t.toLowerCase().replace("item",""):""}}]).controller("ItemRemoveController",["$scope","$mdDialog","$filter","$location","toastService","itemService","itemRepository","item",function(e,t,n,i,o,r,a,s){e.item=s,e.remove=function(e){r.remove({itemName:e},function(){a.setDirty(!0),o.showDefaultToast("Item removed.")}),t.hide()},e.close=function(){t.cancel()}}]).directive("itemname",function(){return{restrict:"A",require:"ngModel",link:function(e,t,n,i){function o(e){var n=a();return r(e,n)?(i.$setValidity("nameValidator",!1),t.parent().addClass("md-input-invalid")):(i.$setValidity("nameValidator",!0),null!=e&&0!=e.length&&t.parent().removeClass("md-input-invalid")),e}function r(e,t){for(var n=0;n<t.length;n++)if(t[n].name==e)return!0;return!1}function a(){return e.items}i.$parsers.push(o),setTimeout(function(){i.$viewValue&&o(i.$viewValue)})}}}).directive("mdChips",function(){return{restrict:"E",require:"mdChips",link:function(e,t,n,i){function o(){for(var e=t[0].getElementsByClassName("md-chip-content"),n=0;n<e.length;n++)e[n].addEventListener("blur",function(){i.$scope.$apply()})}function r(){e.$apply(),setTimeout(function(){e.$apply()},300)}setTimeout(o,500),e.createChip=function(e){function t(){for(var e=document.getElementsByClassName("md-chip-content"),t=0;t<e.length;t++)e[t].addEventListener("blur",r)}setTimeout(t,500)},e.removeChip=function(e){var t=document.getElementsByClassName("md-chip-content");t.length>e&&t[e].removeEventListener("blur",r)}}}}),function(){"use strict";function e(){return{URI2Namespace:t}}function t(e){var t=e.split(":");if(t.length>1)return t[1]}angular.module("PaperUI.items").factory("metadataService",e)}(),function(){"use strict";function e(e){e.when("/configuration/items",{templateUrl:"partials/items/configuration.items.html",controller:"ItemSetupController",title:"Configuration"}).when("/configuration/item/edit/:itemName",{templateUrl:"partials/items/item.config.html",controller:"ItemConfigController"}).when("/configuration/item/create",{templateUrl:"partials/items/item.config.html",controller:"ItemConfigController",title:"Create item"})}angular.module("PaperUI.items").config(["$routeProvider",e])}(),function(){"use strict";function e(e,t,n,i,o,r,a,s){function l(){s.configDescriptionURI?r.getByUri({uri:s.configDescriptionURI}).$promise.then(function(t){t&&(e.parameters=o.getRenderingModel(t.parameters,t.parameterGroups))}).then(function(){c(s)}):c(s)}function c(t){t?i.getConfigById({id:t.id}).$promise.then(function(t){e.configuration=o.convertValues(t),e.configuration=o.setConfigDefaults(e.configuration,e.parameters),e.configArray=o.getConfigAsArray(e.configuration,e.parameters)},function(t){e.configuration={},e.configArray=[]}):(e.newConfig=!0,e.expertMode=!0,e.configuration={"":""},e.configArray=[])}function u(){t.hide()}function g(){e.configArray.push({name:"",value:void 0})}function f(){e.expertMode&&(e.configuration=o.getConfigAsObject(e.configArray,e.parameters));var n=o.setConfigDefaults(e.configuration,e.parameters,!0);i.updateConfig({id:s.id},n,function(){t.hide(),a.showDefaultToast("Binding config updated.")})}e.binding=s,e.parameters=[],e.configuration={},e.configArray=[],e.newConfig=!1,e.expertMode=!1,e.addParameter=g,e.save=f,e.close=u,l(),e.$watch("expertMode",function(){e.expertMode?e.configArray=o.getConfigAsArray(e.configuration,e.parameters):e.configuration=o.getConfigAsObject(e.configArray,e.parameters)})}angular.module("PaperUI.bindings").controller("ConfigureBindingDialogController",e),e.$inject=["$scope","$mdDialog","bindingRepository","bindingService","configService","configDescriptionService","toastService","binding"]}(),function(){"use strict";function e(e){e.when("/configuration/bindings",{template:"<bindings-list />"}).when("/configuration/bindings/:bindingId",{template:"<binding-detail />"})}angular.module("PaperUI.bindings").config(["$routeProvider",e])}();var configurableServiceDialogController=angular.module("PaperUI.controllers.configurableServiceDialog",["PaperUI.services","PaperUI.services.rest","ngMaterial","PaperUI.directive.parameterDescription","PaperUI.directive.locationParameter"]);configurableServiceDialogController.controller("ConfigurableServiceDialogController",["$scope","$mdDialog","configService","serviceConfigService","configDescriptionService","toastService","serviceId","configDescriptionURI","multiple",function(e,t,n,i,o,r,a,s,l){var c=function(t){i.getById({id:t}).$promise.then(function(t){e.service=t})},u=function(t,o){i.getConfigById({id:t}).$promise.then(function(t){t&&(e.configuration=n.convertValues(t),e.configArray=n.getConfigAsArray(e.configuration))}).then(f(o))},g=function(e){var t=!1;if(angular.forEach(e.parameters,function(e){"esh.servicecontext"===e.name&&(t=!0)}),!t){var n={label:"Service Context",name:"esh.servicecontext",description:"Label to recognize this configuration",type:"TEXT",required:!0};e.parameters.splice(0,0,n)}},f=function(t){t&&o.getByUri({uri:t}).$promise.then(function(t){t&&(l&&g(t),e.parameters=n.getRenderingModel(t.parameters,t.parameterGroups),e.configuration=n.setConfigDefaults(e.configuration,e.parameters))})};e.service=null,e.parameters=[],e.configuration={},e.expertMode=!a,e.newConfig=!a,a?(c(a),u(a,s)):createEmptyConfig(),e.close=function(){t.hide()},e.addParameter=function(){e.configArray.push({name:"",value:void 0})},e.save=function(){var o={};e.expertMode&&(e.configuration=n.getConfigAsObject(e.configArray,e.parameters));var o=n.setConfigDefaults(e.configuration,e.parameters,!0);i.updateConfig({id:a?a:e.serviceId},o,function(){r.showDefaultToast("Service config updated.")}),t.hide()},e.$watch("expertMode",function(){e.expertMode?e.configArray=n.getConfigAsArray(e.configuration,e.parameters):e.configuration=n.getConfigAsObject(e.configArray,e.parameters)})}]);