/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.soa.sca.core.common.Messages;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.internal.provisional.extensions.IScaSpecificationExtension;
import org.eclipse.soa.sca.core.common.internal.wizards.ScaCompsiteWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class ScaCompsiteWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private ScaCompsiteWizardPage page;
    private IConfigurationElement configElement;

    public ScaCompsiteWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new ScaCompsiteWizardPage("MainPage", this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        Path path = new Path(String.valueOf(this.page.getCompositeName()) + ".composite");
        final IFile compositeFile = this.page.getCompositeContainer().getFile((IPath)path);
        path = new Path(String.valueOf(this.page.getCompositeName()) + ".composite_diagram");
        final IFile compositeDiagramFile = this.page.getCompositeContainer().getFile((IPath)path);
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.ScaCompsiteWizard_0, -1);
                        IScaSpecificationExtension ext = ScaCompsiteWizard.this.page.getSelectedExtension();
                        IStatus status = ext.createCompositeFile(compositeFile, ScaCompsiteWizard.this.page.getCompositeTns(), monitor);
                        monitor.worked(7);
                        if (!status.isOK()) {
                            throw new CoreException(status);
                        }
                        if (ScaCompsiteWizard.this.page.isDiagramToCreate()) {
                            monitor.subTask(Messages.ScaCompsiteWizard_1);
                            status = ext.createCompositeDiagramFile(compositeFile, compositeDiagramFile, monitor);
                            monitor.worked(7);
                            if (!status.isOK()) {
                                throw new CoreException(status);
                            }
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
            IWorkbenchPart activePart = workbenchPage.getActivePart();
            IFile fileToSelect = this.page.isDiagramToCreate() ? compositeDiagramFile : compositeFile;
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)fileToSelect);
                ((ISetSelectionTarget)activePart).selectReveal((ISelection)targetSelection);
            }
            try {
                String editorId = this.workbench.getEditorRegistry().getDefaultEditor(fileToSelect.getFullPath().toString()).getId();
                workbenchPage.openEditor((IEditorInput)new FileEditorInput(fileToSelect), editorId);
            }
            catch (PartInitException exception) {
                ScaCoreCommonPlugin.log((Exception)((Object)exception), 2);
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)org.eclipse.soa.sca.core.common.internal.Messages.ComponentTypeCreationWizard_8, (String)exception.getMessage());
            }
        }
        catch (Exception e) {
            ScaCoreCommonPlugin.log(e, 4);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
        this.setWindowTitle(Messages.ScaCompsiteWizard_2);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }
}

