/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.xmleditor.statusline;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.soa.sca.core.common.internal.ScaExtensionManager;
import org.eclipse.soa.sca.core.common.internal.editors.images.ScaImageRegistryManager;
import org.eclipse.soa.sca.core.common.internal.provisional.xmleditor.IImageRegistry;
import org.eclipse.soa.sca.core.common.utils.ScaXmlUtils;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StatusLineLabelProvider
extends LabelProvider {
    private boolean imageRegistryWasInitialized = false;
    private IImageRegistry imageRegistry;
    private final Map<String, Image> nodeNameToImage = new HashMap<String, Image>();

    public Image getImage(Object element) {
        if (element == null || !Node.class.isAssignableFrom(element.getClass())) {
            return null;
        }
        if (!this.imageRegistryWasInitialized && element instanceof Element) {
            this.imageRegistryWasInitialized = true;
            String nsUri = ((Element)element).getNamespaceURI();
            String id = ScaExtensionManager.INSTANCE.getVersionIdByNamespace(nsUri);
            this.imageRegistry = ScaImageRegistryManager.INSTANCE.getIImageRegistry(id);
        }
        Node node = (Node)element;
        String nodeName = node.getNodeName();
        Image result = null;
        if (nodeName != null) {
            ImageDescriptor desc;
            if (this.nodeNameToImage.containsKey(nodeName)) {
                result = this.nodeNameToImage.get(nodeName);
            } else if (this.imageRegistry != null && (desc = this.imageRegistry.getImageDescriptor(node)) != null) {
                result = desc.createImage();
                this.nodeNameToImage.put(nodeName, result);
            }
        }
        return result;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof Node) {
            StringBuffer s = new StringBuffer();
            Node node = (Node)element;
            while (node != null) {
                if (node.getNodeType() != 9) {
                    String name = node.getNodeName();
                    name = ScaXmlUtils.removeNamespacePrefix(name);
                    s.insert(0, name);
                }
                if ((node = node.getParentNode()) == null || node.getNodeType() == 9) continue;
                s.insert(0, '/');
            }
            return s.toString();
        }
        return "";
    }

    public void dispose() {
        for (Image img : this.nodeNameToImage.values()) {
            if (img == null) continue;
            img.dispose();
        }
        this.nodeNameToImage.clear();
        super.dispose();
    }
}

