/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;
import org.eclipse.soa.sca.sca1_0.common.Messages;
import org.eclipse.soa.sca.sca1_0.common.Sca1_0CommonPlugin;
import org.eclipse.soa.sca.sca1_0.common.utils.ScaCustomDiagnostician;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.DocumentRoot;
import org.eclipse.soa.sca.sca1_0.model.sca.Include;
import org.eclipse.soa.sca.sca1_0.model.sca.provider.ScaItemProviderAdapterFactory;

public class ScaModelUtils {
    protected AdapterFactoryEditingDomain editingDomain;

    public ScaModelUtils() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ScaItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Composite getCompositeFile(IFile file) throws InvalidScaModelException {
        try {
            URI uri = URI.createFileURI((String)file.getLocation().toString());
            Resource resource = this.editingDomain.getResourceSet().getResource(uri, true);
            DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
            return root.getComposite();
        }
        catch (Exception e) {
            throw new InvalidScaModelException(e);
        }
    }

    public static Diagnostic validate(Composite composite) {
        try {
            return new ScaCustomDiagnostician().validate((EObject)composite);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BasicDiagnostic(4, e.getMessage(), 0, Messages.ScaIncrementalBuilder_3, new Object[0]);
        }
    }

    public Composite resolveInclude(Include include, IContainer[] rootSearchContainers) {
        if (include.getName() == null) {
            return null;
        }
        String compositeName = include.getName().getLocalPart();
        String compositeTns = include.getName().getNamespaceURI();
        IContainer[] iContainerArray = rootSearchContainers;
        int n = rootSearchContainers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            List compositeFiles = ResourceUtils.getFiles((String)"composite", Arrays.asList(container));
            for (IFile file : compositeFiles) {
                if (!file.getName().equals(String.valueOf(compositeName) + ".composite")) continue;
                try {
                    Composite composite = this.getCompositeFile(file);
                    if (compositeTns != null && compositeTns.equals(composite.getTargetNamespace())) {
                        return composite;
                    }
                    composite = null;
                }
                catch (Exception e) {
                    Sca1_0CommonPlugin.log(e, 2);
                }
            }
            ++n2;
        }
        return null;
    }

    public static class InvalidScaModelException
    extends Exception {
        private static final long serialVersionUID = -5305543094858796368L;

        public InvalidScaModelException(Exception sourceException) {
            this.setStackTrace(sourceException.getStackTrace());
        }
    }
}

