/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.customactions;

import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;
import org.eclipse.soa.sca.sca1_0.diagram.customactions.Messages;
import org.eclipse.soa.sca.sca1_0.diagram.part.ScaDiagramEditorPlugin;
import org.eclipse.soa.sca.sca1_0.model.sca.SCAImplementation;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenDiagramAction
extends Action
implements IActionDelegate {
    private ShapeNodeEditPart myPart;

    public void run() {
        if (this.myPart == null) {
            return;
        }
        if (this.myPart.resolveSemanticElement() == null) {
            return;
        }
        Path path = null;
        if (this.myPart.resolveSemanticElement() instanceof SCAImplementation) {
            QName p = ((SCAImplementation)this.myPart.resolveSemanticElement()).getName();
            if (p == null) {
                ScaDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.soa.sca.sca1_0.diagram", Messages.OpenDiagramAction_0));
                return;
            }
            IFile compositeFile = ResourceUtils.getCompositeFile((String)(String.valueOf(p.getLocalPart()) + ".composite"));
            if (compositeFile != null) {
                path = new Path(String.valueOf(compositeFile.getFullPath().toString()) + "_diagram");
            }
        } else {
            ScaDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.soa.sca.sca1_0.diagram", Messages.OpenDiagramAction_1));
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        IFile fileToBeOpened = workspace.getRoot().getFile(path);
        if (fileToBeOpened == null) {
            ScaDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.soa.sca.sca1_0.diagram", Messages.OpenDiagramAction_2));
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileToBeOpened.getName());
        try {
            page.openEditor((IEditorInput)new FileEditorInput(fileToBeOpened), editorDescriptor.getId(), true);
        }
        catch (PartInitException e) {
            ScaDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.soa.sca.sca1_0.diagram", String.valueOf(Messages.OpenDiagramAction_3) + (Object)((Object)e)));
            return;
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection iss;
        if (selection != null && selection instanceof IStructuredSelection && (iss = (IStructuredSelection)selection).getFirstElement() != null && iss.getFirstElement() instanceof ShapeNodeEditPart) {
            this.myPart = (ShapeNodeEditPart)iss.getFirstElement();
        }
    }
}

