/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.soa.sca.sca1_0.diagram.edit.policies.ScaBaseItemSemanticEditPolicy;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_0.model.sca.Reference;

public class ReferencePromoteReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ReferencePromoteReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Reference)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ComponentReference) || !(this.newEnd instanceof Reference)) {
            return false;
        }
        return ScaBaseItemSemanticEditPolicy.getLinkConstraints().canExistReferencePromote_4006(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ComponentReference) || !(this.newEnd instanceof ComponentReference)) {
            return false;
        }
        return ScaBaseItemSemanticEditPolicy.getLinkConstraints().canExistReferencePromote_4006(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getPromote().remove((Object)this.getOldTarget());
        this.getNewSource().getPromote().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().getPromote().remove((Object)this.getOldTarget());
        this.getOldSource().getPromote().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Reference getOldSource() {
        return (Reference)this.referenceOwner;
    }

    protected Reference getNewSource() {
        return (Reference)this.newEnd;
    }

    protected ComponentReference getOldTarget() {
        return (ComponentReference)this.oldEnd;
    }

    protected ComponentReference getNewTarget() {
        return (ComponentReference)this.newEnd;
    }
}

