/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.soa.sca.sca1_0.diagram.edit.policies.ScaBaseItemSemanticEditPolicy;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_0.model.sca.Wire;

public class WireCreateCommand
extends CreateElementCommand {
    private final EObject source;
    private final EObject target;
    private final Composite container;

    public WireCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super((CreateElementRequest)request);
        this.source = source;
        this.target = target;
        this.container = WireCreateCommand.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof ComponentReference)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof ComponentService)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return ScaBaseItemSemanticEditPolicy.getLinkConstraints().canCreateWire_4003(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        Wire newElement = ScaFactory.eINSTANCE.createWire();
        this.getContainer().getWire().add((Object)newElement);
        newElement.setSource2(this.getSource());
        newElement.setTarget2(this.getTarget());
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(Wire newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected ComponentReference getSource() {
        return (ComponentReference)this.source;
    }

    protected ComponentService getTarget() {
        return (ComponentService)this.target;
    }

    public Composite getContainer() {
        return this.container;
    }

    private static Composite deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Composite) {
                return (Composite)element;
            }
            element = element.eContainer();
        }
        return null;
    }

    protected EObject doDefaultElementCreation() {
        Wire newElement = ScaFactory.eINSTANCE.createWire();
        this.getContainer().getWire().add((Object)newElement);
        if (this.getTarget() != null && this.getSource() != null && (this.getSource().getName() == null || "".equals(this.getSource().getName()))) {
            this.getSource().setName(this.getTarget().getName());
        }
        newElement.setSource2(this.getSource());
        newElement.setTarget2(this.getTarget());
        return newElement;
    }
}

