/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.part;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.soa.sca.sca1_0.diagram.edit.parts.ComponentEditPart;
import org.eclipse.soa.sca.sca1_0.diagram.edit.parts.CompositeCompositeAreaCompartmentEditPart;
import org.eclipse.soa.sca.sca1_0.diagram.edit.parts.CompositeEditPart;
import org.eclipse.soa.sca.sca1_0.model.sca.Component;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.Wire;
import org.eclipse.soa.sca.sca1_0.model.sca.impl.ComponentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCALayoutEditPartProvider
extends AbstractLayoutEditPartProvider {
    private static final int INITIAL_LEFT_SHIFT = 30;
    private static final int INITIAL_TOP_SHIFT = 5;
    private static final int SHIFT_BETWEEN_COMPONENTS_LEFT_RIGHT = 15;
    private static final int SHIFT_BETWEEN_COMPONENTS_UP_DOWN = 0;

    public Command layoutEditParts(GraphicalEditPart containerEditPart, IAdaptable layoutHint) {
        return this.layoutEditParts(containerEditPart.getChildren(), layoutHint);
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        List<Column> columns = this.computeColumns(selectedObjects);
        CompoundCommand cc = this.createCommand(columns);
        return cc;
    }

    private List<Column> computeColumns(List selectedObjects) {
        if (selectedObjects == null || selectedObjects.isEmpty()) {
            return new ArrayList<Column>();
        }
        ArrayList<Column> result = new ArrayList<Column>();
        ArrayList<String> managed = new ArrayList<String>();
        Hashtable<String, ComponentEditPart> cch = new Hashtable<String, ComponentEditPart>();
        Column column = null;
        if (selectedObjects.get(0) instanceof CompositeEditPart) {
            ArrayList<ComponentEditPart> list = new ArrayList<ComponentEditPart>();
            CompositeEditPart cep = (CompositeEditPart)((Object)selectedObjects.get(0));
            for (Object o : cep.getChildren()) {
                if (!(o instanceof CompositeCompositeAreaCompartmentEditPart)) continue;
                for (Object oo : ((CompositeCompositeAreaCompartmentEditPart)((Object)o)).getChildren()) {
                    if (!(oo instanceof ComponentEditPart)) continue;
                    list.add((ComponentEditPart)((Object)oo));
                }
            }
            column = this.getColumn0(list, managed, cch);
        } else {
            column = this.getColumn0(selectedObjects, managed, cch);
        }
        result.add(column);
        while (!column.components.isEmpty()) {
            if ((column = this.computeColumnN(column, managed, cch)).components.isEmpty()) continue;
            result.add(column);
        }
        return result;
    }

    private Column computeColumnN(Column column, List<String> managed, Map<String, ComponentEditPart> cch) {
        Column result = new Column();
        for (ComponentEditPart cep : column.components) {
            ComponentImpl component = (ComponentImpl)cep.resolveSemanticElement();
            for (ComponentReference ref : component.getReference()) {
                for (ComponentService cs : ref.getTarget()) {
                    String key = ((ComponentImpl)cs.eContainer()).getName();
                    if (managed.contains(key)) continue;
                    ComponentEditPart componentEP = cch.get(key);
                    result.components.add(componentEP);
                    managed.add(key);
                }
                Composite composite = (Composite)component.eContainer();
                for (Wire wire : composite.getWire()) {
                    String key;
                    ComponentService componentService;
                    if (wire == null || wire.getSource2() == null || !wire.getSource2().equals(ref) || (componentService = wire.getTarget2()) == null || managed.contains(key = ((ComponentImpl)componentService.eContainer()).getName())) continue;
                    result.components.add(cch.get(key));
                    managed.add(key);
                }
            }
        }
        return result;
    }

    private Column getColumn0(List selectedObjects, List<String> managed, Map<String, ComponentEditPart> cch) {
        ArrayList<ComponentEditPart> components = new ArrayList<ComponentEditPart>();
        for (Object next : selectedObjects) {
            ComponentEditPart componentEditPart;
            ComponentImpl component;
            if (next == null || !(next instanceof ComponentEditPart) || (component = (ComponentImpl)(componentEditPart = (ComponentEditPart)((Object)next)).resolveSemanticElement()) == null || component.getName() == null) continue;
            cch.put(component.getName(), componentEditPart);
            if (managed.contains(component.getName()) || !component.getService().isEmpty() && !this.noRefTo(component)) continue;
            components.add(componentEditPart);
            managed.add(component.getName());
        }
        return new Column(components);
    }

    private boolean noRefTo(ComponentImpl component) {
        boolean result = true;
        Composite composite = (Composite)component.eContainer();
        for (ComponentService service : component.getService()) {
            for (Wire wire : composite.getWire()) {
                if (wire == null || wire.getTarget2() == null || !wire.getTarget2().equals(service)) continue;
                result = false;
            }
            for (Component c : composite.getComponent()) {
                for (ComponentReference compRef : c.getReference()) {
                    if (compRef == null || compRef.getTarget() == null || !compRef.getTarget().contains((Object)service)) continue;
                    result = false;
                }
            }
        }
        return result;
    }

    private CompoundCommand createCommand(List<Column> columns) {
        CompoundCommand result = new CompoundCommand();
        int globalShift = 30;
        for (Column column : columns) {
            this.createCommand(column, globalShift, result);
            globalShift = globalShift + column.getMaxWidth() + 15;
        }
        return result;
    }

    private void createCommand(Column column, int newX, CompoundCommand cc) {
        int newY = 5;
        for (ComponentEditPart cp : column.components) {
            cc.add(this.createCommand((ShapeEditPart)cp, newX, newY));
            newY = newY + cp.getSize().height + 0;
        }
    }

    private Command createCommand(ShapeEditPart shapeEditPart, int newX, int newY) {
        double scale = 1.0;
        if (shapeEditPart.getRoot() instanceof DiagramRootEditPart) {
            ZoomManager zoomManager = ((DiagramRootEditPart)shapeEditPart.getRoot()).getZoomManager();
            scale = zoomManager.getZoom();
        }
        Point ptOldLocation = shapeEditPart.getFigure().getBounds().getLocation();
        Point newLocation = new Point(newX, newY);
        Dimension delta = newLocation.getDifference(ptOldLocation);
        ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"move");
        cbr.setEditParts((EditPart)shapeEditPart);
        cbr.setMoveDelta(new Point((double)delta.width * scale, (double)delta.height * scale));
        cbr.setLocation(new Point((double)newLocation.x * scale, (double)newLocation.y * scale));
        Command result = shapeEditPart.getCommand((Request)cbr);
        return result;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof ILayoutNodeOperation) {
            Node node;
            Diagram container;
            ListIterator nodes = ((ILayoutNodeOperation)operation).getLayoutNodes().listIterator();
            if (nodes.hasNext() && ((container = (node = ((ILayoutNode)nodes.next()).getNode()).getDiagram()) == null || !container.getType().equals("Sca"))) {
                return false;
            }
        } else {
            return false;
        }
        IAdaptable layoutHint = ((ILayoutNodeOperation)operation).getLayoutHint();
        String layoutType = (String)layoutHint.getAdapter(String.class);
        return "DEFAULT".equals(layoutType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Column {
        private final List<ComponentEditPart> components;

        private Column(List<ComponentEditPart> componentsC) {
            this.components = componentsC;
        }

        private int getMaxWidth() {
            int max = 0;
            for (ComponentEditPart cep : this.components) {
                if (cep.getSize().width <= max) continue;
                max = cep.getFigure().getSize().width;
            }
            return max;
        }

        private Column() {
            this.components = new ArrayList<ComponentEditPart>();
        }
    }
}

