/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.soa.sca.sca1_0.diagram.part.ScaDiagramEditorPlugin;
import org.eclipse.soa.sca.sca1_0.model.sca.DocumentRoot;
import org.eclipse.soa.sca.sca1_0.model.sca.ScaPackage;

public class ScaVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.soa.sca.sca1_0.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Sca".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return ScaVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                ScaDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ScaPackage.eINSTANCE.getDocumentRoot().isSuperTypeOf(domainElement.eClass()) && ScaVisualIDRegistry.isDiagram((DocumentRoot)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = ScaVisualIDRegistry.getModelID(containerView);
        if (!"Sca".equals(containerModelID)) {
            return -1;
        }
        if ("Sca".equals(containerModelID)) {
            containerVisualID = ScaVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (!ScaPackage.eINSTANCE.getComposite().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
            case 7001: {
                if (!ScaPackage.eINSTANCE.getService().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (!ScaPackage.eINSTANCE.getReference().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 7003: {
                if (!ScaPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 7004: {
                if (!ScaPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 7005: {
                if (ScaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (ScaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (ScaPackage.eINSTANCE.getCPPInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3026;
                }
                if (!ScaPackage.eINSTANCE.getBpelPartnerLinkType().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 7006: {
                if (ScaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (ScaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (ScaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3028;
                }
                if (!ScaPackage.eINSTANCE.getJMSBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 3029;
            }
            case 7007: {
                if (ScaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (ScaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (ScaPackage.eINSTANCE.getCPPInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3030;
                }
                if (!ScaPackage.eINSTANCE.getBpelPartnerLinkType().isSuperTypeOf(domainElement.eClass())) break;
                return 3031;
            }
            case 7008: {
                if (ScaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (ScaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (ScaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3032;
                }
                if (!ScaPackage.eINSTANCE.getJMSBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 3033;
            }
            case 7009: {
                if (!ScaPackage.eINSTANCE.getComponentService().isSuperTypeOf(domainElement.eClass())) break;
                return 3013;
            }
            case 7010: {
                if (ScaPackage.eINSTANCE.getJavaImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (ScaPackage.eINSTANCE.getSCAImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (ScaPackage.eINSTANCE.getBpelImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (ScaPackage.eINSTANCE.getCPPImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3043;
                }
                if (ScaPackage.eINSTANCE.getEJBImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3044;
                }
                if (ScaPackage.eINSTANCE.getSpringImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3045;
                }
                if (!ScaPackage.eINSTANCE.getWebImplementation().isSuperTypeOf(domainElement.eClass())) break;
                return 3046;
            }
            case 7011: {
                if (!ScaPackage.eINSTANCE.getComponentReference().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 7012: {
                if (!ScaPackage.eINSTANCE.getPropertyValue().isSuperTypeOf(domainElement.eClass())) break;
                return 3023;
            }
            case 7013: {
                if (ScaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (ScaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (ScaPackage.eINSTANCE.getCPPInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3034;
                }
                if (!ScaPackage.eINSTANCE.getBpelPartnerLinkType().isSuperTypeOf(domainElement.eClass())) break;
                return 3035;
            }
            case 7014: {
                if (ScaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (ScaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (ScaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3036;
                }
                if (!ScaPackage.eINSTANCE.getJMSBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 3037;
            }
            case 7015: {
                if (ScaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3019;
                }
                if (ScaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (ScaPackage.eINSTANCE.getCPPInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (!ScaPackage.eINSTANCE.getBpelPartnerLinkType().isSuperTypeOf(domainElement.eClass())) break;
                return 3039;
            }
            case 7016: {
                if (ScaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (ScaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3022;
                }
                if (ScaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (!ScaPackage.eINSTANCE.getJMSBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 3041;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = ScaVisualIDRegistry.getModelID(containerView);
        if (!"Sca".equals(containerModelID)) {
            return false;
        }
        if ("Sca".equals(containerModelID)) {
            containerVisualID = ScaVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 3006: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (7009 == nodeVisualID) {
                    return true;
                }
                if (7010 == nodeVisualID) {
                    return true;
                }
                if (7011 == nodeVisualID) {
                    return true;
                }
                if (7012 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7013 == nodeVisualID) {
                    return true;
                }
                if (7014 != nodeVisualID) break;
                return true;
            }
            case 3018: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7015 == nodeVisualID) {
                    return true;
                }
                if (7016 != nodeVisualID) break;
                return true;
            }
            case 3023: {
                if (5006 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3028 == nodeVisualID) {
                    return true;
                }
                if (3029 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3030 == nodeVisualID) {
                    return true;
                }
                if (3031 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3013 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3024 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3043 == nodeVisualID) {
                    return true;
                }
                if (3044 == nodeVisualID) {
                    return true;
                }
                if (3045 == nodeVisualID) {
                    return true;
                }
                if (3046 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3023 != nodeVisualID) break;
                return true;
            }
            case 7013: {
                if (3014 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 != nodeVisualID) break;
                return true;
            }
            case 7014: {
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 != nodeVisualID) break;
                return true;
            }
            case 7015: {
                if (3019 == nodeVisualID) {
                    return true;
                }
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 != nodeVisualID) break;
                return true;
            }
            case 7016: {
                if (3021 == nodeVisualID) {
                    return true;
                }
                if (3022 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ScaPackage.eINSTANCE.getWire().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        return -1;
    }

    private static boolean isDiagram(DocumentRoot element) {
        return true;
    }
}

