/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sphinx.emf.check.Check;
import org.eclipse.sphinx.emf.check.CheckValidatorRegistry;
import org.eclipse.sphinx.emf.check.CheckValidatorState;
import org.eclipse.sphinx.emf.check.ICheckValidator;
import org.eclipse.sphinx.emf.check.catalog.Catalog;
import org.eclipse.sphinx.emf.check.catalog.Category;

public class CheckMethodWrapper {
    private ICheckValidator validator;
    private Method method;
    private String signature;
    private Check checkAnnotation;

    public static Set<String> getAnnotatedCategories(Check checkAnnotation) {
        String[] categories;
        if (!(checkAnnotation == null || (categories = checkAnnotation.categories()).length <= 0 || categories.length <= 1 && categories[0].isEmpty())) {
            return new HashSet<String>(Arrays.asList(categories));
        }
        return Collections.emptySet();
    }

    public CheckMethodWrapper(ICheckValidator validator, Method method) {
        Assert.isNotNull((Object)validator);
        Assert.isNotNull((Object)method);
        this.validator = validator;
        this.method = method;
        this.signature = String.valueOf(method.getName()) + ":" + method.getParameterTypes()[0].getName();
        this.checkAnnotation = method.getAnnotation(Check.class);
    }

    public ICheckValidator getValidator() {
        return this.validator;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getAnnotatedConstraint() {
        return this.checkAnnotation.constraint();
    }

    public Set<String> getAnnotatedCategories() {
        return CheckMethodWrapper.getAnnotatedCategories(this.checkAnnotation);
    }

    private boolean isOtherCategorySelected(Set<String> selectedCategories) {
        Assert.isNotNull(selectedCategories);
        for (String categoryId : selectedCategories) {
            if (!categoryId.equals("org.eclipse.sphinx.emf.check.categories.other")) continue;
            return true;
        }
        return false;
    }

    public void invoke(CheckValidatorState state, Set<String> selectedCategories) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean wasNull;
        if (this.validator.getState().get() != null && this.validator.getState().get() != state) {
            throw new IllegalStateException("State is already assigned.");
        }
        boolean bl = wasNull = this.validator.getState().get() == null;
        if (wasNull) {
            this.validator.getState().set(state);
        }
        try {
            if (!state.checkValidationMode.shouldCheck(this.checkAnnotation.value())) {
                return;
            }
            HashSet<String> categories = new HashSet<String>();
            categories.addAll(selectedCategories);
            Catalog catalog = CheckValidatorRegistry.INSTANCE.getCheckCatalog(this.validator);
            Set<String> annotatedCategories = this.getAnnotatedCategories();
            if (annotatedCategories.isEmpty() && !this.isOtherCategorySelected(selectedCategories)) {
                return;
            }
            if (!annotatedCategories.isEmpty()) {
                categories.retainAll(annotatedCategories);
            }
            if (catalog != null && !catalog.getCategories().isEmpty()) {
                this.retainAll(categories, (EList<Category>)catalog.getCategories());
            }
            if (!categories.isEmpty() || catalog == null) {
                state.currentMethod = this.method;
                state.currentCheckType = this.checkAnnotation.value();
                state.constraint = this.getAnnotatedConstraint();
                this.method.setAccessible(true);
                this.method.invoke((Object)this.validator, state.currentObject);
            }
        }
        finally {
            if (wasNull) {
                this.validator.getState().set(null);
            }
        }
    }

    private void retainAll(Set<String> categories, EList<Category> categoryList) {
        HashSet<String> categoryIDs = new HashSet<String>();
        for (Category category : categoryList) {
            categoryIDs.add(category.getId());
        }
        categories.retainAll(categoryIDs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CheckMethodWrapper)) {
            return false;
        }
        CheckMethodWrapper mw = (CheckMethodWrapper)obj;
        return this.signature.equals(mw.signature) && this.validator == mw.validator;
    }

    public int hashCode() {
        return this.signature.hashCode() ^ this.validator.hashCode();
    }

    public String toString() {
        return "CheckMethodWrapper [method=" + this.method + "]";
    }
}

