/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.saving;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveable;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.Saveable;

public class BasicModelSaveableFilter
implements ISaveableFilter {
    protected Collection<IModelDescriptor> modelDescriptors = new HashSet<IModelDescriptor>();

    public BasicModelSaveableFilter(IProject project) {
        Assert.isNotNull((Object)project);
        this.modelDescriptors.addAll(ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project));
    }

    public BasicModelSaveableFilter(IProject project, IMetaModelDescriptor mmFilter) {
        Assert.isNotNull((Object)project);
        this.modelDescriptors.addAll(ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project, mmFilter));
    }

    public BasicModelSaveableFilter(Collection<IProject> projects) {
        Assert.isNotNull(projects);
        for (IProject project : projects) {
            this.modelDescriptors.addAll(ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project));
        }
    }

    public BasicModelSaveableFilter(Collection<IProject> projects, IMetaModelDescriptor mmFilter) {
        Assert.isNotNull(projects);
        for (IProject project : projects) {
            this.modelDescriptors.addAll(ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project, mmFilter));
        }
    }

    public boolean select(Saveable saveable, IWorkbenchPart[] containingParts) {
        IModelDescriptor modelDescriptor;
        return saveable instanceof BasicModelSaveable && this.modelDescriptors.contains(modelDescriptor = ((BasicModelSaveable)saveable).getModelDescriptor());
    }
}

