/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.outlet.providers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.preferences.OutletsPreference;

public class OutletProvider
implements IEclipsePreferences.IPreferenceChangeListener {
    private IProject project;
    private OutletsPreference outletsPreference;
    private Set<ExtendedOutlet> allOutlets;
    private Set<ExtendedOutlet> unappliedOutlets;

    public OutletProvider(OutletsPreference outletPreference) {
        this(null, outletPreference);
    }

    public OutletProvider(IProject project, OutletsPreference outletsPreference) {
        Assert.isNotNull((Object)outletsPreference);
        this.project = project;
        this.outletsPreference = outletsPreference;
        this.allOutlets = new HashSet<ExtendedOutlet>();
        this.unappliedOutlets = new HashSet<ExtendedOutlet>();
        this.allOutlets.addAll((Collection)outletsPreference.get(project));
        if (project != null) {
            outletsPreference.addPreferenceChangeListenerToProject(project, (IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public Set<ExtendedOutlet> getOutlets() {
        return Collections.unmodifiableSet(this.allOutlets);
    }

    public ExtendedOutlet getDefaultOutlet() {
        for (ExtendedOutlet outlet : this.getOutlets()) {
            if (outlet.getName() != null) continue;
            return outlet;
        }
        return null;
    }

    public Set<ExtendedOutlet> getNamedOutlets() {
        Set<ExtendedOutlet> result = this.getOutlets();
        ExtendedOutlet defaultOutlet = this.getDefaultOutlet();
        if (defaultOutlet != null) {
            result.remove(defaultOutlet);
        }
        return Collections.unmodifiableSet(result);
    }

    public void addOutlet(ExtendedOutlet outlet) {
        this.unappliedOutlets.add(outlet);
        this.allOutlets.add(outlet);
    }

    public void removeOutlet(ExtendedOutlet outlet) {
        this.unappliedOutlets.remove(outlet);
        this.allOutlets.remove(outlet);
    }

    public void setToDefault() {
        this.unappliedOutlets.clear();
        this.allOutlets.clear();
        this.allOutlets.addAll((Collection)this.outletsPreference.getDefaultValueAsObject());
    }

    public synchronized void store() {
        this.unappliedOutlets.clear();
        if (this.project != null) {
            this.outletsPreference.setInProject(this.project, this.getOutlets());
        } else {
            this.outletsPreference.setInWorkspace(this.getOutlets());
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.outletsPreference.getKey().equals(event.getKey())) {
            this.updateOutlets();
        }
    }

    protected void updateOutlets() {
        this.allOutlets.clear();
        this.allOutlets.addAll((Collection)this.outletsPreference.get(this.project));
        this.allOutlets.addAll(this.unappliedOutlets);
    }

    public void dispose() {
        if (this.project != null) {
            this.outletsPreference.removePreferenceChangeListenerFromProject(this.project, (IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.allOutlets.clear();
        this.unappliedOutlets.clear();
    }
}

