/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.JavaElementLine;
import org.eclipse.jdt.internal.ui.search.OccurrenceMatch;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchResult;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OccurrencesSearchQuery
implements ISearchQuery {
    private final OccurrencesSearchResult fResult;
    private IOccurrencesFinder fFinder;
    private final ITypeRoot fElement;
    private final String fJobLabel;
    private final String fSingularLabel;
    private final String fPluralLabel;
    private final String fName;
    private final String fFinderId;

    public OccurrencesSearchQuery(IOccurrencesFinder finder, ITypeRoot element) {
        this.fFinder = finder;
        this.fElement = element;
        this.fJobLabel = this.fFinder.getJobLabel();
        this.fResult = new OccurrencesSearchResult(this);
        this.fSingularLabel = this.fFinder.getUnformattedSingularLabel();
        this.fPluralLabel = this.fFinder.getUnformattedPluralLabel();
        this.fName = this.fFinder.getElementName();
        this.fFinderId = this.fFinder.getID();
    }

    public IStatus run(IProgressMonitor monitor) {
        if (this.fFinder == null) {
            return new StatusInfo(4, "Query has already been running");
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IOccurrencesFinder.OccurrenceLocation[] occurrences = this.fFinder.getOccurrences();
            if (occurrences != null) {
                HashMap<Integer, JavaElementLine> lineMap = new HashMap<Integer, JavaElementLine>();
                CompilationUnit astRoot = this.fFinder.getASTRoot();
                ArrayList<OccurrenceMatch> resultingMatches = new ArrayList<OccurrenceMatch>();
                int i = 0;
                while (i < occurrences.length) {
                    IOccurrencesFinder.OccurrenceLocation loc = occurrences[i];
                    JavaElementLine lineKey = this.getLineElement(astRoot, loc, lineMap);
                    if (lineKey != null) {
                        OccurrenceMatch match = new OccurrenceMatch(lineKey, loc.getOffset(), loc.getLength(), loc.getFlags());
                        resultingMatches.add(match);
                        lineKey.setFlags(lineKey.getFlags() | loc.getFlags());
                    }
                    ++i;
                }
                if (!resultingMatches.isEmpty()) {
                    this.fResult.addMatches(resultingMatches.toArray(new Match[resultingMatches.size()]));
                }
            }
        }
        finally {
            this.fFinder = null;
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private JavaElementLine getLineElement(CompilationUnit astRoot, IOccurrencesFinder.OccurrenceLocation location, HashMap<Integer, JavaElementLine> lineToGroup) {
        int lineNumber = astRoot.getLineNumber(location.getOffset());
        if (lineNumber <= 0) {
            return null;
        }
        JavaElementLine lineElement = null;
        try {
            int lineStartOffset;
            Integer key = new Integer(lineNumber);
            lineElement = lineToGroup.get(key);
            if (lineElement == null && (lineStartOffset = astRoot.getPosition(lineNumber, 0)) >= 0) {
                lineElement = new JavaElementLine(astRoot.getTypeRoot(), lineNumber - 1, lineStartOffset);
                lineToGroup.put(key, lineElement);
            }
        }
        catch (CoreException coreException) {}
        return lineElement;
    }

    public String getLabel() {
        return this.fJobLabel;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 1) {
            return Messages.format(this.fSingularLabel, new Object[]{this.fName, BasicElementLabels.getFileName(this.fElement)});
        }
        return Messages.format(this.fPluralLabel, new Object[]{this.fName, new Integer(nMatches), BasicElementLabels.getFileName(this.fElement)});
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }

    public String getFinderId() {
        return this.fFinderId;
    }
}

