/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.target.ITargetLocationFactory;

public class TargetLocationTypeManager {
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_LOCFACTORY = "locationFactory";
    private static final String TARGET_LOC_EXTPT = "targetLocations";
    private Map fExtentionMap = new HashMap(4);
    private Map fFactoryMap = new HashMap(4);
    static TargetLocationTypeManager INSTANCE;

    private TargetLocationTypeManager() {
        this.readExtentions();
    }

    public static TargetLocationTypeManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TargetLocationTypeManager();
        }
        return INSTANCE;
    }

    public ITargetLocationFactory getTargetLocationFactory(String type) {
        IConfigurationElement extension;
        ITargetLocationFactory factory = (ITargetLocationFactory)this.fFactoryMap.get(type);
        if (factory == null && (extension = (IConfigurationElement)this.fExtentionMap.get(type)) != null && (factory = (ITargetLocationFactory)this.createExecutableExtension(extension)) != null) {
            this.fFactoryMap.put(type, factory);
            return factory;
        }
        return factory;
    }

    private Object createExecutableExtension(IConfigurationElement element) {
        try {
            return element.createExecutableExtension(ATTR_LOCFACTORY);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void readExtentions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.pde.core", TARGET_LOC_EXTPT);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String type = elements[j].getAttribute(ATTR_TYPE);
                if (type != null) {
                    this.fExtentionMap.put(type, elements[j]);
                }
                ++j;
            }
            ++i;
        }
    }
}

