/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.PluginExportOperation;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.build.RuntimeInstallJob;
import org.eclipse.pde.internal.ui.wizards.exports.AntGeneratingExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.PluginExportWizardPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PluginExportWizard
extends AntGeneratingExportWizard {
    private static final String STORE_SECTION = "PluginExportWizard";

    public PluginExportWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_EXPORT_WIZ);
    }

    protected BaseExportWizardPage createPage1() {
        return new PluginExportWizardPage(this.getSelection());
    }

    protected String getSettingsSectionName() {
        return STORE_SECTION;
    }

    protected void scheduleExportJob() {
        final FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = this.fPage.doExportToDirectory();
        info.useJarFormat = this.fPage.useJARFormat();
        info.exportSource = this.fPage.doExportSource();
        info.exportSourceBundle = this.fPage.doExportSourceBundles();
        info.allowBinaryCycles = this.fPage.allowBinaryCycles();
        info.useWorkspaceCompiledClasses = this.fPage.useWorkspaceCompiledClasses();
        info.destinationDirectory = this.fPage.getDestination();
        info.zipFileName = this.fPage.getFileName();
        info.items = this.fPage.getSelectedItems();
        info.signingInfo = this.fPage.useJARFormat() ? this.fPage.getSigningInfo() : null;
        info.qualifier = this.fPage.getQualifier();
        final boolean installAfterExport = this.fPage.doInstall();
        if (installAfterExport) {
            RuntimeInstallJob.modifyInfoForInstall(info);
        }
        final PluginExportOperation job = new PluginExportOperation(info, PDEUIMessages.PluginExportJob_name);
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_PLUGIN_OBJ);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (job.hasAntErrors()) {
                    File logLocation = new File(info.destinationDirectory, "logs.zip");
                    if (logLocation.exists()) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(this, logLocation){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ File val$logLocation;
                            {
                                this.this$1 = var1_1;
                                this.val$logLocation = file;
                            }

                            public void run() {
                                AntGeneratingExportWizard.AntErrorDialog dialog = 1.access$0(this.this$1).new AntGeneratingExportWizard.AntErrorDialog(this.val$logLocation);
                                dialog.open();
                            }
                        });
                    }
                } else if (event.getResult().isOK() && installAfterExport) {
                    RuntimeInstallJob installJob = new RuntimeInstallJob(PDEUIMessages.PluginExportWizard_InstallJobName, info);
                    installJob.setUser(true);
                    installJob.setProperty(IProgressConstants.ICON_PROPERTY, PDEPluginImages.DESC_FEATURE_OBJ);
                    installJob.schedule();
                }
            }

            static /* synthetic */ PluginExportWizard access$0(1 var0) {
                return var0.PluginExportWizard.this;
            }
        });
        job.schedule();
    }

    protected Document generateAntTask() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            Element root = doc.createElement("project");
            root.setAttribute("name", "build");
            root.setAttribute("default", "plugin_export");
            doc.appendChild(root);
            Element target = doc.createElement("target");
            target.setAttribute("name", "plugin_export");
            root.appendChild(target);
            Element export = doc.createElement("pde.exportPlugins");
            export.setAttribute("plugins", this.getPluginIDs());
            export.setAttribute("destination", this.fPage.getDestination());
            String filename = this.fPage.getFileName();
            if (filename != null) {
                export.setAttribute("filename", filename);
            }
            export.setAttribute("exportType", this.getExportOperation());
            export.setAttribute("useJARFormat", Boolean.toString(this.fPage.useJARFormat()));
            export.setAttribute("exportSource", Boolean.toString(this.fPage.doExportSource()));
            String qualifier = this.fPage.getQualifier();
            if (qualifier != null) {
                export.setAttribute("qualifier", qualifier);
            }
            target.appendChild(export);
            return doc;
        }
        catch (DOMException dOMException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return null;
    }

    private String getPluginIDs() {
        StringBuffer buffer = new StringBuffer();
        Object[] objects = this.fPage.getSelectedItems();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IPluginModelBase) {
                buffer.append(((IPluginModelBase)object).getPluginBase().getId());
                if (i < objects.length - 1) {
                    buffer.append(",");
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

