/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.ErrorFunction;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperiment;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithmEvent;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithmListener;
import org.eclipse.stem.analysis.automaticexperiment.ModifiableParameter;
import org.eclipse.stem.analysis.automaticexperiment.NelderMeadAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.SimplexAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.SimplexFunction;
import org.eclipse.stem.core.scenario.Scenario;

public abstract class AbstractErrorAnalysisAlgorithm
implements ErrorAnalysisAlgorithm {
    protected Scenario baseScenario = null;
    protected SimplexAlgorithm simplexAlgorithm = new NelderMeadAlgorithm();
    protected SimplexFunction simplexFnToMinimize = null;
    protected ErrorFunction errorFunction = null;
    protected double[] initialParamsValues = null;
    protected double[] paramsInitialSteps = null;
    protected double tolerance = -1.0;
    protected String referenceDataDirectory = null;
    protected long maxNumOfIterations = -1L;
    protected List<ModifiableParameter> parameters = null;
    boolean repeat = false;
    private ArrayList<ErrorAnalysisAlgorithmListener> listeners = new ArrayList();

    @Override
    public abstract void execute();

    @Override
    public void setBaseScenario(Scenario baseScenario) {
        this.baseScenario = baseScenario;
    }

    @Override
    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public void setErrorFunction(ErrorFunction errorFunction) {
        this.errorFunction = errorFunction;
    }

    @Override
    public void setReferenceDataDirectory(String referenceDataDir) {
        this.referenceDataDirectory = referenceDataDir;
    }

    public void init(AutomaticExperiment automaticExperiment) {
        this.setBaseScenario(automaticExperiment.getBaseScenario());
        this.setParameters((List<ModifiableParameter>)automaticExperiment.getParameters());
        double tolerance = automaticExperiment.getTolerance();
        this.setTolerance(tolerance);
        long maxIterations = automaticExperiment.getMaximumNumberOfIterations();
        this.setMaximumNumberOfIterations(maxIterations);
        boolean repeatUntilNoImprovement = automaticExperiment.isReInit();
        this.setReInit(repeatUntilNoImprovement);
        ErrorFunction errorFunction = null;
        errorFunction = automaticExperiment.getErrorFunc();
        this.setErrorFunction(errorFunction);
        String refDir = automaticExperiment.getReferanceDataDir();
        this.setReferenceDataDirectory(refDir);
    }

    @Override
    public void reinitStartParams(AutomaticExperiment experiment, double[] vals) {
        int i = 0;
        for (ModifiableParameter p : experiment.getParameters()) {
            p.setInitialValue(vals[i++]);
        }
        this.init(experiment);
    }

    @Override
    public double[] getResultParameters() {
        return this.simplexAlgorithm.getMinimumParametersValues();
    }

    @Override
    public double getResultValue() {
        return this.simplexAlgorithm.getMinimumFunctionValue();
    }

    @Override
    public void setMaximumNumberOfIterations(long maxNumOfIterations) {
        this.maxNumOfIterations = maxNumOfIterations;
    }

    public void setReInit(boolean repeat) {
        this.repeat = repeat;
    }

    @Override
    public void setParameters(List<ModifiableParameter> parameters) {
        this.parameters = parameters;
        this.paramsInitialSteps = new double[parameters.size()];
        this.initialParamsValues = new double[parameters.size()];
        int i = 0;
        for (ModifiableParameter param : parameters) {
            this.paramsInitialSteps[i] = param.getStep();
            this.initialParamsValues[i] = param.getInitialValue();
            ++i;
        }
    }

    @Override
    public void addListener(ErrorAnalysisAlgorithmListener l) {
        this.listeners.add(l);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    protected void fireEvent(ErrorAnalysisAlgorithmEvent evt) {
        for (ErrorAnalysisAlgorithmListener l : this.listeners) {
            l.eventReceived(evt);
        }
    }
}

