/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.analysis.ErrorFunction;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.analysis.ReferenceScenarioDataMap;
import org.eclipse.stem.analysis.automaticexperiment.ALGORITHM_STATUS;
import org.eclipse.stem.analysis.automaticexperiment.AbstractErrorAnalysisAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperiment;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperimentManager;
import org.eclipse.stem.analysis.automaticexperiment.CustomSimulationManager;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithmEvent;
import org.eclipse.stem.analysis.automaticexperiment.ModifiableParameter;
import org.eclipse.stem.analysis.automaticexperiment.SimplexFunction;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.Simulation;
import org.eclipse.stem.util.loggers.views.CustomCSVLogger;

public class SimplexAlgorithmExecuter
extends AbstractErrorAnalysisAlgorithm {
    private ISimulation simulation = null;
    private CustomCSVLogger csvLogger = null;
    private static final String SIMULATION_OUTPUT_DIR = Platform.getLocation() + File.separator + "AutoExpTempDir";
    private static final String LOG_FILE_NAME = String.valueOf(SIMULATION_OUTPUT_DIR) + File.separator + "resultLog.csv";
    static String LS = System.getProperty("line.separator");
    private final CustomSimulationManager simMgr = CustomSimulationManager.getManager();
    private ReferenceScenarioDataMapImpl ref;

    @Override
    public void execute() {
        double[] minvals;
        int i;
        double prevmin = Double.MAX_VALUE;
        double[] prevvals = new double[this.initialParamsValues.length];
        String[] parameterNames = null;
        if (this.parameters != null) {
            parameterNames = new String[this.parameters.size()];
            i = 0;
            for (ModifiableParameter param : this.parameters) {
                parameterNames[i++] = param.getFeatureName();
            }
        }
        while (true) {
            i = 0;
            while (i < this.initialParamsValues.length) {
                prevvals[i] = this.initialParamsValues[i];
                ++i;
            }
            this.simplexAlgorithm.execute(this.simplexFnToMinimize, this.initialParamsValues, this.paramsInitialSteps, this.tolerance, this.maxNumOfIterations);
            if (!this.repeat || AutomaticExperimentManager.QUIT_NOW) {
                minvals = this.simplexAlgorithm.getMinimumParametersValues();
                break;
            }
            double newmin = this.simplexAlgorithm.getMinimumFunctionValue();
            if (newmin >= prevmin) {
                minvals = prevvals;
                break;
            }
            prevmin = this.simplexAlgorithm.getMinimumFunctionValue();
            int i2 = 0;
            while (i2 < this.initialParamsValues.length) {
                this.initialParamsValues[i2] = this.simplexAlgorithm.getMinimumParametersValues()[i2];
                prevvals[i2] = this.simplexAlgorithm.getMinimumParametersValues()[i2];
                ++i2;
            }
            ErrorAnalysisAlgorithmEvent newEvent = new ErrorAnalysisAlgorithmEvent(this.simplexAlgorithm.getMinimumErrorResult(), ALGORITHM_STATUS.RESTARTED_ALGORITHM);
            newEvent.parameterNames = parameterNames;
            newEvent.parameterValues = this.simplexAlgorithm.getMinimumParametersValues();
            this.fireEvent(newEvent);
        }
        ErrorAnalysisAlgorithmEvent newEvent = new ErrorAnalysisAlgorithmEvent(this.simplexAlgorithm.getMinimumErrorResult(), ALGORITHM_STATUS.FINISHED_ALGORITHM);
        newEvent.parameterNames = parameterNames;
        newEvent.parameterValues = minvals;
        this.fireEvent(newEvent);
    }

    @Override
    public void init(AutomaticExperiment automaticExperiment, ErrorAnalysisAlgorithm alg) throws LogInitializationException {
        super.init(automaticExperiment);
        this.simplexFnToMinimize = new NedlearMeadSimplexFunction(this.parameters, this.baseScenario, this.errorFunction, alg);
        CSVscenarioLoader loader1 = new CSVscenarioLoader(this.referenceDataDirectory);
        int res = loader1.getMaxResolution("");
        this.ref = loader1.parseAllFiles("", res);
    }

    @Override
    public void setParameters(List<ModifiableParameter> parameters) {
        super.setParameters(parameters);
        int paramIndex = 0;
        for (ModifiableParameter param : parameters) {
            this.simplexAlgorithm.setParameterLimits(paramIndex, param.getLowerBound(), param.getUpperBound());
            ++paramIndex;
        }
    }

    public class NedlearMeadSimplexFunction
    implements SimplexFunction {
        private ErrorFunction errorFunction = null;
        private String[] parameterNames = null;
        private FileWriter resultWriter;
        private URI[] decoratorURIs = null;
        private ErrorAnalysisAlgorithm algorithm = null;

        public NedlearMeadSimplexFunction(List<ModifiableParameter> parameters, Scenario pBaseScenario, ErrorFunction errorFunction, ErrorAnalysisAlgorithm algorithm) {
            try {
                File d = new File(SIMULATION_OUTPUT_DIR);
                if (!d.exists()) {
                    d.mkdirs();
                }
                this.resultWriter = new FileWriter(LOG_FILE_NAME);
                SimplexAlgorithmExecuter.this.baseScenario = pBaseScenario;
                this.errorFunction = errorFunction;
                this.algorithm = algorithm;
                if (parameters != null) {
                    this.parameterNames = new String[parameters.size()];
                    this.decoratorURIs = new URI[parameters.size()];
                    int i = 0;
                    for (ModifiableParameter param : parameters) {
                        this.decoratorURIs[i] = param.getTargetURI();
                        this.parameterNames[i++] = param.getFeatureName();
                        this.resultWriter.write(this.parameterNames[i - 1]);
                        this.resultWriter.write(",");
                    }
                    this.resultWriter.write("error");
                    this.resultWriter.write(LS);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        @Override
        public ErrorResult getValue(double[] parameters) {
            String directoryName;
            File dir;
            SimplexAlgorithmExecuter.this.simulation = this.createSimulation(SimplexAlgorithmExecuter.this.baseScenario);
            SimplexAlgorithmExecuter.this.simulation.setSequenceNumber(SimplexAlgorithmExecuter.this.simulation.getSequenceNumber() + 1);
            EList decs = SimplexAlgorithmExecuter.this.baseScenario.getCanonicalGraph().getDecorators();
            Decorator defaultDecorator = null;
            for (Decorator decorator : decs) {
                if (!(decorator instanceof DiseaseModel)) continue;
                defaultDecorator = decorator;
                break;
            }
            int i = 0;
            while (i < this.parameterNames.length) {
                Decorator decorator = defaultDecorator;
                if (this.decoratorURIs[i] != null) {
                    for (Decorator scenarioDec : decs) {
                        if (!this.decoratorURIs[i].toString().equals(scenarioDec.getURI().toString())) continue;
                        decorator = scenarioDec;
                        break;
                    }
                }
                for (EAttribute attribute : decorator.eClass().getEAllAttributes()) {
                    if (!attribute.getName().equals(this.parameterNames[i])) continue;
                    decorator.eSet((EStructuralFeature)attribute, (Object)new Double(parameters[i]));
                }
                ++i;
            }
            String uniqueID = null;
            if (SimplexAlgorithmExecuter.this.simulation != null) {
                uniqueID = SimplexAlgorithmExecuter.this.simulation.getUniqueIDString();
            }
            if (!(dir = new File(directoryName = String.valueOf(SIMULATION_OUTPUT_DIR) + File.separator + uniqueID + File.separator)).exists()) {
                dir.mkdirs();
            }
            SimplexAlgorithmExecuter.this.csvLogger = new CustomCSVLogger(directoryName, SimplexAlgorithmExecuter.this.simulation, (IntegrationDecorator)defaultDecorator);
            try {
                SimplexAlgorithmExecuter.this.baseScenario.reset();
            }
            catch (ScenarioInitializationException sie) {
                Utility.handleException((String)sie.getErrorMessage(), (boolean)true, (ScenarioInitializationException)sie);
            }
            double error = 0.0;
            ErrorResult result = null;
            try {
                double[] dArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    double val = dArray[n2];
                    this.resultWriter.write(String.valueOf(val) + ",");
                    ++n2;
                }
                ErrorAnalysisAlgorithmEvent newEvent = new ErrorAnalysisAlgorithmEvent(null, ALGORITHM_STATUS.STARTING_SIMULATION);
                newEvent.parameterNames = this.parameterNames;
                newEvent.parameterValues = parameters;
                ((AbstractErrorAnalysisAlgorithm)this.algorithm).fireEvent(newEvent);
                this.runSimulation(SimplexAlgorithmExecuter.this.simulation);
                result = this.getErrorValue(SimplexAlgorithmExecuter.this.simulation.getUniqueIDString());
                newEvent = new ErrorAnalysisAlgorithmEvent(result, ALGORITHM_STATUS.FINISHED_SIMULATION);
                newEvent.parameterNames = this.parameterNames;
                newEvent.parameterValues = parameters;
                ((AbstractErrorAnalysisAlgorithm)this.algorithm).fireEvent(newEvent);
                error = result.getError();
                this.resultWriter.write(String.valueOf(error));
                this.resultWriter.write(LS);
                this.resultWriter.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.cleanup();
            return result;
        }

        private ErrorResult getErrorValue(String simulationUniqueId) {
            ErrorResult result = null;
            try {
                EList decs = SimplexAlgorithmExecuter.this.baseScenario.getCanonicalGraph().getDecorators();
                DiseaseModel defaultDecorator = null;
                for (Decorator decorator : decs) {
                    if (!(decorator instanceof DiseaseModel)) continue;
                    defaultDecorator = (DiseaseModel)decorator;
                    break;
                }
                if (defaultDecorator != null) {
                    CSVscenarioLoader loader2 = new CSVscenarioLoader(String.valueOf(SIMULATION_OUTPUT_DIR) + File.separator + simulationUniqueId + "/" + defaultDecorator.getDiseaseName() + "/" + defaultDecorator.getPopulationIdentifier());
                    int maxres = loader2.getMaxResolution("");
                    ReferenceScenarioDataMapImpl data = loader2.parseAllFiles("", maxres);
                    result = this.errorFunction.calculateError((ReferenceScenarioDataMap)SimplexAlgorithmExecuter.this.ref, (ReferenceScenarioDataMap)data);
                }
            }
            catch (LogInitializationException e) {
                e.printStackTrace();
            }
            return result;
        }

        private void runSimulation(ISimulation simulationToRun) {
            simulationToRun.run();
            try {
                simulationToRun.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            simulationToRun.stop();
        }

        private void cleanup() {
            if (SimplexAlgorithmExecuter.this.csvLogger != null) {
                SimplexAlgorithmExecuter.this.csvLogger.close();
                SimplexAlgorithmExecuter.this.csvLogger = null;
            }
            SimplexAlgorithmExecuter.this.simMgr.removeActiveSimulation(SimplexAlgorithmExecuter.this.simulation);
            ((Simulation)SimplexAlgorithmExecuter.this.simulation).destroy();
            SimplexAlgorithmExecuter.this.simulation = null;
            CustomSimulationManager.resetSimulationManager();
        }

        private ISimulation createSimulation(Scenario scenario) {
            Simulation simulation = (Simulation)SimplexAlgorithmExecuter.this.simMgr.createSimulation(scenario, null);
            simulation.simulationSleep = false;
            return simulation;
        }
    }
}

