/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.analysis.automaticexperiment.views.AnalysisControl;
import org.eclipse.stem.analysis.automaticexperiment.views.AnalysisControlFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AnalysisViewer
extends Viewer {
    private static final String URI_PREFIX = "/resources/data/scenario/disease/";
    final Composite composite;
    private final AnalysisControlFactory acf;

    public AnalysisViewer(Composite parent, AnalysisControlFactory acf) {
        this.composite = new Composite(parent, 0);
        FillLayout compositeLayout = new FillLayout(256);
        this.composite.setLayout((Layout)compositeLayout);
        this.acf = acf;
        this.refresh();
        this.composite.pack();
    }

    public Control getControl() {
        return this.composite;
    }

    public void refresh() {
        this.populateView();
    }

    private void populateView() {
        if (this.composite.isDisposed()) {
            return;
        }
        AnalysisControl analysisControl = this.acf.create(this.composite);
        analysisControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AnalysisViewer.this.composite.layout(true, true);
                AnalysisViewer.this.composite.redraw();
            }
        });
        this.composite.layout(true, true);
        this.composite.redraw();
    }

    public static String nameFilter(String s) {
        String s1 = s.trim();
        s1 = s1.replace('\"', ' ');
        s1 = s1.replaceAll(" ", "");
        s1 = s1.replace(',', '_');
        s1 = s1.replace('.', '_');
        s = s1 = s1.replaceAll("_", "");
        return s;
    }

    public static String filterFilename(String unfiltered) {
        int last = unfiltered.indexOf(URI_PREFIX);
        if (last >= 0) {
            return unfiltered.substring(last += URI_PREFIX.length(), unfiltered.length());
        }
        return unfiltered;
    }

    public Object getInput() {
        return null;
    }

    public void setInput(Object input) {
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public ISelection getSelection() {
        return null;
    }
}

