/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.common.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stem.core.common.CommonFactory;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.DoubleValueMatrix;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.IdentifiableFilter;
import org.eclipse.stem.core.common.StringValue;
import org.eclipse.stem.core.common.StringValueList;
import org.eclipse.stem.core.common.impl.DoubleValueImpl;
import org.eclipse.stem.core.common.impl.DoubleValueListImpl;
import org.eclipse.stem.core.common.impl.DoubleValueMatrixImpl;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.core.common.impl.IdentifiableFilterImpl;
import org.eclipse.stem.core.common.impl.StringValueImpl;
import org.eclipse.stem.core.common.impl.StringValueListImpl;

public class CommonFactoryImpl
extends EFactoryImpl
implements CommonFactory {
    public static CommonFactory init() {
        try {
            CommonFactory theCommonFactory = (CommonFactory)EPackage.Registry.INSTANCE.getEFactory("http:///org/eclipse/stem/core/common.ecore");
            if (theCommonFactory != null) {
                return theCommonFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CommonFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDublinCore();
            }
            case 3: {
                return this.createIdentifiableFilter();
            }
            case 4: {
                return this.createDoubleValueList();
            }
            case 5: {
                return this.createDoubleValueMatrix();
            }
            case 6: {
                return this.createDoubleValue();
            }
            case 7: {
                return this.createStringValueList();
            }
            case 8: {
                return this.createStringValue();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.createURIFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.convertURIToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public DublinCore createDublinCore() {
        DublinCoreImpl dublinCore = new DublinCoreImpl();
        return dublinCore;
    }

    @Override
    public IdentifiableFilter createIdentifiableFilter() {
        IdentifiableFilterImpl identifiableFilter = new IdentifiableFilterImpl();
        return identifiableFilter;
    }

    @Override
    public DoubleValueList createDoubleValueList() {
        DoubleValueListImpl doubleValueList = new DoubleValueListImpl();
        return doubleValueList;
    }

    @Override
    public DoubleValueMatrix createDoubleValueMatrix() {
        DoubleValueMatrixImpl doubleValueMatrix = new DoubleValueMatrixImpl();
        return doubleValueMatrix;
    }

    @Override
    public DoubleValue createDoubleValue() {
        DoubleValueImpl doubleValue = new DoubleValueImpl();
        return doubleValue;
    }

    @Override
    public StringValueList createStringValueList() {
        StringValueListImpl stringValueList = new StringValueListImpl();
        return stringValueList;
    }

    @Override
    public StringValue createStringValue() {
        StringValueImpl stringValue = new StringValueImpl();
        return stringValue;
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return URI.createURI((String)initialValue);
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return "";
        }
        return instanceValue.toString();
    }

    @Override
    public CommonPackage getCommonPackage() {
        return (CommonPackage)this.getEPackage();
    }

    @Deprecated
    public static CommonPackage getPackage() {
        return CommonPackage.eINSTANCE;
    }
}

