/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.sequencer.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.RealTimeSequencer;
import org.eclipse.stem.core.sequencer.SequencerPackage;
import org.eclipse.stem.core.sequencer.impl.SequentialSequencerImpl;

public class RealTimeSequencerImpl
extends SequentialSequencerImpl
implements RealTimeSequencer {
    private boolean getNextCalled = false;

    protected RealTimeSequencerImpl() {
    }

    @Override
    public STEMTime getStartTime() {
        if (!this.getNextCalled) {
            return RealTimeSequencerImpl.getCurrentSystemTime();
        }
        return super.getStartTime();
    }

    @Override
    public STEMTime getNextTime() {
        super.getNextTime();
        if (!this.getNextCalled) {
            this.getNextCalled = true;
            this.setStartTime(RealTimeSequencerImpl.getCurrentSystemTime());
        }
        STEMTime currentTime = this.getCurrentTime();
        STEMTime timeToWakeUp = super.getNextTime();
        this.sleepUntil(timeToWakeUp, currentTime);
        this.setCurrentTime(RealTimeSequencerImpl.getCurrentSystemTime());
        return this.getCurrentTime();
    }

    private void sleepUntil(STEMTime futureTime, STEMTime currentTime) {
        long millisecondsToSleep = futureTime.getTime().getTime() - currentTime.getTime().getTime();
        try {
            Thread.sleep(millisecondsToSleep);
        }
        catch (InterruptedException e) {
            CorePlugin.logInformation("RealTimeSequencer's sleep was interrupted", e);
        }
    }

    @Override
    public void setEndTime(STEMTime newEndTime) {
        STEMTime currentTime = RealTimeSequencerImpl.getCurrentSystemTime();
        if (!this.isEndTimeBefore(currentTime)) {
            throw new IllegalArgumentException("The new end time \"" + newEndTime.toString() + "\" is not after the current time of \"" + currentTime.toString() + "\"");
        }
        super.setEndTime(newEndTime);
    }

    @Override
    public void reset() {
        super.reset();
        this.getNextCalled = false;
    }

    @Override
    protected EClass eStaticClass() {
        return SequencerPackage.Literals.REAL_TIME_SEQUENCER;
    }

    protected static STEMTime getCurrentSystemTime() {
        return ModelFactory.eINSTANCE.createSTEMTime();
    }
}

