/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.adapters.spatial.geo;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.SpatialProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.InlineLatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.PlatformLatLongDataProvider;

public class LatLongProviderAdapter
extends SpatialProviderAdapter
implements LatLongProvider {
    private static Map<Identifiable, LatLong> identifiableLatLongCache = new ConcurrentHashMap<Identifiable, LatLong>();
    private static Map<Identifiable, double[]> identifiableCenterCache = new ConcurrentHashMap<Identifiable, double[]>();
    private static Map<String, LatLongDataProvider> latLongDataProviders = null;

    public static void registerLatLongDataProvider(String scheme, LatLongDataProvider latLongDataProvider) {
        LatLongProviderAdapter.getLatLongDataProviders().put(scheme, latLongDataProvider);
    }

    public static synchronized Map<String, LatLongDataProvider> getLatLongDataProviders() {
        if (latLongDataProviders == null) {
            latLongDataProviders = new HashMap<String, LatLongDataProvider>();
            latLongDataProviders.put("inline", new InlineLatLongDataProvider());
            latLongDataProviders.put("platform", new PlatformLatLongDataProvider());
        }
        return latLongDataProviders;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        boolean retValue;
        boolean bl = retValue = type == LatLongProvider.class;
        if (!retValue) {
            retValue = super.isAdapterForType(type);
        }
        return retValue;
    }

    @Override
    public LatLong getLatLong() {
        Identifiable identifiable = (Identifiable)this.getTarget();
        LatLong retValue = identifiableLatLongCache.get(identifiable);
        if (retValue == null) {
            retValue = new LatLong();
            String spatialValue = identifiable.getDublinCore().getSpatial();
            if (spatialValue != null && spatialValue.startsWith("stemspatial:")) {
                try {
                    URI dataURI = this.extractDataURI(spatialValue);
                    if (dataURI != null) {
                        retValue = this.getLatLong(dataURI);
                        if (retValue != null) {
                            identifiableLatLongCache.put(identifiable, retValue);
                        } else {
                            retValue = new LatLong();
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return retValue;
    }

    @Override
    public LatLong getLatLongNoWait() {
        Identifiable identifiable = (Identifiable)this.getTarget();
        LatLong retValue = identifiableLatLongCache.get(identifiable);
        if (retValue == null) {
            retValue = new LatLong();
            String spatialValue = identifiable.getDublinCore().getSpatial();
            if (spatialValue != null && spatialValue.startsWith("stemspatial:")) {
                try {
                    URI dataURI = this.extractDataURI(spatialValue);
                    if (dataURI != null && (retValue = this.getLatLongNoWait(dataURI)) != null && retValue.size() > 0) {
                        identifiableLatLongCache.put(identifiable, retValue);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return retValue;
    }

    private URI extractDataURI(String stemSpatialURIString) {
        URI retValue = null;
        try {
            String dataURIString = stemSpatialURIString.substring("stemspatial:".length());
            retValue = URI.createURI((String)dataURIString);
        }
        catch (Exception exception) {
            Activator.logError("Badly formated spatial URI \"" + stemSpatialURIString + "\"", null);
        }
        return retValue;
    }

    private LatLong getLatLong(URI dataURI) {
        LatLong retValue = new LatLong();
        LatLongDataProvider latLongDataProvider = this.getLatLongDataProvider(dataURI.scheme());
        if (latLongDataProvider != null) {
            retValue = latLongDataProvider.getLatLong(dataURI);
        } else {
            Activator.logError("Unable to find a lat/long data provider for scheme \"" + dataURI.scheme() + "\"", null);
        }
        return retValue;
    }

    private LatLong getLatLongNoWait(URI dataURI) {
        LatLong retValue = new LatLong();
        LatLongDataProvider latLongDataProvider = this.getLatLongDataProvider(dataURI.scheme());
        if (latLongDataProvider != null) {
            retValue = latLongDataProvider.getLatLongNoWait(dataURI);
        } else {
            Activator.logError("Unable to find a lat/long data provider for scheme \"" + dataURI.scheme() + "\"", null);
        }
        return retValue;
    }

    @Override
    public double[] getCenter() {
        Identifiable identifiable = (Identifiable)this.getTarget();
        double[] centerLatLong = identifiableCenterCache.get(identifiable);
        if (centerLatLong != null) {
            return centerLatLong;
        }
        centerLatLong = new double[2];
        double maxLat = Double.MAX_VALUE;
        double maxLong = Double.MAX_VALUE;
        double minLat = Double.MIN_VALUE;
        double minLong = Double.MIN_VALUE;
        LatLong latLong = this.getLatLong();
        if (latLong.getSegments().isEmpty()) {
            return null;
        }
        for (LatLong.Segment segment : latLong.getSegments()) {
            if (maxLat == Double.MAX_VALUE && minLat == Double.MIN_VALUE) {
                maxLat = minLat = segment.latitude(0);
                maxLong = minLong = segment.longitude(0);
            }
            int size = segment.size();
            int i = 0;
            while (i < size) {
                double lon = segment.longitude(i);
                double lat = segment.latitude(i);
                if (maxLong < lon) {
                    maxLong = lon;
                }
                if (maxLat < lat) {
                    maxLat = lat;
                }
                if (minLong > lon) {
                    minLong = lon;
                }
                if (minLat > lat) {
                    minLat = lat;
                }
                ++i;
            }
        }
        centerLatLong[0] = (maxLat + minLat) / 2.0;
        centerLatLong[1] = (maxLong + minLong) / 2.0;
        identifiableCenterCache.put(identifiable, centerLatLong);
        return centerLatLong;
    }

    protected LatLongDataProvider getLatLongDataProvider(String scheme) {
        return LatLongProviderAdapter.getLatLongDataProviders().get(scheme);
    }
}

