/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.avianinfluenza.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.functions.CTDLFunctions;
import org.eclipse.stem.diseasemodels.avianinfluenza.AvianinfluenzaFactory;
import org.eclipse.stem.diseasemodels.avianinfluenza.AvianinfluenzaPackage;
import org.eclipse.stem.diseasemodels.avianinfluenza.H7N9;
import org.eclipse.stem.diseasemodels.avianinfluenza.H7N9Label;
import org.eclipse.stem.diseasemodels.avianinfluenza.H7N9LabelValue;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.vector.impl.VectorDiseaseModelImpl;

public class H7N9Impl
extends VectorDiseaseModelImpl
implements H7N9 {
    protected static final double AVIAN_TO_AVIAN_TRANSMISSION_RATE_EDEFAULT = 0.1;
    protected double avianToAvianTransmissionRate = 0.1;
    protected static final double AVIAN_RECOVERY_RATE_EDEFAULT = 0.0;
    protected double avianRecoveryRate = 0.0;
    protected static final double AVIAN_TO_HUMAN_TRANSMISSION_RATE_EDEFAULT = 1.2;
    protected double avianToHumanTransmissionRate = 1.2;
    protected static final double HUMAN_TO_HUMAN_TRANSMISSION_RATE_EDEFAULT = 1.2;
    protected double humanToHumanTransmissionRate = 1.2;
    protected static final double AVIAN_CHARACTERISTIC_MIXING_DISTANCE_EDEFAULT = 0.5;
    protected double avianCharacteristicMixingDistance = 0.5;
    protected static final double HUMAN_RECOVERY_RATE_EDEFAULT = 0.5;
    protected double humanRecoveryRate = 0.5;
    protected static final double HUMAN_IMMUNITY_LOSS_RATE_EDEFAULT = 0.001;
    protected double humanImmunityLossRate = 0.001;
    protected static final double TEMPERATURE_FACTOR_EDEFAULT = 1.0;
    protected double temperatureFactor = 1.0;

    protected EClass eStaticClass() {
        return AvianinfluenzaPackage.Literals.H7N9;
    }

    @Override
    public double getAvianToAvianTransmissionRate() {
        return this.avianToAvianTransmissionRate;
    }

    @Override
    public void setAvianToAvianTransmissionRate(double newAvianToAvianTransmissionRate) {
        this.avianToAvianTransmissionRate = newAvianToAvianTransmissionRate;
    }

    @Override
    public double getAvianRecoveryRate() {
        return this.avianRecoveryRate;
    }

    @Override
    public void setAvianRecoveryRate(double newAvianRecoveryRate) {
        this.avianRecoveryRate = newAvianRecoveryRate;
    }

    @Override
    public double getAvianToHumanTransmissionRate() {
        return this.avianToHumanTransmissionRate;
    }

    @Override
    public void setAvianToHumanTransmissionRate(double newAvianToHumanTransmissionRate) {
        this.avianToHumanTransmissionRate = newAvianToHumanTransmissionRate;
    }

    @Override
    public double getHumanToHumanTransmissionRate() {
        return this.humanToHumanTransmissionRate;
    }

    @Override
    public void setHumanToHumanTransmissionRate(double newHumanToHumanTransmissionRate) {
        this.humanToHumanTransmissionRate = newHumanToHumanTransmissionRate;
    }

    @Override
    public double getAvianCharacteristicMixingDistance() {
        return this.avianCharacteristicMixingDistance;
    }

    @Override
    public void setAvianCharacteristicMixingDistance(double newAvianCharacteristicMixingDistance) {
        this.avianCharacteristicMixingDistance = newAvianCharacteristicMixingDistance;
    }

    @Override
    public double getHumanRecoveryRate() {
        return this.humanRecoveryRate;
    }

    @Override
    public void setHumanRecoveryRate(double newHumanRecoveryRate) {
        this.humanRecoveryRate = newHumanRecoveryRate;
    }

    @Override
    public double getHumanImmunityLossRate() {
        return this.humanImmunityLossRate;
    }

    @Override
    public void setHumanImmunityLossRate(double newHumanImmunityLossRate) {
        this.humanImmunityLossRate = newHumanImmunityLossRate;
    }

    @Override
    public double getTemperatureFactor() {
        return this.temperatureFactor;
    }

    @Override
    public void setTemperatureFactor(double newTemperatureFactor) {
        this.temperatureFactor = newTemperatureFactor;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 20: {
                return this.getAvianToAvianTransmissionRate();
            }
            case 21: {
                return this.getAvianRecoveryRate();
            }
            case 22: {
                return this.getAvianToHumanTransmissionRate();
            }
            case 23: {
                return this.getHumanToHumanTransmissionRate();
            }
            case 24: {
                return this.getAvianCharacteristicMixingDistance();
            }
            case 25: {
                return this.getHumanRecoveryRate();
            }
            case 26: {
                return this.getHumanImmunityLossRate();
            }
            case 27: {
                return this.getTemperatureFactor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 20: {
                this.setAvianToAvianTransmissionRate((Double)newValue);
                return;
            }
            case 21: {
                this.setAvianRecoveryRate((Double)newValue);
                return;
            }
            case 22: {
                this.setAvianToHumanTransmissionRate((Double)newValue);
                return;
            }
            case 23: {
                this.setHumanToHumanTransmissionRate((Double)newValue);
                return;
            }
            case 24: {
                this.setAvianCharacteristicMixingDistance((Double)newValue);
                return;
            }
            case 25: {
                this.setHumanRecoveryRate((Double)newValue);
                return;
            }
            case 26: {
                this.setHumanImmunityLossRate((Double)newValue);
                return;
            }
            case 27: {
                this.setTemperatureFactor((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 20: {
                this.setAvianToAvianTransmissionRate(0.1);
                return;
            }
            case 21: {
                this.setAvianRecoveryRate(0.0);
                return;
            }
            case 22: {
                this.setAvianToHumanTransmissionRate(1.2);
                return;
            }
            case 23: {
                this.setHumanToHumanTransmissionRate(1.2);
                return;
            }
            case 24: {
                this.setAvianCharacteristicMixingDistance(0.5);
                return;
            }
            case 25: {
                this.setHumanRecoveryRate(0.5);
                return;
            }
            case 26: {
                this.setHumanImmunityLossRate(0.001);
                return;
            }
            case 27: {
                this.setTemperatureFactor(1.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 20: {
                return this.avianToAvianTransmissionRate != 0.1;
            }
            case 21: {
                return this.avianRecoveryRate != 0.0;
            }
            case 22: {
                return this.avianToHumanTransmissionRate != 1.2;
            }
            case 23: {
                return this.humanToHumanTransmissionRate != 1.2;
            }
            case 24: {
                return this.avianCharacteristicMixingDistance != 0.5;
            }
            case 25: {
                return this.humanRecoveryRate != 0.5;
            }
            case 26: {
                return this.humanImmunityLossRate != 0.001;
            }
            case 27: {
                return this.temperatureFactor != 1.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (avianToAvianTransmissionRate: ");
        result.append(this.avianToAvianTransmissionRate);
        result.append(", avianRecoveryRate: ");
        result.append(this.avianRecoveryRate);
        result.append(", avianToHumanTransmissionRate: ");
        result.append(this.avianToHumanTransmissionRate);
        result.append(", humanToHumanTransmissionRate: ");
        result.append(this.humanToHumanTransmissionRate);
        result.append(", avianCharacteristicMixingDistance: ");
        result.append(this.avianCharacteristicMixingDistance);
        result.append(", humanRecoveryRate: ");
        result.append(this.humanRecoveryRate);
        result.append(", humanImmunityLossRate: ");
        result.append(this.humanImmunityLossRate);
        result.append(", temperatureFactor: ");
        result.append(this.temperatureFactor);
        result.append(')');
        return result.toString();
    }

    public void applyExternalDeltas(STEMTime currentTime, double continuousTime, long timeDelta, EList<DynamicLabel> labels) {
        super.applyExternalDeltas(currentTime, continuousTime, timeDelta, labels);
    }

    public void doStochasticProcess(IntegrationLabel label, long timeDelta) {
        super.doStochasticProcess(label, timeDelta);
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int _i = 0;
        while (_i < labels.size()) {
            double deltaR;
            double deltaI;
            double deltaS;
            H7N9Label diseaseLabel = (H7N9Label)labels.get(_i);
            H7N9LabelValue currentDiseaseState = (H7N9LabelValue)diseaseLabel.getProbeValue();
            H7N9LabelValue deltaValue = (H7N9LabelValue)diseaseLabel.getDeltaValue();
            deltaValue.reset();
            H7N9LabelValue humanDiseaseState = currentDiseaseState;
            if (!diseaseLabel.getPopulationModelLabel().getPopulationIdentifier().equals(this.getPopulationIdentifier())) {
                humanDiseaseState = (H7N9LabelValue)this.findDiseaseLabel(diseaseLabel.getNode(), this.getPopulationIdentifier()).getCurrentValue();
            }
            double densityFactor = 1.0;
            if (!this.frequencyDependent) {
                double popDensity = humanDiseaseState.getPopulationCount() / CTDLFunctions.area((Node)diseaseLabel.getNode());
                densityFactor *= popDensity / this.referencePopulationDensity;
            }
            if (diseaseLabel.getPopulationModelLabel().getPopulationIdentifier().equals(this.getPopulationIdentifier())) {
                deltaS = 0.0;
                deltaI = 0.0;
                deltaR = 0.0;
                double effectiveIHumans = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentDiseaseState.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
                double effectiveIBirds = 0.0;
                H7N9Label birdsLabel = this.findDiseaseLabel(diseaseLabel.getNode(), this.getVectorPopulationIdentifier());
                if (birdsLabel != null) {
                    H7N9LabelValue birdsLabelValue = (H7N9LabelValue)birdsLabel.getTempValue();
                    effectiveIBirds = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), birdsLabel, birdsLabelValue.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, AvianinfluenzaPackage.Literals.H7N9__AVIAN_CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
                }
                double tFactor = 1.0;
                double dayTemperature = CTDLFunctions.temperature((Node)diseaseLabel.getNode(), (STEMTime)time, (long)timeDelta, (double)t);
                if (dayTemperature != 99999.0) {
                    tFactor = dayTemperature * this.getTemperatureFactor();
                    if (tFactor < 0.0) {
                        tFactor = 0.0;
                    }
                    if (tFactor > 1.0) {
                        tFactor = 1.0;
                    }
                }
                double StoI = densityFactor * this.getHumanToHumanTransmissionRate() * currentDiseaseState.getS() * effectiveIHumans + tFactor * densityFactor * this.getAvianToHumanTransmissionRate() * currentDiseaseState.getS() * effectiveIBirds;
                double ItoR = this.getHumanRecoveryRate() * currentDiseaseState.getI();
                double RtoS = this.getHumanImmunityLossRate() * currentDiseaseState.getR();
                Exchange siExchange = (Exchange)ExchangePool.POOL.get();
                siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
                siExchange.setCount(StoI);
                siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
                siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)siExchange);
                Exchange irExchange = (Exchange)ExchangePool.POOL.get();
                irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
                irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
                irExchange.setCount(ItoR);
                irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)irExchange);
                Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
                rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
                rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                rsExchange.setCount(RtoS);
                rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)rsExchange);
                deltaS = -StoI + RtoS;
                deltaI = StoI - ItoR;
                deltaR = ItoR - RtoS;
                deltaValue.setS(deltaS);
                deltaValue.setI(deltaI);
                deltaValue.setR(deltaR);
                deltaValue.setIncidence(StoI);
            } else {
                deltaS = 0.0;
                deltaI = 0.0;
                deltaR = 0.0;
                double tFactor = 1.0;
                double dayTemperature = CTDLFunctions.temperature((Node)diseaseLabel.getNode(), (STEMTime)time, (long)timeDelta, (double)t);
                if (dayTemperature != 99999.0) {
                    tFactor = dayTemperature * this.getTemperatureFactor();
                    if (tFactor < 0.0) {
                        tFactor = 0.0;
                    }
                    if (tFactor > 1.0) {
                        tFactor = 1.0;
                    }
                }
                double effectiveIBirds = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentDiseaseState.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, AvianinfluenzaPackage.Literals.H7N9__AVIAN_CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
                double StoI = tFactor * densityFactor * this.getAvianToAvianTransmissionRate() * currentDiseaseState.getS() * effectiveIBirds;
                double ItoR = this.getAvianRecoveryRate() * currentDiseaseState.getI();
                deltaS = -StoI;
                deltaI = StoI - ItoR;
                deltaR = ItoR;
                Exchange siExchange = (Exchange)ExchangePool.POOL.get();
                siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
                siExchange.setCount(StoI);
                siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
                siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)siExchange);
                Exchange irExchange = (Exchange)ExchangePool.POOL.get();
                irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
                irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
                irExchange.setCount(ItoR);
                irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)irExchange);
                deltaValue.setS(deltaS);
                deltaValue.setI(deltaI);
                deltaValue.setR(deltaR);
                deltaValue.setIncidence(StoI);
            }
            deltaValue.scale((double)timeDelta / (double)this.getTimePeriod());
            this.computeAdditionalDeltasAndExchanges((IntegrationLabel)diseaseLabel, time, t, timeDelta);
            ++_i;
        }
    }

    H7N9Label findDiseaseLabel(Node n, String identifier) {
        for (NodeLabel nl : n.getLabels()) {
            if (!(nl instanceof H7N9Label) || !((DiseaseModelLabel)nl).getPopulationModelLabel().getPopulationIdentifier().equals(identifier)) continue;
            return (H7N9Label)nl;
        }
        return null;
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        H7N9Label label = AvianinfluenzaFactory.eINSTANCE.createH7N9Label();
        label.setTypeURI(DiseaseModelLabel.URI_TYPE_DYNAMIC_DISEASE_LABEL);
        return label;
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return AvianinfluenzaFactory.eINSTANCE.createH7N9LabelValue();
    }
}

