/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.foodproduction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConsumptionType implements Enumerator
{
    RELATIVE_CONSUMPTION(1, "RELATIVE_CONSUMPTION", "RELATIVE_CONSUMPTION"),
    ABSOLUTE_CONSUMPTION(2, "ABSOLUTE_CONSUMPTION", "ABSOLUTE_CONSUMPTION"),
    CONSUMPTION_PER_PERSON(3, "CONSUMPTION_PER_PERSON", "CONSUMPTION_PER_PERSON");

    public static final int RELATIVE_CONSUMPTION_VALUE = 1;
    public static final int ABSOLUTE_CONSUMPTION_VALUE = 2;
    public static final int CONSUMPTION_PER_PERSON_VALUE = 3;
    private static final ConsumptionType[] VALUES_ARRAY;
    public static final List<ConsumptionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConsumptionType[]{RELATIVE_CONSUMPTION, ABSOLUTE_CONSUMPTION, CONSUMPTION_PER_PERSON};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConsumptionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConsumptionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConsumptionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConsumptionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConsumptionType get(int value) {
        switch (value) {
            case 1: {
                return RELATIVE_CONSUMPTION;
            }
            case 2: {
                return ABSOLUTE_CONSUMPTION;
            }
            case 3: {
                return CONSUMPTION_PER_PERSON;
            }
        }
        return null;
    }

    private ConsumptionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

