/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.gis.proj;

import java.util.Properties;
import org.eclipse.stem.gis.Activator;
import org.eclipse.stem.gis.coord.ProjectedCoordinateSystem;
import org.eclipse.stem.gis.proj.NullProjection;
import org.eclipse.stem.gis.proj.Projection;
import org.eclipse.stem.gis.proj.TransverseMercatorProjection;

public class ESRIProjectionFactory {
    public static Projection getForCoordinateSystem(ProjectedCoordinateSystem cs) {
        if ("Transverse_Mercator".equals(cs.getProjectionName())) {
            return ESRIProjectionFactory.getTransverseMercatorProjection(cs);
        }
        Activator.logWarning("Warning: Projection " + cs.getProjectionName() + " in coordinate system " + cs.getName() + " is not supported.", null);
        return new NullProjection();
    }

    private static Projection getTransverseMercatorProjection(ProjectedCoordinateSystem cs) {
        Properties projectionProperties = cs.getProperties();
        double falseNorthing = Double.valueOf(projectionProperties.getProperty("False_Northing", "0.0"));
        double falseEasting = Double.valueOf(projectionProperties.getProperty("False_Easting", "0.0"));
        double scale = Double.valueOf(projectionProperties.getProperty("Scale_Factor", "0.0"));
        double centralMeridianLongitude = Double.valueOf(projectionProperties.getProperty("Central_Meridian", "0.0"));
        return new TransverseMercatorProjection(falseEasting, falseNorthing, centralMeridianLongitude, scale, cs.getGeoCoordinateSystem().getDatum());
    }
}

