/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl.ui.highlight;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class CTDLHighlightConfiguration
extends DefaultHighlightingConfiguration {
    public static final String FUNCTION_ID = "function";
    public static final String RELATIVE_COMPARTMENT_ID = "compartmentRelative";
    public static final String ABSOLUTE_COMPARTMENT_ID = "compartmentAbsolute";
    public static final String GLOBAL_VARIABLE_ID = "variableGlobal";
    public static final String LOCAL_VARIABLE_ID = "variableLocal";
    public static final String MODEL_PARAMETER_ID = "modelParameter";
    public static final String BOOLEAN_ID = "boolean";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        super.configure(acceptor);
        acceptor.acceptDefaultHighlighting(BOOLEAN_ID, "Boolean", this.booleanTextStyle());
        acceptor.acceptDefaultHighlighting(MODEL_PARAMETER_ID, "Model Parameter", this.modelParameterTextStyle());
        acceptor.acceptDefaultHighlighting(GLOBAL_VARIABLE_ID, "Global Variable", this.globalVariableTextStyle());
        acceptor.acceptDefaultHighlighting(LOCAL_VARIABLE_ID, "Local Variable", this.localVariableTextStyle());
        acceptor.acceptDefaultHighlighting(RELATIVE_COMPARTMENT_ID, "Relative Compartment", this.relativeCompartmentTextStyle());
        acceptor.acceptDefaultHighlighting(ABSOLUTE_COMPARTMENT_ID, "Absolute Compartment", this.absoluteCompartmentTextStyle());
        acceptor.acceptDefaultHighlighting(FUNCTION_ID, "Function", this.functionTextStyle());
    }

    public TextStyle numberTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(102, 102, 102));
        return textStyle;
    }

    public TextStyle booleanTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(128, 0, 128));
        return textStyle;
    }

    public TextStyle modelParameterTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(165, 0, 0));
        return textStyle;
    }

    public TextStyle globalVariableTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(64, 0, 128));
        return textStyle;
    }

    public TextStyle localVariableTextStyle() {
        TextStyle textStyle = this.globalVariableTextStyle().copy();
        textStyle.setStyle(1);
        return textStyle;
    }

    public TextStyle relativeCompartmentTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 128, 0));
        return textStyle;
    }

    public TextStyle absoluteCompartmentTextStyle() {
        TextStyle textStyle = this.relativeCompartmentTextStyle().copy();
        textStyle.setStyle(1);
        return textStyle;
    }

    public TextStyle functionTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 64, 128));
        textStyle.setStyle(1);
        return textStyle;
    }
}

