/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stem.model.ctdl.ctdl.AbsoluteCompartmentValueReference;
import org.eclipse.stem.model.ctdl.ctdl.Block;
import org.eclipse.stem.model.ctdl.ctdl.BooleanLiteral;
import org.eclipse.stem.model.ctdl.ctdl.CompartmentTransitionDefinitions;
import org.eclipse.stem.model.ctdl.ctdl.DefStatement;
import org.eclipse.stem.model.ctdl.ctdl.Div;
import org.eclipse.stem.model.ctdl.ctdl.Evaluation;
import org.eclipse.stem.model.ctdl.ctdl.Expression;
import org.eclipse.stem.model.ctdl.ctdl.ExternalFunctionReference;
import org.eclipse.stem.model.ctdl.ctdl.FunctionCall;
import org.eclipse.stem.model.ctdl.ctdl.FunctionReference;
import org.eclipse.stem.model.ctdl.ctdl.GlobalVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.LocalVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.MetamodelResource;
import org.eclipse.stem.model.ctdl.ctdl.Minus;
import org.eclipse.stem.model.ctdl.ctdl.ModelParamReference;
import org.eclipse.stem.model.ctdl.ctdl.Multi;
import org.eclipse.stem.model.ctdl.ctdl.NumberLiteral;
import org.eclipse.stem.model.ctdl.ctdl.Plus;
import org.eclipse.stem.model.ctdl.ctdl.PrimaryExpression;
import org.eclipse.stem.model.ctdl.ctdl.RelativeCompartmentValueReference;
import org.eclipse.stem.model.ctdl.ctdl.ReturnStatement;
import org.eclipse.stem.model.ctdl.ctdl.ScopedVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.StringLiteral;
import org.eclipse.stem.model.ctdl.ctdl.TransitionBlock;
import org.eclipse.stem.model.ctdl.ctdl.VariableReference;
import org.eclipse.stem.model.ctdl.functions.ExternalFunctionDefinition;
import org.eclipse.stem.model.ctdl.functions.FunctionArgumentReference;
import org.eclipse.stem.model.ctdl.functions.JavaMethodArgument;
import org.eclipse.stem.model.ctdl.functions.SystemArgumentReference;
import org.eclipse.stem.model.ctdl.generator.ModelExpressionGenerator;
import org.eclipse.stem.model.ctdl.serializer.ITypeSerializer;
import org.eclipse.stem.model.ctdl.serializer.TypeSerializerFactory;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.ModelParam;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CTDLGenerator2
extends ModelExpressionGenerator {
    private GenClass _modelGenClass;
    private GenClass _labelGenClass;
    private GenClass _labelValueGenClass;

    public GenClass getModelGenClass() {
        return this._modelGenClass;
    }

    public void setModelGenClass(GenClass modelGenClass) {
        this._modelGenClass = modelGenClass;
    }

    public GenClass getLabelGenClass() {
        return this._labelGenClass;
    }

    public void setLabelGenClass(GenClass labelGenClass) {
        this._labelGenClass = labelGenClass;
    }

    public GenClass getLabelValueGenClass() {
        return this._labelValueGenClass;
    }

    public void setLabelValueGenClass(GenClass labelValueGenClass) {
        this._labelValueGenClass = labelValueGenClass;
    }

    @Override
    public void doGenerate(List<XtextResource> resources, IFileSystemAccess fsa) {
        GenClass _modelGenClass = this.getModelGenClass();
        String _name = _modelGenClass.getName();
        String fileName = String.valueOf(_name) + "Expressions.java";
        CharSequence _build = this.build(resources);
        fsa.generateFile(fileName, _build);
    }

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator _allContents = resource.getAllContents();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)_allContents);
        Iterable _filter = Iterables.filter((Iterable)_iterable, CompartmentTransitionDefinitions.class);
        CompartmentTransitionDefinitions ctd = (CompartmentTransitionDefinitions)IterableExtensions.head((Iterable)_filter);
        MetamodelResource mm = ctd.getMetamodel();
        Transition trans = mm.getTransition();
        Compartment _source = trans.getSource();
        String _name = _source.getName();
        String _plus = String.valueOf(_name) + "_";
        Compartment _target = trans.getTarget();
        String _name_1 = _target.getName();
        String fname = String.valueOf(_plus) + _name_1;
        CharSequence _compile = this.compile((Notifier)resource);
        fsa.generateFile(fname, _compile);
    }

    public CharSequence build(List<XtextResource> r) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        GenClass _modelGenClass = this.getModelGenClass();
        GenPackage _genPackage = _modelGenClass.getGenPackage();
        String _classPackageName = _genPackage.getClassPackageName();
        _builder.append((Object)_classPackageName, "");
        _builder.append((Object)";");
        StringConcatenation pkg = _builder;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"\t\t");
        _builder_1.append((Object)"/**");
        _builder_1.newLine();
        _builder_1.append((Object)"\t\t ");
        _builder_1.append((Object)"* Generated expressions class for ");
        GenClass _modelGenClass_1 = this.getModelGenClass();
        String _name = _modelGenClass_1.getName();
        _builder_1.append((Object)_name, "\t\t ");
        _builder_1.append((Object)".");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append((Object)"\t\t ");
        _builder_1.append((Object)"* DO NOT EDIT DIRECTLY.  Use extended class and override methods for transitions as desired.");
        _builder_1.newLine();
        _builder_1.append((Object)"\t\t ");
        _builder_1.append((Object)"* @generated");
        _builder_1.newLine();
        _builder_1.append((Object)"\t\t ");
        _builder_1.append((Object)"*/");
        _builder_1.newLine();
        _builder_1.append((Object)"\t\t");
        _builder_1.append((Object)"public class ");
        GenClass _modelGenClass_2 = this.getModelGenClass();
        String _name_1 = _modelGenClass_2.getName();
        _builder_1.append((Object)_name_1, "\t\t");
        _builder_1.append((Object)"Expressions {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append((Object)"\t");
        _builder_1.append((Object)"public void calculate(double t, long timeDelta, ");
        String _importedName = this.getImportedName("org.eclipse.stem.core.model.STEMTime");
        _builder_1.append((Object)_importedName, "\t");
        _builder_1.append((Object)" time, ");
        GenClass _modelGenClass_3 = this.getModelGenClass();
        String _importGenClassInterface = this.importGenClassInterface(_modelGenClass_3);
        _builder_1.append((Object)_importGenClassInterface, "\t");
        _builder_1.append((Object)" model, ");
        GenClass _labelGenClass = this.getLabelGenClass();
        String _importGenClassInterface_1 = this.importGenClassInterface(_labelGenClass);
        _builder_1.append((Object)_importGenClassInterface_1, "\t");
        _builder_1.append((Object)" label, ");
        GenClass _labelValueGenClass = this.getLabelValueGenClass();
        String _importGenClassInterface_2 = this.importGenClassInterface(_labelValueGenClass);
        _builder_1.append((Object)_importGenClassInterface_2, "\t");
        _builder_1.append((Object)" labelValue, ");
        String _importedName_1 = this.getImportedName("org.eclipse.stem.core.graph.Node");
        _builder_1.append((Object)_importedName_1, "\t");
        _builder_1.append((Object)" node) {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append((Object)"\t");
        _builder_1.append((Object)"}");
        _builder_1.newLine();
        _builder_1.append((Object)"\t\t\t");
        _builder_1.newLine();
        for (XtextResource e : r) {
            CharSequence _compile = this.compile((Notifier)e);
            _builder_1.append((Object)_compile, "");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append((Object)"} //");
        StringConcatenation body = _builder_1;
        String imports = this.getSortedImports();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append((Object)pkg, "");
        _builder_2.newLineIfNotEmpty();
        _builder_2.newLine();
        _builder_2.append((Object)imports, "");
        _builder_2.newLineIfNotEmpty();
        _builder_2.newLine();
        _builder_2.append((Object)body, "");
        return _builder_2;
    }

    protected CharSequence _compile(Resource r) {
        StringConcatenation _builder = new StringConcatenation();
        TreeIterator _allContents = r.getAllContents();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)_allContents);
        Iterable _filter = Iterables.filter((Iterable)_iterable, TransitionBlock.class);
        TransitionBlock _head = (TransitionBlock)IterableExtensions.head((Iterable)_filter);
        CharSequence _compile = this.compile((Notifier)_head);
        _builder.append((Object)_compile, "");
        return _builder;
    }

    protected CharSequence _compile(TransitionBlock t) {
        EObject _eContainer = t.eContainer();
        CompartmentTransitionDefinitions ctd = (CompartmentTransitionDefinitions)_eContainer;
        MetamodelResource _metamodel = ctd.getMetamodel();
        Transition transition = _metamodel.getTransition();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Computes delta for transition ");
        Compartment _source = transition.getSource();
        String _name = _source.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" -> ");
        Compartment _target = transition.getTarget();
        String _name_1 = _target.getName();
        _builder.append((Object)_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"protected double ");
        Compartment _source_1 = transition.getSource();
        String _name_2 = _source_1.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"_");
        Compartment _target_1 = transition.getTarget();
        String _name_3 = _target_1.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)" (double t, long timeDelta, ");
        String _importedName = this.getImportedName("org.eclipse.stem.core.model.STEMTime");
        _builder.append((Object)_importedName, "");
        _builder.append((Object)" time, ");
        GenClass _modelGenClass = this.getModelGenClass();
        String _importGenClassInterface = this.importGenClassInterface(_modelGenClass);
        _builder.append((Object)_importGenClassInterface, "");
        _builder.append((Object)" model, ");
        GenClass _labelGenClass = this.getLabelGenClass();
        String _importGenClassInterface_1 = this.importGenClassInterface(_labelGenClass);
        _builder.append((Object)_importGenClassInterface_1, "");
        _builder.append((Object)" label, ");
        GenClass _labelValueGenClass = this.getLabelValueGenClass();
        String _importGenClassInterface_2 = this.importGenClassInterface(_labelValueGenClass);
        _builder.append((Object)_importGenClassInterface_2, "");
        _builder.append((Object)" labelValue, ");
        String _importedName_1 = this.getImportedName("org.eclipse.stem.core.graph.Node");
        _builder.append((Object)_importedName_1, "");
        _builder.append((Object)" node) {");
        _builder.newLineIfNotEmpty();
        Block _block = t.getBlock();
        EList<DefStatement> _statements = _block.getStatements();
        for (DefStatement s : _statements) {
            CharSequence _compile = this.compile((Notifier)s);
            _builder.append((Object)_compile, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"return ");
        Block _block_1 = t.getBlock();
        ReturnStatement _ret = _block_1.getRet();
        CharSequence _compile_1 = this.compile((Notifier)_ret);
        _builder.append((Object)_compile_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _compile(DefStatement d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"double ");
        String _varname = d.getVarname();
        _builder.append((Object)_varname, "");
        _builder.append((Object)"=");
        Evaluation _expr = d.getExpr();
        CharSequence _compile = this.compile((Notifier)_expr);
        _builder.append((Object)_compile, "");
        _builder.append((Object)";");
        return _builder;
    }

    protected CharSequence _compile(Evaluation e) {
        StringConcatenation _builder = new StringConcatenation();
        Expression _expression = e.getExpression();
        CharSequence _compile = this.compile(_expression, Double.TYPE);
        _builder.append((Object)_compile, "");
        return _builder;
    }

    protected CharSequence _compile(PrimaryExpression pe, Class<? extends Object> expectedType) {
        String neg = "";
        boolean _isNegate = pe.isNegate();
        if (_isNegate) {
            neg = "-";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"(");
        _builder.append((Object)neg, "");
        Expression _exp = pe.getExp();
        CharSequence _compile = this.compile(_exp, expectedType);
        _builder.append((Object)_compile, "");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _compile(Plus p, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"(");
        Expression _left = p.getLeft();
        CharSequence _compile = this.compile(_left, Double.TYPE);
        _builder.append((Object)_compile, "");
        _builder.append((Object)"+");
        Expression _right = p.getRight();
        CharSequence _compile_1 = this.compile(_right, Double.TYPE);
        _builder.append((Object)_compile_1, "");
        _builder.append((Object)")");
        return _builder;
    }

    protected CharSequence _compile(Minus m, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"(");
        Expression _left = m.getLeft();
        CharSequence _compile = this.compile(_left, Double.TYPE);
        _builder.append((Object)_compile, "");
        _builder.append((Object)"-");
        Expression _right = m.getRight();
        CharSequence _compile_1 = this.compile(_right, Double.TYPE);
        _builder.append((Object)_compile_1, "");
        _builder.append((Object)")");
        return _builder;
    }

    protected CharSequence _compile(Multi m, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        Expression _left = m.getLeft();
        CharSequence _compile = this.compile(_left, Double.TYPE);
        _builder.append((Object)_compile, "");
        _builder.append((Object)"*");
        Expression _right = m.getRight();
        CharSequence _compile_1 = this.compile(_right, Double.TYPE);
        _builder.append((Object)_compile_1, "");
        return _builder;
    }

    protected CharSequence _compile(Div d, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        Expression _left = d.getLeft();
        CharSequence _compile = this.compile(_left, Double.TYPE);
        _builder.append((Object)_compile, "");
        _builder.append((Object)"/");
        Expression _right = d.getRight();
        CharSequence _compile_1 = this.compile(_right, Double.TYPE);
        _builder.append((Object)_compile_1, "");
        return _builder;
    }

    protected CharSequence _compileReference(GlobalVariableReference rf, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = rf.getName();
        _builder.append((Object)_name, "");
        return _builder;
    }

    protected CharSequence _compileReference(LocalVariableReference rf, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = rf.getName();
        _builder.append((Object)_name, "");
        return _builder;
    }

    protected CharSequence _compileReference(AbsoluteCompartmentValueReference rf, Class<? extends Object> expectedType) {
        boolean _notEquals;
        GenClass _labelValueGenClass = this.getLabelValueGenClass();
        ITypeSerializer serializer = TypeSerializerFactory.getSerializer(rf, expectedType, _labelValueGenClass);
        boolean bl = _notEquals = !Objects.equal((Object)serializer, null);
        if (_notEquals) {
            return serializer.serialize();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"labelValue.get");
        Compartment _obj = rf.getObj();
        String _name = _obj.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"()");
        return _builder;
    }

    protected CharSequence _compileReference(RelativeCompartmentValueReference rf, Class<? extends Object> expectedType) {
        boolean _notEquals;
        GenClass _labelValueGenClass = this.getLabelValueGenClass();
        ITypeSerializer serializer = TypeSerializerFactory.getSerializer(rf, expectedType, _labelValueGenClass);
        boolean bl = _notEquals = !Objects.equal((Object)serializer, null);
        if (_notEquals) {
            return serializer.serialize();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"labelValue.get");
        Compartment _obj = rf.getObj();
        String _name = _obj.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"()/labelValue.getPopulationCount()");
        return _builder;
    }

    protected CharSequence _compileReference(ModelParamReference rf, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        ModelParam _obj = rf.getObj();
        String _name = _obj.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"()");
        return _builder;
    }

    protected CharSequence _compile(VariableReference rf, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        ScopedVariableReference _ref = rf.getRef();
        CharSequence _compileReference = this.compileReference(_ref, expectedType);
        _builder.append((Object)_compileReference, "");
        return _builder;
    }

    protected CharSequence _compile(NumberLiteral nl, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        double _value = nl.getValue();
        _builder.append((Object)_value, "");
        return _builder;
    }

    protected CharSequence _compile(StringLiteral sl, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\"");
        String _value = sl.getValue();
        _builder.append((Object)_value, "");
        _builder.append((Object)"\"");
        return _builder;
    }

    protected CharSequence _compile(BooleanLiteral bl, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isValue = bl.isValue();
        _builder.append((Object)_isValue, "");
        return _builder;
    }

    protected CharSequence _compileArgument(SystemArgumentReference arg, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        String _mapsFrom = arg.getMapsFrom();
        _builder.append((Object)_mapsFrom, "");
        return _builder;
    }

    protected CharSequence _compileArgument(FunctionArgumentReference arg, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Expression> _args = fc.getArgs();
        int _argIndex = arg.getArgIndex();
        Expression _get = (Expression)_args.get(_argIndex);
        Class _javaType = arg.getJavaType();
        CharSequence _compile = this.compile(_get, _javaType);
        _builder.append((Object)_compile, "");
        return _builder;
    }

    protected CharSequence _compileFunction(ExternalFunctionReference fcr, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        ExternalFunctionDefinition _func = fcr.getFunc();
        String _className = _func.getClassName();
        String _importedName = this.getImportedName(_className);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)".");
        ExternalFunctionDefinition _func_1 = fcr.getFunc();
        String _methodName = _func_1.getMethodName();
        _builder.append((Object)_methodName, "");
        _builder.append((Object)"(");
        _builder.newLineIfNotEmpty();
        ExternalFunctionDefinition _func_2 = fcr.getFunc();
        EList _javaMethodArguments = _func_2.getJavaMethodArguments();
        for (JavaMethodArgument arg : _javaMethodArguments) {
            boolean _notEquals;
            _builder.append((Object)"\t\t");
            ExternalFunctionDefinition _func_3 = fcr.getFunc();
            EList _javaMethodArguments_1 = _func_3.getJavaMethodArguments();
            JavaMethodArgument _head = (JavaMethodArgument)IterableExtensions.head((Iterable)_javaMethodArguments_1);
            boolean bl = _notEquals = !Objects.equal((Object)arg, (Object)_head);
            if (_notEquals) {
                _builder.append((Object)",");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            CharSequence _compileArgument = this.compileArgument(arg, fc);
            _builder.append((Object)_compileArgument, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
        }
        _builder.append((Object)")");
        return _builder;
    }

    protected CharSequence _compileFunction(FunctionReference fcr, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = fcr.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        EList<Expression> _args = fc.getArgs();
        for (Expression e : _args) {
            _builder.append((Object)" ");
            _builder.newLineIfNotEmpty();
            EList<Expression> _args_1 = fc.getArgs();
            Expression _head = (Expression)IterableExtensions.head(_args_1);
            boolean _equals = Objects.equal((Object)e, (Object)_head);
            if (_equals) {
                CharSequence _compile = this.compile((Notifier)e);
                _builder.append((Object)_compile, "");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)",");
                CharSequence _compile_1 = this.compile((Notifier)e);
                _builder.append((Object)_compile_1, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t\t");
        }
        _builder.append((Object)")");
        return _builder;
    }

    protected CharSequence _compile(FunctionCall fc, Class<? extends Object> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        FunctionReference _ref = fc.getRef();
        CharSequence _compileFunction = this.compileFunction(_ref, fc);
        _builder.append((Object)_compileFunction, "");
        return _builder;
    }

    public CharSequence compile(Notifier e) {
        if (e instanceof Evaluation) {
            return this._compile((Evaluation)e);
        }
        if (e instanceof DefStatement) {
            return this._compile((DefStatement)e);
        }
        if (e instanceof TransitionBlock) {
            return this._compile((TransitionBlock)e);
        }
        if (e instanceof Resource) {
            return this._compile((Resource)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public CharSequence compile(Expression bl, Class<? extends Object> expectedType) {
        if (bl instanceof BooleanLiteral) {
            return this._compile((BooleanLiteral)bl, expectedType);
        }
        if (bl instanceof Div) {
            return this._compile((Div)bl, expectedType);
        }
        if (bl instanceof FunctionCall) {
            return this._compile((FunctionCall)bl, expectedType);
        }
        if (bl instanceof Minus) {
            return this._compile((Minus)bl, expectedType);
        }
        if (bl instanceof Multi) {
            return this._compile((Multi)bl, expectedType);
        }
        if (bl instanceof NumberLiteral) {
            return this._compile((NumberLiteral)bl, expectedType);
        }
        if (bl instanceof Plus) {
            return this._compile((Plus)bl, expectedType);
        }
        if (bl instanceof PrimaryExpression) {
            return this._compile((PrimaryExpression)bl, expectedType);
        }
        if (bl instanceof StringLiteral) {
            return this._compile((StringLiteral)bl, expectedType);
        }
        if (bl instanceof VariableReference) {
            return this._compile((VariableReference)bl, expectedType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(bl, expectedType).toString());
    }

    public CharSequence compileReference(ScopedVariableReference rf, Class<? extends Object> expectedType) {
        if (rf instanceof AbsoluteCompartmentValueReference) {
            return this._compileReference((AbsoluteCompartmentValueReference)rf, expectedType);
        }
        if (rf instanceof RelativeCompartmentValueReference) {
            return this._compileReference((RelativeCompartmentValueReference)rf, expectedType);
        }
        if (rf instanceof GlobalVariableReference) {
            return this._compileReference((GlobalVariableReference)rf, expectedType);
        }
        if (rf instanceof LocalVariableReference) {
            return this._compileReference((LocalVariableReference)rf, expectedType);
        }
        if (rf instanceof ModelParamReference) {
            return this._compileReference((ModelParamReference)rf, expectedType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(rf, expectedType).toString());
    }

    public CharSequence compileArgument(JavaMethodArgument arg, FunctionCall fc) {
        if (arg instanceof FunctionArgumentReference) {
            return this._compileArgument((FunctionArgumentReference)arg, fc);
        }
        if (arg instanceof SystemArgumentReference) {
            return this._compileArgument((SystemArgumentReference)arg, fc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(arg, fc).toString());
    }

    public CharSequence compileFunction(FunctionReference fcr, FunctionCall fc) {
        if (fcr instanceof ExternalFunctionReference) {
            return this._compileFunction((ExternalFunctionReference)fcr, fc);
        }
        if (fcr != null) {
            return this._compileFunction(fcr, fc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fcr, fc).toString());
    }
}

