/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl.scoping;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.stem.model.ctdl.CTDLUtils;
import org.eclipse.stem.model.ctdl.ctdl.BooleanLiteral;
import org.eclipse.stem.model.ctdl.ctdl.CompartmentReference;
import org.eclipse.stem.model.ctdl.ctdl.CompartmentTransitionDefinitions;
import org.eclipse.stem.model.ctdl.ctdl.CtdlFactory;
import org.eclipse.stem.model.ctdl.ctdl.CtdlPackage;
import org.eclipse.stem.model.ctdl.ctdl.Expression;
import org.eclipse.stem.model.ctdl.ctdl.ExternalFunctionReference;
import org.eclipse.stem.model.ctdl.ctdl.FunctionCall;
import org.eclipse.stem.model.ctdl.ctdl.FunctionReference;
import org.eclipse.stem.model.ctdl.ctdl.GlobalVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.LocalVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.MetamodelResource;
import org.eclipse.stem.model.ctdl.ctdl.ModelParamReference;
import org.eclipse.stem.model.ctdl.ctdl.NumberLiteral;
import org.eclipse.stem.model.ctdl.ctdl.PrimaryExpression;
import org.eclipse.stem.model.ctdl.ctdl.ScopedVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.StringLiteral;
import org.eclipse.stem.model.ctdl.ctdl.VariableReference;
import org.eclipse.stem.model.ctdl.functions.STEMDSLUtils;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.nodemodel.INode;

public class MetamodelContextLinker
extends DefaultLinkingService {
    private Package metamodel;
    private Model model;
    private Transition transition;

    public void setTransition(Transition transition) {
        this.transition = transition;
        this.model = transition != null ? transition.getContainerModel() : null;
        this.metamodel = this.model != null ? this.model.getContainerPackage() : null;
    }

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        if (context instanceof CompartmentTransitionDefinitions && ref.getEReferenceType() == CtdlPackage.Literals.METAMODEL_RESOURCE) {
            MetamodelResource mmrs = CtdlFactory.eINSTANCE.createMetamodelResource();
            mmrs.setModel(this.model);
            mmrs.setPackage(this.metamodel);
            mmrs.setTransition(this.transition);
            return Collections.singletonList(mmrs);
        }
        return super.getLinkedObjects(context, ref, node);
    }

    public String getCrossRefNodeAsString(INode node) throws IllegalNodeException {
        String result = super.getCrossRefNodeAsString(node);
        EObject element = node.getSemanticElement();
        if (element instanceof FunctionCall) {
            FunctionCall fc = (FunctionCall)element;
            StringBuilder sb = new StringBuilder(result);
            sb.append("(");
            boolean first = true;
            for (Expression expr : fc.getArgs()) {
                if (!first) {
                    sb.append(",");
                }
                if (expr instanceof StringLiteral) {
                    sb.append("string");
                } else if (expr instanceof BooleanLiteral) {
                    sb.append("boolean");
                } else if (expr instanceof PrimaryExpression) {
                    if (expr.getExp() instanceof VariableReference) {
                        sb.append(this.getTypeForVariableReference((VariableReference)expr.getExp()));
                    } else if (expr.getExp() instanceof NumberLiteral) {
                        sb.append("number");
                    }
                } else if (expr instanceof FunctionCall) {
                    sb.append(this.getTypeForFunctionReference(((FunctionCall)expr).getRef()));
                } else {
                    sb.append("number");
                }
                first = false;
            }
            sb.append(")");
            result = sb.toString();
        }
        return result;
    }

    private String getTypeForFunctionReference(FunctionReference var) {
        Class refType = null;
        refType = var instanceof ExternalFunctionReference ? ((ExternalFunctionReference)var).getFunc().getReturnType() : Double.TYPE;
        return CTDLUtils.getNormalizedTypeNameForClass(refType);
    }

    private String getTypeForVariableReference(VariableReference var) {
        ScopedVariableReference ref = var.getRef();
        Class refType = Double.TYPE;
        if (ref != null) {
            if (ref instanceof CompartmentReference) {
                return "compartment";
            }
            if (ref instanceof ModelParamReference) {
                refType = ((ModelParamReference)ref).getObj().getDataType().getInstanceClass();
            } else if (!(ref instanceof LocalVariableReference) && ref instanceof GlobalVariableReference) {
                refType = STEMDSLUtils.getTypeForGlobalVariable((String)ref.getName());
            }
        }
        return CTDLUtils.getNormalizedTypeNameForClass(refType);
    }
}

