/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stem.model.metamodel.ModelParam;
import org.eclipse.stem.model.metamodel.ModelParamConstraint;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ModelParamConstraintEditorDialog
extends Dialog {
    ModelParam param;
    ModelParamConstraint constraint;
    Text valueText;
    ComboViewer nameViewer;

    public ModelParamConstraintEditorDialog(Shell parentShell, int style, ModelParam param, ModelParamConstraint constraint) {
        super(parentShell);
        this.param = param;
        this.constraint = constraint;
    }

    public void create() {
        String[] constraints;
        super.create();
        this.valueText.setText(WizardHelper.safeGet(this.constraint.getConstraint()));
        String selectedConstraint = this.constraint.getName();
        if (selectedConstraint == null && (constraints = WizardHelper.getAvailableConstraints(this.param, this.constraint)) != null && constraints.length > 0) {
            selectedConstraint = constraints[0];
        }
        if (selectedConstraint != null) {
            this.nameViewer.setSelection((ISelection)new StructuredSelection((Object)selectedConstraint));
        }
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Composite container = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(2, false));
        this.createConstraintNameList(container);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("Constraint Value");
        this.valueText = new Text(container, 2048);
        this.valueText.setLayoutData((Object)new GridData(768));
        return parent;
    }

    private void createConstraintNameList(Composite container) {
        Label dataTypeLabel = new Label(container, 0);
        dataTypeLabel.setText("Constraint Type");
        this.nameViewer = new ComboViewer(container, 8);
        this.nameViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.nameViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.nameViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.nameViewer.setInput((Object)WizardHelper.getAvailableConstraints(this.param, this.constraint));
    }

    protected boolean validate() {
        return true;
    }

    protected void okPressed() {
        if (this.validate()) {
            this.constraint.setName((String)((StructuredSelection)this.nameViewer.getSelection()).getFirstElement());
            this.constraint.setConstraint(WizardHelper.safeGet(this.valueText));
            super.okPressed();
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

