/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.stem.populationmodels.standard.provider.StandardHistoryProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.provider.StandardRelativeValueHistoryProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.provider.StandardRelativeValueProviderAdapterFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.stem.populationmodels";
    public static final String CLASS_FIELD = "class";
    private static final String POP_MODEL_UI_PLUGIN_NAME = "org.eclipse.stem.ui.populationmodels";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Bundle popBundle = Platform.getBundle((String)POP_MODEL_UI_PLUGIN_NAME);
        if (popBundle != null) {
            popBundle.start(1);
        } else {
            System.err.println("Pop Model UI plugin not found.  Distributed mode not enabled.");
        }
        new StandardRelativeValueProviderAdapterFactory();
        new StandardRelativeValueHistoryProviderAdapterFactory();
        new StandardHistoryProviderAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logError(String message, Throwable exception) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, message, exception));
        } else {
            System.err.println(message);
            if (exception != null) {
                System.err.println(exception.getMessage());
                exception.printStackTrace(System.err);
            }
        }
    }

    public static void logWarning(String message, Throwable exception) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(2, plugin.getBundle().getSymbolicName(), 0, message, exception));
        } else {
            System.out.println(message);
            if (exception != null) {
                System.out.println(exception.getMessage());
                exception.printStackTrace(System.err);
            }
        }
    }

    public static void logInformation(String message, Throwable exception) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, exception));
        } else {
            System.out.println(message);
            if (exception != null) {
                System.out.println(exception.getMessage());
                exception.printStackTrace(System.err);
            }
        }
    }

    public static void logInformation(String message) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, null));
        } else {
            System.out.println(message);
        }
    }
}

