/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.rk.impl;

import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.solvers.rk.DormandPrince853;
import org.eclipse.stem.solvers.rk.RkPackage;
import org.eclipse.stem.solvers.rk.impl.ApacheCommonsMathODESolverImpl;

public class DormandPrince853Impl
extends ApacheCommonsMathODESolverImpl
implements DormandPrince853 {
    protected static final double RELATIVE_TOLERANCE_EDEFAULT = 1.0E-9;
    protected double relativeTolerance = 1.0E-9;
    protected static final double ABSOLUTE_TOLERANCE_EDEFAULT = 1.0E-5;
    protected double absoluteTolerance = 1.0E-5;
    protected static final double MIN_STEP_EDEFAULT = 1.0E-8;
    protected double minStep = 1.0E-8;
    protected static final double MAX_STEP_EDEFAULT = 1.0;
    protected double maxStep = 1.0;

    @Override
    public FirstOrderIntegrator createIntegrator() {
        DormandPrince853Integrator dp853 = new DormandPrince853Integrator(this.getMinStep(), this.getMaxStep(), this.getAbsoluteTolerance(), this.getRelativeTolerance());
        return dp853;
    }

    @Override
    protected EClass eStaticClass() {
        return RkPackage.Literals.DORMAND_PRINCE853;
    }

    @Override
    public double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    @Override
    public void setRelativeTolerance(double newRelativeTolerance) {
        double oldRelativeTolerance = this.relativeTolerance;
        this.relativeTolerance = newRelativeTolerance;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldRelativeTolerance, this.relativeTolerance));
        }
    }

    @Override
    public double getAbsoluteTolerance() {
        return this.absoluteTolerance;
    }

    @Override
    public void setAbsoluteTolerance(double newAbsoluteTolerance) {
        double oldAbsoluteTolerance = this.absoluteTolerance;
        this.absoluteTolerance = newAbsoluteTolerance;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldAbsoluteTolerance, this.absoluteTolerance));
        }
    }

    @Override
    public double getMinStep() {
        return this.minStep;
    }

    @Override
    public void setMinStep(double newMinStep) {
        double oldMinStep = this.minStep;
        this.minStep = newMinStep;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldMinStep, this.minStep));
        }
    }

    @Override
    public double getMaxStep() {
        return this.maxStep;
    }

    @Override
    public void setMaxStep(double newMaxStep) {
        double oldMaxStep = this.maxStep;
        this.maxStep = newMaxStep;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldMaxStep, this.maxStep));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getRelativeTolerance();
            }
            case 6: {
                return this.getAbsoluteTolerance();
            }
            case 7: {
                return this.getMinStep();
            }
            case 8: {
                return this.getMaxStep();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setRelativeTolerance((Double)newValue);
                return;
            }
            case 6: {
                this.setAbsoluteTolerance((Double)newValue);
                return;
            }
            case 7: {
                this.setMinStep((Double)newValue);
                return;
            }
            case 8: {
                this.setMaxStep((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setRelativeTolerance(1.0E-9);
                return;
            }
            case 6: {
                this.setAbsoluteTolerance(1.0E-5);
                return;
            }
            case 7: {
                this.setMinStep(1.0E-8);
                return;
            }
            case 8: {
                this.setMaxStep(1.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.relativeTolerance != 1.0E-9;
            }
            case 6: {
                return this.absoluteTolerance != 1.0E-5;
            }
            case 7: {
                return this.minStep != 1.0E-8;
            }
            case 8: {
                return this.maxStep != 1.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (relativeTolerance: ");
        result.append(this.relativeTolerance);
        result.append(", absoluteTolerance: ");
        result.append(this.absoluteTolerance);
        result.append(", minStep: ");
        result.append(this.minStep);
        result.append(", maxStep: ");
        result.append(this.maxStep);
        result.append(')');
        return result.toString();
    }
}

