/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ColorProviderPropertiesComposite
extends Composite {
    private final List<PropertySelectionListener> propertySelectionListeners = new CopyOnWriteArrayList<PropertySelectionListener>();
    private String initialPropertyName;
    Combo propertiesCombo;
    List<ItemPropertyDescriptor> properties;
    ItemPropertyDescriptor selectedProperty;
    private PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (rvp != null) {
                rvp.setTarget((Notifier)dynamicLabel);
                for (Object element : rvp.getProperties()) {
                    ItemPropertyDescriptor property = (ItemPropertyDescriptor)element;
                    retValue.add(property);
                }
            }
            return retValue;
        }
    };

    public ColorProviderPropertiesComposite(Composite parent, int style) {
        super(parent, style);
        FormLayout retValueLayout = new FormLayout();
        this.setLayout((Layout)retValueLayout);
        this.propertiesCombo = new Combo((Composite)this, 0x100000C);
        FormData propertiesComboFormData = new FormData();
        propertiesComboFormData.top = new FormAttachment(0, 0);
        propertiesComboFormData.left = new FormAttachment(0, 0);
        propertiesComboFormData.right = new FormAttachment(100, 0);
        this.propertiesCombo.setLayoutData((Object)propertiesComboFormData);
        this.propertiesCombo.setEnabled(false);
        this.pack();
        this.propertiesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemPropertyDescriptor temp;
                if (!ColorProviderPropertiesComposite.this.properties.isEmpty() && ColorProviderPropertiesComposite.this.selectedProperty != (temp = ColorProviderPropertiesComposite.this.properties.get(ColorProviderPropertiesComposite.this.propertiesCombo.getSelectionIndex()))) {
                    ColorProviderPropertiesComposite.this.selectedProperty = temp;
                    ColorProviderPropertiesComposite.this.notifyPropertySelection(ColorProviderPropertiesComposite.this.selectedProperty);
                }
            }
        });
    }

    void notifyPropertySelection(ItemPropertyDescriptor selectedProperty) {
        if (selectedProperty != null) {
            this.firePropertySelectionEvent(new PropertySelectionEvent(selectedProperty, (Object)this));
        }
    }

    List<ItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator, String populationIdentifier) {
        ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            if (decorator instanceof DiseaseModel) {
                retValue.addAll(this.propertySieve.sieve((DynamicLabel)((DiseaseModel)decorator).createDiseaseModelLabel(populationIdentifier)));
            } else {
                retValue.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
            }
        }
        return retValue;
    }

    public ItemPropertyDescriptor getDefaultSelectedProperty() {
        for (ItemPropertyDescriptor property : this.properties) {
            if (!property.getDisplayName((Object)property).equals(this.initialPropertyName)) continue;
            return property;
        }
        if (!this.properties.isEmpty()) {
            return this.properties.get(0);
        }
        return null;
    }

    public void initialize(Decorator decorator, String populationIdentifier) {
        this.properties = this.getPropertiesToDisplay(decorator, populationIdentifier);
        this.selectedProperty = this.getDefaultSelectedProperty();
        boolean comboIsEnabled = decorator != null;
        this.initializeCombo(this.propertiesCombo, this.getPropertyNames(this.properties), this.getPropertyIndex(this.selectedProperty, this.properties), comboIsEnabled);
        this.notifyPropertySelection(this.selectedProperty);
    }

    void initializeCombo(Combo combo, String[] names, int selectionIndex, boolean isEnabled) {
        combo.setItems(names);
        combo.select(selectionIndex);
        this.propertiesCombo.setEnabled(isEnabled);
    }

    String[] getPropertyNames(List<ItemPropertyDescriptor> properties) {
        ArrayList<String> retValue = new ArrayList<String>();
        if (properties != null) {
            for (ItemPropertyDescriptor property : properties) {
                retValue.add(property.getDisplayName((Object)property));
            }
        }
        return retValue.toArray(new String[0]);
    }

    int getPropertyIndex(ItemPropertyDescriptor selectedDecoratorProperty, List<ItemPropertyDescriptor> decoratorProperties) {
        if (selectedDecoratorProperty != null) {
            return decoratorProperties.indexOf(selectedDecoratorProperty);
        }
        return 0;
    }

    public void addPropertySelectionListener(PropertySelectionListener listener) {
        this.propertySelectionListeners.add(listener);
    }

    public void removePropertySelectionListener(PropertySelectionListener listener) {
        this.propertySelectionListeners.remove(listener);
    }

    private void firePropertySelectionEvent(PropertySelectionEvent pse) {
        for (PropertySelectionListener listener : this.propertySelectionListeners) {
            listener.propertySelected(pse);
        }
    }

    public void setPropertySieve(PropertySieve propertySieve) {
        this.propertySieve = propertySieve;
    }

    public String getInitialPropertyName() {
        return this.initialPropertyName;
    }

    public void setInitialPropertyName(String initialPropertyName) {
        this.initialPropertyName = initialPropertyName;
    }

    public ItemPropertyDescriptor getSelectedProperty() {
        return this.selectedProperty;
    }

    public static class PropertySelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private final transient ItemPropertyDescriptor property;

        public PropertySelectionEvent(ItemPropertyDescriptor property, Object source) {
            super(source);
            this.property = property;
        }

        public final ItemPropertyDescriptor getProperty() {
            return this.property;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.property == null ? "null" : this.property.getDisplayName((Object)this.property));
            return sb.toString();
        }
    }

    public static interface PropertySelectionListener {
        public void propertySelected(PropertySelectionEvent var1);
    }

    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

