/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem currentFocusItem;
    ToolItem[] tabItemList;
    ImageList imageList;
    boolean hasChildFocus;
    static Callback menuItemSelectedFunc;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.ToolBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((menuItemSelectedFunc = new Callback(clazz, "MenuItemSelectedProc", 2)).getAddress() == 0L) {
            SWT.error(3);
        }
    }

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        int orientation;
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int n = orientation = (style & 0x200) != 0 ? 1 : 0;
        if (OS.GTK_VERSION < OS.VERSION(2, 16, 0)) {
            OS.gtk_toolbar_set_orientation(this.handle, orientation);
        } else {
            OS.gtk_orientable_set_orientation(this.handle, orientation);
        }
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 0x800000) != 0) {
            byte[] swt_toolbar_flat = Converter.wcsToMbcs(null, "swt-toolbar-flat", true);
            OS.gtk_widget_set_name(this.handle, swt_toolbar_flat);
        }
        OS.gtk_toolbar_set_icon_size(this.handle, 3);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        OS.gtk_toolbar_set_show_arrow(this.handle, false);
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if ((this.style & 0x40) != 0) {
            OS.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return size;
    }

    Widget computeTabGroup() {
        int index;
        ToolItem[] items = this._getItems();
        if (this.tabItemList == null) {
            int i = 0;
            while (i < items.length && items[i].control == null) {
                ++i;
            }
            if (i == items.length) {
                return super.computeTabGroup();
            }
        }
        if ((index = this.indexOf(this.currentFocusItem)) == -1) {
            index = items.length - 1;
        }
        while (index >= 0) {
            ToolItem item = items[index];
            if (item.isTabGroup()) {
                return item;
            }
            --index;
        }
        return super.computeTabGroup();
    }

    Widget[] computeTabList() {
        ToolItem[] items = this._getItems();
        if (this.tabItemList == null) {
            int i = 0;
            while (i < items.length && items[i].control == null) {
                ++i;
            }
            if (i == items.length) {
                return super.computeTabList();
            }
        }
        Widget[] result = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return result;
        }
        ToolItem[] list = this.tabList != null ? this._getTabItemList() : items;
        int i = 0;
        while (i < list.length) {
            ToolItem child = list[i];
            Widget[] childList = child.computeTabList();
            if (childList.length != 0) {
                Widget[] newResult = new Widget[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        if (result.length == 0) {
            result = new Widget[]{this};
        }
        return result;
    }

    long eventHandle() {
        return this.fixedHandle;
    }

    long enterExitHandle() {
        return this.handle;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        ToolItem[] items = this.getItems();
        if (this.toolTipText == null) {
            int i = 0;
            while (i < items.length) {
                ToolItem item = items[i];
                if (item.toolTipText != null) {
                    item.setToolTipText(oldShell, null);
                    item.setToolTipText(newShell, item.toolTipText);
                }
                ++i;
            }
        }
    }

    boolean forceFocus(long focusHandle) {
        int dir = 0;
        if ((this.style & 0x8000000) != 0) {
            dir = 1;
        }
        long childHandle = this.handle;
        if (this.currentFocusItem != null) {
            childHandle = this.currentFocusItem.handle;
        }
        if (OS.gtk_widget_child_focus(childHandle, dir)) {
            return true;
        }
        return super.forceFocus(focusHandle);
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[index];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getBounds().contains(point)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return 0;
        }
        int itemCount = OS.g_list_length(list);
        OS.g_list_free(list);
        return itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return new ToolItem[0];
        }
        int count = OS.g_list_length(list);
        ToolItem[] items = new ToolItem[count];
        int index = 0;
        int i = 0;
        while (i < count) {
            long data = OS.g_list_nth_data(list, i);
            Widget widget = this.display.getWidget(data);
            if (widget != null) {
                items[index++] = (ToolItem)widget;
            }
            ++i;
        }
        OS.g_list_free(list);
        if (index != items.length) {
            ToolItem[] newItems = new ToolItem[index];
            System.arraycopy(items, 0, newItems, 0, index);
            items = newItems;
        }
        return items;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabItemList.length) {
            if (!this.tabItemList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] newList = new ToolItem[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabItemList.length) {
            if (!this.tabItemList[i2].isDisposed()) {
                newList[index++] = this.tabItemList[i2];
            }
            ++i2;
        }
        this.tabItemList = newList;
        return this.tabItemList;
    }

    long gtk_key_press_event(long widget, long eventPtr) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventKey.sizeof);
        switch (gdkEvent.keyval) {
            case 65364: {
                if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0) || this.currentFocusItem == null || (this.currentFocusItem.style & 4) == 0) break;
                Event event = new Event();
                event.detail = 4;
                long topHandle = this.currentFocusItem.topHandle();
                event.x = OS.GTK_WIDGET_X(topHandle);
                event.y = OS.GTK_WIDGET_Y(topHandle) + OS.GTK_WIDGET_HEIGHT(topHandle);
                if ((this.style & 0x8000000) != 0) {
                    event.x = this.getClientWidth() - OS.GTK_WIDGET_WIDTH(topHandle) - event.x;
                }
                this.currentFocusItem.sendSelectionEvent(13, event, false);
                return 1L;
            }
        }
        return result;
    }

    long gtk_focus(long widget, long directionType) {
        return 0L;
    }

    boolean hasFocus() {
        if (this.hasChildFocus) {
            return true;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (item == items[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static long MenuItemSelectedProc(long widget, long user_data) {
        Display display = Display.getCurrent();
        ToolItem item = (ToolItem)display.getWidget(user_data);
        if (item != null) {
            return item.getParent().menuItemSelected(widget, item);
        }
        return 0L;
    }

    long menuItemSelected(long widget, ToolItem item) {
        Event event = new Event();
        switch (item.style) {
            case 4: {
                event.detail = 4;
                event.x = OS.GTK_WIDGET_X(widget);
                if ((this.style & 0x8000000) != 0) {
                    event.x = this.getClientWidth() - OS.GTK_WIDGET_WIDTH(widget) - event.x;
                }
                event.y = OS.GTK_WIDGET_Y(widget) + OS.GTK_WIDGET_HEIGHT(widget);
                break;
            }
            case 16: {
                if ((this.style & 0x400000) != 0) break;
                item.selectRadio();
                break;
            }
            case 32: {
                boolean currentSelection = item.getSelection();
                item.setSelection(!currentSelection);
            }
        }
        item.sendSelectionEvent(13, event, false);
        return 0L;
    }

    boolean mnemonicHit(char key) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            long labelHandle = items[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            long labelHandle = items[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void relayout() {
        ToolItem[] items = this.getItems();
        boolean hasText = false;
        boolean hasImage = false;
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null) {
                item.resizeControl();
                hasText |= item.text != null && item.text.length() > 0;
                hasImage |= item.image != null;
            }
            ++i;
        }
        int type = 0;
        if (hasText && hasImage) {
            type = (this.style & 0x20000) != 0 ? 3 : 2;
        } else if (hasText) {
            type = 1;
        } else if (hasImage) {
            type = 0;
        }
        OS.gtk_toolbar_set_style(this.handle, type);
    }

    void releaseChildren(boolean destroy) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    void reskinChildren(int flags) {
        ToolItem[] items = this._getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                ToolItem item = items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        OS.gtk_toolbar_set_show_arrow(this.handle, false);
        int result = super.setBounds(x, y, width, height, move, resize);
        if ((result & 0x100) != 0) {
            this.relayout();
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return result;
    }

    void setFontDescription(long font) {
        super.setFontDescription(font);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setFontDescription(font);
            ++i;
        }
        this.relayout();
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setForegroundColor(color);
            ++i;
        }
    }

    void setOrientation(boolean create) {
        super.setOrientation(create);
        ToolItem[] items = this._getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setOrientation(create);
            ++i;
        }
    }

    void setTabItemList(ToolItem[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                ToolItem item = tabList[i];
                if (item == null) {
                    this.error(5);
                }
                if (item.isDisposed()) {
                    this.error(5);
                }
                if (item.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            ToolItem[] newList = new ToolItem[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabItemList = tabList;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        Shell shell = this._getShell();
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            String newString = string != null ? null : items[i].toolTipText;
            shell.setToolTipText(items[i].handle, newString);
            ++i;
        }
    }
}

