/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

public class LocationData
extends TextRegionWithLineInformation
implements ILocationData {
    private final URI path;
    private final String projectName;

    public LocationData(int offset, int length, int lineNumber, int endLineNumber, @Nullable URI path, @Nullable String projectName) {
        super(offset, length, lineNumber, endLineNumber);
        this.path = path;
        this.projectName = projectName;
    }

    public LocationData(@NonNull ITextRegionWithLineInformation region, @Nullable URI path, @Nullable String projectName) {
        this(region.getOffset(), region.getLength(), region.getLineNumber(), region.getEndLineNumber(), path, projectName);
    }

    @Nullable
    public URI getPath() {
        return this.path;
    }

    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.projectName == null ? 0 : this.projectName.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationData other = (LocationData)obj;
        if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
            return false;
        }
        return !(this.projectName == null ? other.projectName != null : !this.projectName.equals(other.projectName));
    }

    @NonNull
    public String toString() {
        return "LocationData [" + super.toString() + "][path=" + this.path + ", projectName=" + this.projectName + "]";
    }
}

