/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.live.internal;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tea.core.ui.live.internal.Activator;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationNode;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationStatusNode;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationTaskNode;

public class TreeLabelColumnProvider
extends ColumnLabelProvider {
    static final Image IMG_ACTIVE = Activator.imageDescriptorFromPlugin((String)"org.eclipse.tea.core.ui.live", (String)"resources/state_active.png").createImage();
    static final Image IMG_SKIP = Activator.imageDescriptorFromPlugin((String)"org.eclipse.tea.core.ui.live", (String)"resources/skip.png").createImage();
    private static final Image IMG_OK = Activator.imageDescriptorFromPlugin((String)"org.eclipse.tea.core.ui.live", (String)"resources/ok_st_obj.png").createImage();
    private static final Image IMG_ERROR = Activator.imageDescriptorFromPlugin((String)"org.eclipse.tea.core.ui.live", (String)"resources/error_obj.png").createImage();
    private static final Image IMG_WARN = Activator.imageDescriptorFromPlugin((String)"org.eclipse.tea.core.ui.live", (String)"resources/warning_obj.png").createImage();
    private static final Image IMG_INFO = Activator.imageDescriptorFromPlugin((String)"org.eclipse.tea.core.ui.live", (String)"resources/info_obj.png").createImage();

    public static Image getStatusImage(int severity) {
        switch (severity) {
            case 4: 
            case 8: {
                return IMG_ERROR;
            }
            case 2: {
                return IMG_WARN;
            }
            case 1: {
                return IMG_INFO;
            }
            case 0: {
                return IMG_OK;
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof VisualizationNode) {
            return ((VisualizationNode)element).getName();
        }
        if (element instanceof VisualizationStatusNode) {
            return ((VisualizationStatusNode)element).getLabel();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof VisualizationNode) {
            if (((VisualizationNode)element).isActive()) {
                return IMG_ACTIVE;
            }
            if (((VisualizationNode)element).isDone()) {
                if (element instanceof VisualizationTaskNode && ((VisualizationTaskNode)element).isSkipped()) {
                    return IMG_SKIP;
                }
                return TreeLabelColumnProvider.getStatusImage(((VisualizationNode)element).getStatus().getSeverity());
            }
        } else if (element instanceof VisualizationStatusNode) {
            return TreeLabelColumnProvider.getStatusImage(((VisualizationStatusNode)element).getServerity());
        }
        return null;
    }

    public String getToolTipText(Object element) {
        return this.getText(element);
    }
}

