/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.p2;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.eclipse.IBrandingAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;

public class TeaBrandingAdvice
implements IBrandingAdvice {
    private final IBrandingAdvice advice;

    public TeaBrandingAdvice(IBrandingAdvice advice) {
        this.advice = advice;
    }

    public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
        return this.advice.isApplicable(configSpec, includeDefault, id, version);
    }

    public String getOS() {
        return this.advice.getOS();
    }

    public String getExecutableName() {
        return this.advice.getExecutableName();
    }

    public String[] getIcons() {
        return TeaBrandingAdvice.fixIconPath(this.advice);
    }

    private static String[] fixIconPath(IBrandingAdvice advice) {
        String[] iconsArr = advice.getIcons();
        if (iconsArr == null || iconsArr.length == 0) {
            return null;
        }
        IProductDescriptor productFile = ((ProductFileAdvice)advice).getProductFile();
        File workspaceLocation = productFile.getLocation().getParentFile().getParentFile();
        IPath rootPath = Path.fromOSString((String)workspaceLocation.getAbsolutePath());
        int idx = iconsArr.length;
        while (--idx >= 0) {
            File iconFile = new File(iconsArr[idx]);
            if (iconFile.isFile()) continue;
            IPath iconPath = Path.fromOSString((String)iconFile.getPath());
            if (rootPath.isPrefixOf(iconPath)) {
                iconPath = iconPath.removeFirstSegments(rootPath.segmentCount() + 1).setDevice(null).makeRelative();
                IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(iconPath.segment(0));
                IResource iconRes = prj.findMember(iconPath.removeFirstSegments(1));
                iconPath = iconRes != null && iconRes.exists() ? iconRes.getLocation() : rootPath.append(iconPath);
            } else {
                iconPath = rootPath.append(iconPath.makeRelative());
            }
            iconFile = iconPath.toFile();
            if (!iconFile.isFile()) continue;
            iconsArr[idx] = iconFile.getAbsolutePath();
        }
        return iconsArr;
    }
}

