/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPreferenceInterpreter;
import org.eclipse.dltk.ruby.internal.ui.text.syntax.RubyBlocks;
import org.eclipse.dltk.ui.text.blocks.Balance;
import org.eclipse.dltk.ui.text.blocks.BlocksConfiguration;
import org.eclipse.dltk.ui.text.blocks.Instance;
import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.dltk.ui.text.util.IPartitionFilter;
import org.eclipse.dltk.ui.text.util.IRangeFilter;
import org.eclipse.dltk.ui.text.util.ITabPreferencesProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;

public class RubyIndenter {
    private static final int maxCharsAway = 100;
    private static final String CONTINUATION_DESIGNATOR = "\\";
    private static final String[] CLOSING_BRACES = new String[]{"}", "]", ")"};
    private static final String[] JAVADOC_NOINDENT_TAGS = new String[]{"=begin", "=end"};
    private static final IPartitionFilter DEFAULT_PARTITION_FILTER = new IPartitionFilter(){

        public boolean allowPartition(String partition) {
            return partition == "__dftl_partition_content_type";
        }
    };
    private final IMatchingPairIndentingStrategy previousMinusOneIndenter = new IMatchingPairIndentingStrategy(){

        public String getIndentForOpeningOne(IDocument d, int matchOffset) throws BadLocationException {
            int lineIndex = d.getLineOfOffset(matchOffset);
            int lineOffset = d.getLineOffset(lineIndex);
            String indent = AutoEditUtils.getLineIndent((IDocument)d, (int)lineIndex);
            int pos = matchOffset - lineOffset - indent.length();
            return String.valueOf(indent) + AutoEditUtils.getNSpaces((int)pos);
        }
    };
    private final IMatchingPairIndentingStrategy previousLineIndenter = new IMatchingPairIndentingStrategy(){

        public String getIndentForOpeningOne(IDocument d, int matchOffset) throws BadLocationException {
            int lineIndex = d.getLineOfOffset(matchOffset);
            return AutoEditUtils.getLineIndent((IDocument)d, (int)lineIndex);
        }
    };
    private final IMatchingPairIndentingStrategy[] braceIndentingStrategies = new IMatchingPairIndentingStrategy[]{this.previousLineIndenter, this.previousMinusOneIndenter, this.previousMinusOneIndenter};
    private final String fPartitioning;
    private final RubyPreferenceInterpreter prefs;

    public RubyIndenter(String partitioning, RubyPreferenceInterpreter prefs) {
        this.fPartitioning = partitioning;
        this.prefs = prefs;
    }

    private Balance calculateBalance(IDocument document, int startOffset, int length, BlocksConfiguration blocks, Balance.Listener listener) throws BadLocationException {
        return Balance.calculateBalance((IDocument)document, (int)startOffset, (int)length, (BlocksConfiguration)blocks, (IRangeFilter)new IRangeFilter(){

            public boolean allowRange(IDocument document, int start, int length) throws BadLocationException {
                return AutoEditUtils.rangeIsInsideDefaultPartition((IDocument)document, (int)start, (int)length, (String)RubyIndenter.this.fPartitioning);
            }
        }, (Balance.Listener)listener);
    }

    private Balance calculateLineBalance(IDocument document, int lineIndex, Balance nextLineBalance, BlocksConfiguration blocks, Balance.Listener listener, int rightLimit) throws BadLocationException {
        int lineStart = document.getLineOffset(lineIndex);
        int lineLength = document.getLineLength(lineIndex);
        if (rightLimit >= 0) {
            lineLength = rightLimit - lineStart;
        }
        Balance balance = this.calculateBalance(document, lineStart, lineLength, blocks, listener);
        if (nextLineBalance != null) {
            balance.addAll(nextLineBalance, listener);
        }
        return balance;
    }

    private int getMasterLineIndex(IDocument document, int lineIndex, Balance nextLineBalance, int lookbehindLimit, boolean acceptNearest, BlocksConfiguration blocks, int prevLineRightLimit) throws BadLocationException {
        if (lineIndex < 0) {
            return -1;
        }
        if ((lineIndex = AutoEditUtils.getLastNonEmptyLine((IDocument)document, (int)lineIndex, (String)"#")) < 0) {
            return -1;
        }
        Balance balance = this.calculateLineBalance(document, lineIndex, nextLineBalance, blocks, null, prevLineRightLimit);
        int result = -1;
        System.err.println();
        if (acceptNearest && (result = this.getSingleLineMasterIndex(document, lineIndex, balance)) != -1) {
            return result;
        }
        if (lookbehindLimit > 0) {
            result = this.getMasterLineIndex(document, lineIndex - 1, balance, lookbehindLimit - 1, true, blocks, -1);
        }
        if (!acceptNearest && result == -1) {
            result = this.getSingleLineMasterIndex(document, lineIndex, balance);
        }
        return result;
    }

    private int getSingleLineMasterIndex(IDocument document, int lineIndex, Balance balance) throws BadLocationException {
        String line = AutoEditUtils.getDocumentLine((IDocument)document, (int)lineIndex);
        if (line.endsWith(CONTINUATION_DESIGNATOR) || balance.isAnythingOpen()) {
            return lineIndex;
        }
        return -1;
    }

    private int findMatchBackward(IDocument document, int startLineIndex, String matchText, final int matchOffset, int lookbehindLimit, BlocksConfiguration blocks, int rightLimit) throws BadLocationException {
        if (startLineIndex < 0) {
            return -1;
        }
        Balance nextLineBalance = new Balance(blocks);
        Instance.JoinResult result0 = nextLineBalance.process(document, matchText, matchOffset, null);
        if (result0 == Instance.JoinResult.UNHANDLED) {
            return -1;
        }
        final int[] result = new int[]{-1};
        Balance.Listener listener = new Balance.Listener(){

            public void instanceMatched(Instance instance) {
                int beginningOffset = instance.getBeginningOffset();
                int middleOffset = instance.getMiddleOffset();
                int endingOffset = instance.getEndingOffset();
                if (endingOffset == matchOffset) {
                    if (middleOffset >= 0) {
                        result[0] = middleOffset;
                    } else if (beginningOffset >= 0) {
                        result[0] = beginningOffset;
                    }
                } else if (middleOffset == matchOffset && beginningOffset >= 0) {
                    result[0] = beginningOffset;
                }
            }
        };
        int lastLineIndexToTest = Math.max(0, startLineIndex - lookbehindLimit + 1);
        int lineIndex = startLineIndex;
        while (lineIndex >= lastLineIndexToTest) {
            nextLineBalance = this.calculateLineBalance(document, lineIndex, nextLineBalance, blocks, listener, rightLimit);
            if (result[0] >= 0) break;
            rightLimit = -1;
            --lineIndex;
        }
        return result[0];
    }

    public String calculateLineIndent(IDocument document, String line, int lineIndex, int lineOffset, String typedText, int prevLineRightLimit) throws BadLocationException {
        String result = this.calculateIndentByCurrentLineContent(document, line, lineIndex, lineOffset, prevLineRightLimit);
        if (result != null) {
            return result;
        }
        int masterLine = this.getMasterLineIndex(document, lineIndex - 1, null, 0, false, RubyBlocks.ALL_BLOCKS, prevLineRightLimit);
        if (masterLine >= 0) {
            String indent = AutoEditUtils.getLineIndent((IDocument)document, (int)masterLine);
            return String.valueOf(indent) + this.prefs.getIndent();
        }
        return null;
    }

    private String calculateIndentByCurrentLineContent(IDocument document, String line, int lineIndex, int lineOffset, int prevLineRightLimit) throws BadLocationException {
        int matchedOffset;
        if (!AutoEditUtils.rangeIsInsideDefaultPartition((IDocument)document, (int)lineOffset, (int)1, (String)this.fPartitioning)) {
            return null;
        }
        String lineIndent = AutoEditUtils.getLineIndent((String)line);
        String unindentedLine = line.substring(lineIndent.length());
        int braceIndex = TextUtilities.startsWith((String[])CLOSING_BRACES, (String)unindentedLine);
        if (braceIndex >= 0) {
            if (prevLineRightLimit > 0) {
                return this.handleClosingBrace(document, prevLineRightLimit - 1, braceIndex);
            }
            return this.handleClosingBrace(document, lineOffset, braceIndex);
        }
        if (TextUtilities.startsWith((String[])JAVADOC_NOINDENT_TAGS, (String)unindentedLine) != -1) {
            return "";
        }
        Pattern pattern = RubyBlocks.ALL_BLOCKS.getMiddleEndAlignedPattern();
        Matcher matcher = pattern.matcher(unindentedLine);
        if (matcher.find() && (matchedOffset = this.findMatchBackward(document, lineIndex - 1, matcher.group(), lineOffset, 1000, RubyBlocks.ALL_BLOCKS, prevLineRightLimit)) >= 0) {
            int matchLineIndex = document.getLineOfOffset(matchedOffset);
            return AutoEditUtils.getLineIndent((IDocument)document, (int)matchLineIndex);
        }
        return null;
    }

    private String handleClosingBrace(IDocument document, int lineOffset, int braceIndex) throws BadLocationException {
        char closing = CLOSING_BRACES[braceIndex].charAt(0);
        char opening = AutoEditUtils.getBracePair((char)closing);
        int matching = AutoEditUtils.findMatchingCharacter((IDocument)document, (int)lineOffset, (boolean)false, (String)this.fPartitioning, (char)opening, (char)closing, (IPartitionFilter)DEFAULT_PARTITION_FILTER, (int)100);
        return this.braceIndentingStrategies[braceIndex].getIndentForOpeningOne(document, matching);
    }

    public String calculateChangedLineIndent(IDocument document, int lineIndex, boolean newLine, int insertionOffset, DocumentCommand command) throws BadLocationException {
        int lineOffset;
        String line;
        String text;
        String string = text = command == null ? "" : command.text;
        if (newLine) {
            line = "";
            lineOffset = lineIndex == document.getNumberOfLines() ? document.getLength() : document.getLineOffset(lineIndex);
        } else {
            lineOffset = document.getLineOffset(lineIndex);
            int lineLength = document.getLineLength(lineIndex);
            line = document.get(lineOffset, lineLength);
            if (command != null && text != null && command.offset >= lineOffset && command.offset <= lineOffset + lineLength) {
                int relativeOffset = insertionOffset - lineOffset;
                int relativeRemovedLength = Math.min(command.length, lineLength - relativeOffset);
                line = String.valueOf(line.substring(0, relativeOffset)) + text + line.substring(relativeOffset + relativeRemovedLength);
            }
        }
        return this.calculateLineIndent(document, line, lineIndex, lineOffset, text, -1);
    }

    public String forciblyCalculateLineIndent(IDocument document, int lineIndex, int lineStart, String line, int prevLineRightLimit) throws BadLocationException {
        String resultIndent = this.calculateLineIndent(document, line, lineIndex, lineStart, "", prevLineRightLimit);
        if (resultIndent == null) {
            int previousCodeLine = AutoEditUtils.getLastNonEmptyLine((IDocument)document, (int)(lineIndex - 1), (String)"#");
            int indentAmount = previousCodeLine < 0 ? 0 : AutoEditUtils.getIndentVisualLength((ITabPreferencesProvider)this.prefs, (IDocument)document, (int)previousCodeLine);
            resultIndent = this.prefs.getIndentByVirtualSize(indentAmount);
        }
        return resultIndent;
    }

    public String forciblyCalculateLineIndent(IDocument document, int lineIndex) throws BadLocationException {
        int lineStart = document.getLineOffset(lineIndex);
        int lineLength = document.getLineLength(lineIndex);
        String line = document.get(lineStart, lineLength);
        return this.forciblyCalculateLineIndent(document, lineIndex, lineStart, line, -1);
    }

    public static interface IMatchingPairIndentingStrategy {
        public String getIndentForOpeningOne(IDocument var1, int var2) throws BadLocationException;
    }
}

