/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.task;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.compiler.task.TodoTask;

public class TodoTaskPreferences
implements ITodoTaskPreferences {
    public static final String CASE_SENSITIVE = "org.eclipse.dltk.coretasks.case_sensitive";
    public static final String TAGS = "org.eclipse.dltk.coretasks.tags";
    public static final String ENABLED = "org.eclipse.dltk.coretasks.enabled";
    private static final String TAG_SEPARATOR = ",";
    private static final String PRIORITY_SEPARATOR = ";";
    private final Preferences store;

    public static boolean isValidName(String newText) {
        return newText.indexOf(TAG_SEPARATOR.charAt(0)) < 0 && newText.indexOf(PRIORITY_SEPARATOR.charAt(0)) < 0;
    }

    public TodoTaskPreferences(Preferences store) {
        this.store = store;
    }

    protected String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }

    public boolean isEnabled() {
        return this.store.getBoolean(ENABLED);
    }

    public boolean isCaseSensitive() {
        return this.store.getBoolean(CASE_SENSITIVE);
    }

    public List getTaskTags() {
        String tags = this.store.getString(TAGS);
        String[] tagPairs = this.getTokens(tags, TAG_SEPARATOR);
        ArrayList<TodoTask> elements = new ArrayList<TodoTask>();
        int i = 0;
        while (i < tagPairs.length) {
            String[] values = this.getTokens(tagPairs[i], PRIORITY_SEPARATOR);
            TodoTask task = new TodoTask();
            task.name = values[0];
            task.priority = values.length == 2 ? values[1] : "NORMAL";
            elements.add(task);
            ++i;
        }
        return elements;
    }

    public void setTaskTags(List elements) {
        this.store.setValue(TAGS, TodoTaskPreferences.encodeTaskTags(elements));
    }

    private static String encodeTaskTags(List elements) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < elements.size()) {
            TodoTask task = (TodoTask)elements.get(i);
            if (i > 0) {
                sb.append(TAG_SEPARATOR);
            }
            sb.append(task.name);
            sb.append(PRIORITY_SEPARATOR);
            sb.append(task.priority);
            ++i;
        }
        String string = sb.toString();
        return string;
    }

    public static List getDefaultTags() {
        ArrayList<TodoTask> defaultTags = new ArrayList<TodoTask>();
        defaultTags.add(new TodoTask("TODO", "NORMAL"));
        defaultTags.add(new TodoTask("FIXME", "HIGH"));
        defaultTags.add(new TodoTask("XXX", "NORMAL"));
        return defaultTags;
    }

    public static void initializeDefaultValues(Preferences store) {
        store.setDefault(ENABLED, true);
        store.setDefault(CASE_SENSITIVE, true);
        store.setDefault(TAGS, TodoTaskPreferences.encodeTaskTags(TodoTaskPreferences.getDefaultTags()));
    }

    public String[] getTagNames() {
        List taskTags = this.getTaskTags();
        int size = taskTags.size();
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = ((TodoTask)taskTags.get((int)i)).name;
            ++i;
        }
        return result;
    }
}

