/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.XMLWriter;
import org.eclipse.dltk.internal.core.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserLibrary {
    private static final String CURRENT_VERSION = "1";
    private static final String TAG_VERSION = "version";
    private static final String TAG_USERLIBRARY = "userlibrary";
    private static final String TAG_PATH = "path";
    private static final String TAG_ARCHIVE = "archive";
    private static final String TAG_SYSTEMLIBRARY = "systemlibrary";
    private boolean isSystemLibrary;
    private IBuildpathEntry[] entries;

    public UserLibrary(IBuildpathEntry[] entries, boolean isSystemLibrary) {
        Assert.isNotNull((Object)entries);
        this.entries = entries;
        this.isSystemLibrary = isSystemLibrary;
    }

    public IBuildpathEntry[] getEntries() {
        return this.entries;
    }

    public boolean isSystemLibrary() {
        return this.isSystemLibrary;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            UserLibrary other = (UserLibrary)obj;
            if (this.entries.length == other.entries.length && this.isSystemLibrary == other.isSystemLibrary) {
                int i = 0;
                while (i < this.entries.length) {
                    if (!this.entries[i].equals(other.entries[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.isSystemLibrary) {
            ++hashCode;
        }
        int i = 0;
        while (i < this.entries.length) {
            hashCode = hashCode * 17 + this.entries.hashCode();
            ++i;
        }
        return hashCode;
    }

    public static String serialize(IBuildpathEntry[] entries, boolean isSystemLibrary) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, null, true);
        HashMap<String, String> library = new HashMap<String, String>();
        library.put(TAG_VERSION, String.valueOf(CURRENT_VERSION));
        library.put(TAG_SYSTEMLIBRARY, String.valueOf(isSystemLibrary));
        xmlWriter.printTag(TAG_USERLIBRARY, library, true, true, false);
        int i = 0;
        int length = entries.length;
        while (i < length) {
            BuildpathEntry cpEntry = (BuildpathEntry)entries[i];
            HashMap<String, String> archive = new HashMap<String, String>();
            archive.put(TAG_PATH, cpEntry.getPath().toString());
            boolean hasExtraAttributes = cpEntry.extraAttributes != null && cpEntry.extraAttributes.length != 0;
            boolean hasRestrictions = cpEntry.getAccessRuleSet() != null;
            xmlWriter.printTag(TAG_ARCHIVE, archive, true, true, !hasExtraAttributes && !hasRestrictions);
            if (hasExtraAttributes) {
                cpEntry.encodeExtraAttributes(xmlWriter, true, true);
            }
            if (hasRestrictions) {
                cpEntry.encodeAccessRules(xmlWriter, true, true);
            }
            if (hasExtraAttributes || hasRestrictions) {
                xmlWriter.endTag(TAG_ARCHIVE, true, true);
            }
            ++i;
        }
        xmlWriter.endTag(TAG_USERLIBRARY, true, true);
        writer.flush();
        writer.close();
        return s.toString("UTF8");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UserLibrary createFromString(Reader reader) throws IOException {
        Element cpElement;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(Messages.file_badFormat);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException(Messages.file_badFormat);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            reader.close();
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        reader.close();
        if (!cpElement.getNodeName().equalsIgnoreCase(TAG_USERLIBRARY)) {
            throw new IOException(Messages.file_badFormat);
        }
        boolean isSystem = Boolean.valueOf(cpElement.getAttribute(TAG_SYSTEMLIBRARY));
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        ArrayList<IBuildpathEntry> res = new ArrayList<IBuildpathEntry>(length);
        int i = 0;
        while (true) {
            Element element;
            if (i >= length) {
                IBuildpathEntry[] entries = res.toArray(new IBuildpathEntry[res.size()]);
                return new UserLibrary(entries, isSystem);
            }
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getNodeName().equals(TAG_ARCHIVE)) {
                String path = element.getAttribute(TAG_PATH);
                NodeList children = element.getElementsByTagName("*");
                boolean[] foundChildren = new boolean[children.getLength()];
                NodeList attributeList = BuildpathEntry.getChildAttributes("attributes", children, foundChildren);
                IBuildpathAttribute[] extraAttributes = BuildpathEntry.decodeExtraAttributes(attributeList);
                attributeList = BuildpathEntry.getChildAttributes("accessrules", children, foundChildren);
                IAccessRule[] accessRules = BuildpathEntry.decodeAccessRules(attributeList);
                IBuildpathEntry entry = DLTKCore.newLibraryEntry(Path.fromPortableString((String)path), accessRules, extraAttributes, false, true);
                res.add(entry);
            }
            ++i;
        }
    }

    public String toString() {
        if (this.entries == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        int length = this.entries.length;
        int i = 0;
        while (i < length) {
            buffer.append(String.valueOf(this.entries[i].toString()) + '\n');
            ++i;
        }
        return buffer.toString();
    }
}

