/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.internal.core.search.DLTKSearchScope;
import org.eclipse.dltk.internal.core.search.IndexQueryRequestor;

public abstract class InternalSearchPattern {
    public IModelElement focus;
    public int kind;

    public void acceptMatch(String relativePath, String containerPath, SearchPattern pattern, IndexQueryRequestor requestor, SearchParticipant participant, IDLTKSearchScope scope) {
        if (scope instanceof DLTKSearchScope) {
            DLTKSearchScope javaSearchScope = (DLTKSearchScope)scope;
            AccessRuleSet access = javaSearchScope.getAccessRuleSet(relativePath, containerPath);
            if (access != DLTKSearchScope.NOT_ENCLOSED) {
                String documentPath = this.documentPath(containerPath, relativePath);
                Path realPath = new Path(documentPath);
                if (!DLTKContentTypeManager.isValidFileNameForContentType(scope.getLanguageToolkit(), (IPath)realPath)) {
                    return;
                }
                if (!requestor.acceptIndexMatch(documentPath, pattern, participant, access)) {
                    throw new OperationCanceledException();
                }
            }
        } else {
            String documentPath = this.documentPath(containerPath, relativePath);
            if (scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, pattern, participant, null)) {
                throw new OperationCanceledException();
            }
        }
    }

    public SearchPattern currentPattern() {
        return (SearchPattern)this;
    }

    public String documentPath(String containerPath, String relativePath) {
        String separator = Util.isArchiveFileName(containerPath) ? "|" : "/";
        StringBuffer buffer = new StringBuffer(containerPath.length() + separator.length() + relativePath.length());
        buffer.append(containerPath);
        buffer.append(separator);
        buffer.append(relativePath);
        return buffer.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IDLTKSearchScope scope, IProgressMonitor monitor) throws IOException {
        if (participant.isSkipped(index)) {
            return;
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            index.startQuery();
            SearchPattern pattern = this.currentPattern();
            EntryResult[] entries = pattern.queryIn(index);
            if (entries == null) {
                Object var16_8 = null;
                index.stopQuery();
                return;
            }
            SearchPattern decodedResult = pattern.getBlankPattern();
            String containerPath = index.containerPath;
            int i = 0;
            int l = entries.length;
            while (i < l) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EntryResult entry = entries[i];
                decodedResult.decodeIndexKey(entry.getWord());
                if (pattern.matchesDecodedKey(decodedResult)) {
                    String[] names = entry.getDocumentNames(index);
                    int j = 0;
                    int n = names.length;
                    while (j < n) {
                        this.acceptMatch(names[j], containerPath, decodedResult, requestor, participant, scope);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var16_9 = null;
            index.stopQuery();
            throw throwable;
        }
        {
            Object var16_10 = null;
            index.stopQuery();
            return;
        }
    }

    public boolean isPolymorphicSearch() {
        return false;
    }

    public EntryResult[] queryIn(Index index) throws IOException {
        SearchPattern pattern = (SearchPattern)this;
        return index.query(pattern.getIndexCategories(), pattern.getIndexKey(), pattern.getMatchRule());
    }
}

