/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.util.ArrayList;

public abstract class TextUtils {
    private TextUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static String Pattern_quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuffer sb = new StringBuffer(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    public static String[] splitLines(String content) {
        if (content == null) {
            return null;
        }
        LineSplitter splitter = new LineSplitter(content);
        return splitter.split();
    }

    private static class LineSplitter {
        private final String content;
        private final int contentEnd;
        private int contentPos;

        public LineSplitter(String content) {
            this.content = content;
            this.contentEnd = content.length();
        }

        public String[] split() {
            ArrayList<String> result = new ArrayList<String>();
            this.contentPos = 0;
            while (this.contentPos < this.contentEnd) {
                int begin = this.contentPos;
                int end = this.findEndOfLine();
                result.add(this.content.substring(begin, end));
            }
            return result.toArray(new String[result.size()]);
        }

        private int findEndOfLine() {
            while (this.contentPos < this.contentEnd) {
                if (this.content.charAt(this.contentPos) == '\r') {
                    int endLine = this.contentPos++;
                    if (this.contentPos < this.contentEnd && this.content.charAt(this.contentPos) == '\n') {
                        ++this.contentPos;
                    }
                    return endLine;
                }
                if (this.content.charAt(this.contentPos) == '\n') {
                    int endLine = this.contentPos++;
                    return endLine;
                }
                ++this.contentPos;
            }
            return this.contentPos;
        }
    }
}

