/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.Highlighting;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlighting;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingReconciler;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.IColorManagerExtension;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.ITextEditor;

public class SemanticHighlightingManager
implements IPropertyChangeListener {
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlightingReconciler fReconciler;
    private SemanticHighlighting[] fSemanticHighlightings;
    private Highlighting[] fHighlightings;
    private ScriptEditor fEditor;
    private ScriptSourceViewer fSourceViewer;
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private ScriptSourceViewerConfiguration fConfiguration;
    private ScriptPresentationReconciler fPresentationReconciler;
    private HighlightedRange[][] fHardcodedRanges;

    public void install(ScriptEditor editor, ScriptSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore) {
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        if (this.fEditor != null) {
            ScriptTextTools textTools = editor.getTextTools();
            if (textTools != null) {
                this.fConfiguration = textTools.createSourceViewerConfiguraton(preferenceStore, (ITextEditor)editor);
                IPresentationReconciler presReconciler = this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
                this.fPresentationReconciler = presReconciler instanceof ScriptPresentationReconciler ? (ScriptPresentationReconciler)presReconciler : null;
            } else {
                this.fConfiguration = null;
                this.fPresentationReconciler = null;
            }
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    public void install(ScriptSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore, HighlightedRange[][] hardcodedRanges) {
        this.fHardcodedRanges = hardcodedRanges;
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    private void enable() {
        this.initializeHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fEditor != null) {
            this.fReconciler = new SemanticHighlightingReconciler();
            this.fReconciler.install(this.fEditor, (ISourceViewer)this.fSourceViewer, this.fPresenter, this.fSemanticHighlightings, this.fHighlightings);
        } else {
            this.fPresenter.updatePresentation(null, this.createHardcodedPositions(), new HighlightedPosition[0]);
        }
    }

    private HighlightedPosition[] createHardcodedPositions() {
        ArrayList<HighlightedPosition> positions = new ArrayList<HighlightedPosition>();
        int i = 0;
        while (i < this.fHardcodedRanges.length) {
            HighlightedRange range = null;
            Highlighting hl = null;
            int j = 0;
            while (j < this.fHardcodedRanges[i].length) {
                hl = this.getHighlighting(this.fHardcodedRanges[i][j].getKey());
                if (hl.isEnabled()) {
                    range = this.fHardcodedRanges[i][j];
                    break;
                }
                ++j;
            }
            if (range != null) {
                positions.add(this.fPresenter.createHighlightedPosition(range.getOffset(), range.getLength(), hl));
            }
            ++i;
        }
        return positions.toArray(new HighlightedPosition[positions.size()]);
    }

    private Highlighting getHighlighting(String key) {
        int i = 0;
        while (i < this.fSemanticHighlightings.length) {
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            if (key.equals(semanticHighlighting.getPreferenceKey())) {
                return this.fHighlightings[i];
            }
            ++i;
        }
        return null;
    }

    public Highlighting getHighlighting(int pos) {
        return this.fHighlightings[pos];
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fColorManager = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
        this.fHardcodedRanges = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
        if (this.fSemanticHighlightings != null) {
            this.disposeHighlightings();
        }
    }

    private boolean isEnabled() {
        return true;
    }

    private TextAttribute createTextAttribute(IColorManager manager, IPreferenceStore ps, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, String bgKey) {
        int style;
        this.addColor(colorKey);
        if (bgKey != null) {
            this.addColor(bgKey);
        }
        Color color = null;
        Color bgcolor = null;
        if (colorKey != null) {
            color = manager.getColor(colorKey);
        }
        if (bgKey != null) {
            bgcolor = manager.getColor(bgKey);
        }
        int n = style = ps.getBoolean(boldKey) ? 1 : 0;
        if (ps.getBoolean(italicKey)) {
            style |= 2;
        }
        if (ps.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (ps.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(color, bgcolor, style);
    }

    private TextAttribute createTextAttribute(IColorManager manager, IPreferenceStore ps, String colorKey, String bgKey) {
        return this.createTextAttribute(manager, ps, colorKey, String.valueOf(colorKey) + "_bold", String.valueOf(colorKey) + "_italic", String.valueOf(colorKey) + "_strikethrough", String.valueOf(colorKey) + "_underline", bgKey);
    }

    private void initializeHighlightings() {
        ScriptTextTools textTools = this.fEditor.getTextTools();
        if (textTools != null) {
            this.fSemanticHighlightings = textTools.getSemanticHighlightings();
            this.fHighlightings = new Highlighting[this.fSemanticHighlightings.length];
            int a = 0;
            while (a < this.fSemanticHighlightings.length) {
                this.fHighlightings[a] = new Highlighting(this.createTextAttribute(this.fColorManager, this.fPreferenceStore, this.fSemanticHighlightings[a].getPreferenceKey(), this.fSemanticHighlightings[a].getBackgroundPreferenceKey()), true, this.fSemanticHighlightings[a]);
                ++a;
            }
        }
    }

    private void disposeHighlightings() {
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            this.removeColor(this.fSemanticHighlightings[i].getPreferenceKey());
            ++i;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePropertyChangeEvent(event);
    }

    private void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPreferenceStore == null) {
            return;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration.handlePropertyChangeEvent(event);
        }
        if (!this.isEnabled()) {
            return;
        }
        boolean refreshNeeded = false;
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            String preferenceKey = semanticHighlighting.getPreferenceKey();
            if (preferenceKey != null && preferenceKey.equals(event.getProperty())) {
                this.adaptToTextForegroundChange(this.fHighlightings[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                refreshNeeded = true;
            } else {
                String bpreferenceKey = semanticHighlighting.getBackgroundPreferenceKey();
                if (bpreferenceKey != null && bpreferenceKey.equals(event.getProperty())) {
                    this.adaptToTextBackgroundChange(this.fHighlightings[i], event);
                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                    refreshNeeded = true;
                } else {
                    String boldKey = String.valueOf(preferenceKey) + "_bold";
                    if (boldKey.equals(event.getProperty())) {
                        this.adaptToTextStyleChange(this.fHighlightings[i], event, 1);
                        this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                        refreshNeeded = true;
                    } else {
                        String italicKey = String.valueOf(preferenceKey) + "_italic";
                        if (italicKey.equals(event.getProperty())) {
                            this.adaptToTextStyleChange(this.fHighlightings[i], event, 2);
                            this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                            refreshNeeded = true;
                        } else {
                            String strikethroughKey = String.valueOf(preferenceKey) + "_strikethrough";
                            if (strikethroughKey.equals(event.getProperty())) {
                                this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x20000000);
                                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                refreshNeeded = true;
                            } else {
                                String underlineKey = String.valueOf(preferenceKey) + "_underline";
                                if (underlineKey.equals(event.getProperty())) {
                                    this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x40000000);
                                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                    refreshNeeded = true;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (refreshNeeded && this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    private void adaptToTextBackgroundChange(Highlighting highlighting, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if ((color == null || !rgb.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), color, oldAttr.getStyle()));
        }
    }

    private void adaptToEnablementChange(Highlighting highlighting, PropertyChangeEvent event) {
        Object value = event.getNewValue();
        boolean eventValue = value instanceof Boolean ? (Boolean)value : "true".equals(value);
        highlighting.setEnabled(eventValue);
    }

    private void adaptToTextForegroundChange(Highlighting highlighting, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if ((color == null || !rgb.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToTextStyleChange(Highlighting highlighting, PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute oldAttr = highlighting.getTextAttribute();
        boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
        }
    }

    private void addColor(String colorKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(colorKey);
                ext.bindColor(colorKey, rgb);
            }
        }
    }

    private void removeColor(String colorKey) {
        if (this.fColorManager instanceof IColorManagerExtension) {
            ((IColorManagerExtension)((Object)this.fColorManager)).unbindColor(colorKey);
        }
    }

    public SemanticHighlightingReconciler getReconciler() {
        return this.fReconciler;
    }

    public static class HighlightedPosition
    extends Position {
        private Highlighting fStyle;
        private Object fLock;

        public HighlightedPosition(int offset, int length, Highlighting highlighting, Object lock) {
            super(offset, length);
            this.fStyle = highlighting;
            this.fLock = lock;
        }

        public StyleRange createStyleRange() {
            int len = 0;
            if (this.fStyle.isEnabled()) {
                len = this.getLength();
            }
            TextAttribute textAttribute = this.fStyle.getTextAttribute();
            int style = textAttribute.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            return styleRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(int off, int len, Highlighting highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContained(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(off);
                super.setLength(len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int length) {
            Object object = this.fLock;
            synchronized (object) {
                super.setLength(length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int offset) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Object object = this.fLock;
            synchronized (object) {
                super.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undelete() {
            Object object = this.fLock;
            synchronized (object) {
                super.undelete();
            }
        }

        public Highlighting getHighlighting() {
            return this.fStyle;
        }

        public boolean equals(Object other) {
            return this == other;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("HLPos[");
            sb.append(this.offset);
            sb.append("+");
            sb.append(this.length);
            sb.append(":");
            sb.append(this.fStyle.getSemaHighlighting().getPreferenceKey());
            sb.append("]");
            return sb.toString();
        }
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int offset, int length, String key) {
            super(offset, length);
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)o)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }
}

