/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor.semantic.highlighting;

import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.Highlighting;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.PositionUpdater;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticUpdateWorker;

public abstract class SemanticPositionUpdater
extends PositionUpdater {
    public PositionUpdater.UpdateResult reconcile(ISourceModule sourceModule, SemanticHighlightingPresenter presenter, Highlighting[] highlightings, List currentPositions) {
        try {
            ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
            if (module != null) {
                SemanticUpdateWorker worker = this.createWorker(sourceModule);
                worker.setPresenter(presenter);
                worker.setHighlightings(highlightings);
                worker.setOldPositions(currentPositions);
                module.traverse((ASTVisitor)worker);
                worker.checkNewPositionOrdering();
                return new PositionUpdater.UpdateResult(worker.getNewPositions(), worker.getOldPositions());
            }
        }
        catch (Exception e) {
            DLTKCore.error((String)"Error in SemanticPositionUpdater", (Throwable)e);
        }
        return new PositionUpdater.UpdateResult(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    protected abstract SemanticUpdateWorker createWorker(ISourceModule var1) throws ModelException;
}

