/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.debug.ui.console;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ruby.core.RubyLanguageToolkit;
import org.eclipse.dltk.ruby.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.dltk.ruby.internal.debug.ui.console.RubyConsoleSourceModuleLookup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;

public class RubyFileHyperlink
implements IHyperlink {
    private static final String ERROR_UNKNOWN_HYPERLINK = "Unknown hyperlink";
    private static final String ERROR_NO_COLON_IN_LINK = "No ':' in link";
    static final boolean DEBUG = false;
    private final TextConsole fConsole;

    public RubyFileHyperlink(TextConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        int lineNumber;
        String fileName;
        try {
            String linkText = this.getLinkText();
            fileName = RubyFileHyperlink.extractFileName(linkText);
            lineNumber = RubyFileHyperlink.extractLineNumber(linkText);
        }
        catch (IllegalArgumentException e) {
            DLTKDebugPlugin.log((Throwable)e);
            return;
        }
        if (lineNumber > 0) {
            --lineNumber;
        }
        try {
            Object element = RubyFileHyperlink.findSourceModule(fileName);
            if (element == null) {
                MessageDialog.openInformation((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.RubyFileHyperlink_Information_1, (String)MessageFormat.format(ConsoleMessages.RubyFileHyperlink_Source_not_found_for__0__2, fileName));
                return;
            }
            IEditorInput input = EditorUtility.getEditorInput((Object)element);
            if (input == null) {
                return;
            }
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            IWorkbenchPage page = DLTKDebugUIPlugin.getActivePage();
            IEditorPart editor = page.openEditor(input, descriptor.getId());
            EditorUtility.revealInEditor((IEditorPart)editor, (int)lineNumber);
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.errorDialog((String)ConsoleMessages.RubyFileHyperlink_An_exception_occurred_while_following_link__3, (Throwable)e);
        }
    }

    public static Object findSourceModule(String fileName) {
        IPath path = Path.fromOSString((String)fileName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile f = root.getFileForLocation(path);
        if (f != null) {
            return f;
        }
        IDLTKLanguageToolkit toolkit = RubyLanguageToolkit.getDefault();
        RubyConsoleSourceModuleLookup lookup = new RubyConsoleSourceModuleLookup(toolkit);
        return lookup.findSourceModuleByLocalPath(path);
    }

    static String extractFileName(String linkText) throws IllegalArgumentException {
        int pos = linkText.lastIndexOf(58);
        if (pos > 0 && pos < linkText.length() - 1) {
            return RubyFileHyperlink.normalizePath(linkText.substring(0, pos));
        }
        throw new IllegalArgumentException(ERROR_NO_COLON_IN_LINK);
    }

    private static String normalizePath(String filePath) {
        try {
            File file = new File(filePath);
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return filePath;
        }
    }

    static int extractLineNumber(String linkText) throws IllegalArgumentException {
        int pos = linkText.lastIndexOf(58);
        if (pos > 0 && pos < linkText.length() - 1) {
            return Integer.parseInt(linkText.substring(pos + 1));
        }
        throw new IllegalArgumentException(ERROR_NO_COLON_IN_LINK);
    }

    protected String getLinkText() throws IllegalArgumentException {
        IRegion region = this.fConsole.getRegion((IHyperlink)this);
        if (region == null) {
            throw new IllegalArgumentException(ERROR_UNKNOWN_HYPERLINK);
        }
        return this.getText(region.getOffset(), region.getLength());
    }

    protected String getText(int offset, int length) throws IllegalArgumentException {
        try {
            return this.fConsole.getDocument().get(offset, length);
        }
        catch (BadLocationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

