/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui;

import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.dltk.MylynStatusHandler;
import org.eclipse.mylyn.monitor.ui.AbstractUserInteractionMonitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class DLTKEditingMonitor
extends AbstractUserInteractionMonitor {
    protected IModelElement lastSelectedElement = null;
    protected IModelElement lastResolvedElement = null;
    protected ScriptEditor currentEditor;
    protected StructuredSelection currentSelection = null;

    public void handleWorkbenchPartSelection(IWorkbenchPart part, ISelection selection, boolean contributeToContext) {
        try {
            IModelElement selectedElement = null;
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                if (structuredSelection.equals((Object)this.currentSelection)) {
                    return;
                }
                this.currentSelection = structuredSelection;
                Object selectedObject = structuredSelection.getFirstElement();
                if (selectedObject instanceof IModelElement) {
                    IModelElement checkedElement = this.checkIfAcceptedAndPromoteIfNecessary((IModelElement)selectedObject);
                    if (checkedElement == null) {
                        return;
                    }
                    selectedElement = checkedElement;
                }
                if (selectedElement != null) {
                    super.handleElementSelection(part, (Object)selectedElement, contributeToContext);
                }
            } else if (selection instanceof TextSelection && part instanceof ScriptEditor) {
                IModelElement checkedElement;
                this.currentEditor = (ScriptEditor)part;
                TextSelection textSelection = (TextSelection)selection;
                selectedElement = SelectionConverter.resolveEnclosingElement((IEditorPart)this.currentEditor, (ITextSelection)textSelection);
                if (selectedElement instanceof IPackageDeclaration) {
                    return;
                }
                IModelElement[] resolved = SelectionConverter.codeResolve((IEditorPart)this.currentEditor);
                if (resolved != null && resolved.length == 1 && !resolved[0].equals(selectedElement)) {
                    this.lastResolvedElement = resolved[0];
                }
                boolean selectionResolved = false;
                if (selectedElement instanceof IMethod && this.lastSelectedElement instanceof IMethod) {
                    if (this.lastResolvedElement != null && this.lastSelectedElement != null && this.lastResolvedElement.equals(selectedElement) && !this.lastSelectedElement.equals(this.lastResolvedElement)) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.dltk.mylyn.relation.references", contributeToContext);
                        selectionResolved = true;
                    } else if (this.lastSelectedElement != null && this.lastSelectedElement.equals(this.lastResolvedElement) && !this.lastSelectedElement.equals(selectedElement)) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.dltk.mylyn.relation.references", contributeToContext);
                        selectionResolved = true;
                    }
                } else if (selectedElement != null && this.lastSelectedElement != null && !this.lastSelectedElement.equals(selectedElement) && this.lastSelectedElement.getElementName().equals(selectedElement.getElementName())) {
                    if (selectedElement instanceof IMethod && this.lastSelectedElement instanceof IMethod) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.dltk.mylyn.relation.implementors", contributeToContext);
                        selectionResolved = true;
                    } else if (selectedElement instanceof IType && this.lastSelectedElement instanceof IType) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.dltk.mylyn.relation.implementors", contributeToContext);
                        selectionResolved = true;
                    }
                }
                if (selectedElement != null) {
                    if (!selectionResolved && selectedElement.equals(this.lastSelectedElement)) {
                        super.handleElementEdit(part, (Object)selectedElement, contributeToContext);
                    } else if (!selectedElement.equals(this.lastSelectedElement)) {
                        super.handleElementSelection(part, (Object)selectedElement, contributeToContext);
                    }
                }
                if ((checkedElement = this.checkIfAcceptedAndPromoteIfNecessary(selectedElement)) == null) {
                    return;
                }
                selectedElement = checkedElement;
            }
            if (selectedElement != null) {
                this.lastSelectedElement = selectedElement;
            }
        }
        catch (ModelException modelException) {
        }
        catch (Throwable t) {
            MylynStatusHandler.log(t, "Failed to update model based on selection.");
        }
    }

    protected IModelElement checkIfAcceptedAndPromoteIfNecessary(IModelElement element) {
        return element;
    }
}

