/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracesConfiguration;

public abstract class AbstractBracesConfiguration
implements IBracesConfiguration {
    private IFormatterDocument document;
    protected String indentingSettingName;
    protected String bracesSettingName;
    protected String keepSameLineSettingName;
    protected String newLineSettingName;

    public AbstractBracesConfiguration(IFormatterDocument document) {
        this.document = document;
    }

    protected IFormatterDocument getDocument() {
        return this.document;
    }

    public boolean isIndenting() {
        if (this.indentingSettingName != null && this.indentingSettingName.length() > 0) {
            return this.document.getBoolean(this.indentingSettingName);
        }
        return false;
    }

    public boolean isBracesIndenting() {
        if (this.bracesSettingName != null && this.bracesSettingName.length() > 0) {
            return "next.line.indented".equals(this.document.getString(this.bracesSettingName));
        }
        return false;
    }

    public boolean isStatementContinuation() {
        return true;
    }

    public int insertBeforeOpenBrace() {
        if (this.bracesSettingName != null && this.bracesSettingName.length() != 0) {
            String value = this.document.getString(this.bracesSettingName);
            return "next.line.indented".equals(value) || "next.line".equals(value) ? 2 : 1;
        }
        return 0;
    }

    public int insertAfterOpenBrace() {
        return 2;
    }

    public int insertBeforeCloseBrace() {
        return 2;
    }

    public int insertAfterCloseBrace() {
        if (this.keepSameLineSettingName != null && this.keepSameLineSettingName.length() > 0) {
            return this.document.getBoolean(this.keepSameLineSettingName) ? 0 : 2;
        }
        if (this.newLineSettingName != null && this.newLineSettingName.length() > 0) {
            return this.document.getBoolean(this.newLineSettingName) ? 2 : 0;
        }
        return 0;
    }
}

