/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.builder;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.IScriptProject;

public interface IScriptBuilder {
    public static final int INCREMENTAL_BUILD = 0;
    public static final int FULL_BUILD = 1;

    public void initialize(IScriptProject var1);

    public IStatus buildResources(IScriptProject var1, List var2, IProgressMonitor var3, int var4);

    public IStatus buildModelElements(IScriptProject var1, List var2, IProgressMonitor var3, int var4);

    public DependencyResponse getDependencies(IScriptProject var1, int var2, Set var3, Set var4, Set var5, Set var6);

    public void clean(IScriptProject var1, IProgressMonitor var2);

    public void endBuild(IScriptProject var1, IProgressMonitor var2);

    public static class DependencyResponse {
        public static final DependencyResponse FULL_LOCAL_BUILD = new DependencyResponse(){

            public boolean isFullLocalBuild() {
                return true;
            }
        };
        public static final DependencyResponse FULL_EXTERNAL_BUILD = new DependencyResponse(){

            public boolean isFullLocalBuild() {
                return true;
            }

            public boolean isFullExternalBuild() {
                return true;
            }
        };

        public boolean isFullLocalBuild() {
            return false;
        }

        public boolean isFullExternalBuild() {
            return false;
        }

        public Set getLocalDependencies() {
            return Collections.EMPTY_SET;
        }

        public Set getExternalDependencies() {
            return Collections.EMPTY_SET;
        }

        public static DependencyResponse createLocal(final Set localDependencies) {
            return new DependencyResponse(){

                public Set getLocalDependencies() {
                    return localDependencies;
                }
            };
        }

        public static DependencyResponse create(final boolean fullLocal, final Set localDependencies, final Set externalDependencies) {
            return new DependencyResponse(){

                public boolean isFullLocalBuild() {
                    return fullLocal;
                }

                public Set getLocalDependencies() {
                    return !fullLocal && localDependencies != null ? localDependencies : Collections.EMPTY_SET;
                }

                public Set getExternalDependencies() {
                    return externalDependencies != null ? externalDependencies : Collections.EMPTY_SET;
                }
            };
        }
    }
}

