/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.core.IndexRequest;

class SourceModulesRequest
extends IndexRequest {
    private final IScriptProject project;
    private final IDLTKLanguageToolkit toolkit;
    private final Set modules;

    public SourceModulesRequest(IProjectIndexer indexer, IScriptProject project, IDLTKLanguageToolkit toolkit, Set modules) {
        super(indexer);
        this.project = project;
        this.toolkit = toolkit;
        this.modules = modules;
    }

    protected String getName() {
        return this.project.getElementName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void run() throws CoreException, IOException {
        Index index = this.getIndexer().getProjectIndex(this.project);
        if (index == null) {
            DLTKCore.error("Index are null for:" + this.modules);
            return;
        }
        IPath containerPath = this.project.getPath();
        List changes = this.checkChanges(index, this.modules, containerPath, EnvironmentManager.getEnvironment(this.project));
        if (changes.isEmpty()) {
            return;
        }
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            try {
                Iterator i = changes.iterator();
                while (!this.isCancelled) {
                    if (!i.hasNext()) {
                        return;
                    }
                    Object change = i.next();
                    if (change instanceof String) {
                        index.remove((String)change);
                        continue;
                    }
                    this.getIndexer().indexSourceModule(index, this.toolkit, (ISourceModule)change, containerPath);
                }
                return;
            }
            catch (Throwable t) {
                if (DLTKCore.DEBUG) {
                    t.printStackTrace();
                }
                try {
                    try {
                        index.save();
                        return;
                    }
                    catch (IOException e) {
                        DLTKCore.error("error saving index", e);
                        imon.exitWrite();
                        return;
                    }
                }
                finally {
                    imon.exitWrite();
                }
            }
        }
        finally {
            block25: {
                try {
                    try {
                        index.save();
                    }
                    catch (IOException e) {
                        DLTKCore.error("error saving index", e);
                        imon.exitWrite();
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    imon.exitWrite();
                    throw throwable;
                }
                imon.exitWrite();
            }
        }
    }

    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.project.getProject().getName());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.modules == null ? 0 : this.modules.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceModulesRequest other = (SourceModulesRequest)obj;
        if (this.modules == null ? other.modules != null : !this.modules.equals(other.modules)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }
}

