/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.TclUpvarVariableDeclaration;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclVisibilityUtils;

public class TclUpvarProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        int statementsCount = statement.getCount();
        if (statementsCount < 2) {
            this.report(parser, "Syntax error: at least one argument expected.", (ASTNode)statement, 1);
            return null;
        }
        Expression level = statement.getAt(1);
        int startIndex = 1;
        if (level instanceof SimpleReference) {
            SimpleReference sLevel = (SimpleReference)level;
            String str = sLevel.getName();
            if (str == null || str.length() == 0) {
                this.report(parser, "Parsing error: a level specifier assumed.", (ASTNode)sLevel, 1);
                return null;
            }
            if (str.startsWith("#") || str.startsWith("\\#") || Character.isDigit(str.charAt(0))) {
                ++startIndex;
            }
        }
        Expression variableName = null;
        TclUpvarVariableDeclaration ret = null;
        int i = startIndex;
        while (i < statementsCount) {
            Expression at = statement.getAt(i + 1);
            variableName = at;
            if (variableName == null) {
                return null;
            }
            SimpleReference variable = TclParseUtil.makeVariable(variableName);
            TclUpvarVariableDeclaration var = new TclUpvarVariableDeclaration(variable, null, at.sourceStart(), at.sourceEnd());
            if (TclVisibilityUtils.isPrivate(variable.getName())) {
                var.setModifier(32);
            } else {
                var.setModifier(128);
            }
            var.setModifier(32768);
            if (ret == null) {
                ret = var;
            } else {
                if (!(ret instanceof ASTListNode)) {
                    ASTListNode list = new ASTListNode();
                    list.addNode((ASTNode)ret);
                    list.setStart(ret.sourceStart());
                    list.setEnd(ret.sourceEnd());
                    ret = list;
                }
                ((ASTListNode)ret).addNode((ASTNode)var);
                ((ASTListNode)ret).setEnd(var.sourceEnd());
            }
            i += 2;
        }
        if (ret != null) {
            this.addToParent(parent, (ASTNode)ret);
        }
        return ret;
    }
}

