/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.sources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ExternalEntryFile;
import org.eclipse.dltk.internal.core.MementoModelElementUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ScriptFolderInfo;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesSourceModule;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesUtils;
import org.eclipse.dltk.utils.CorePrinter;

public class TclSourcesElement
extends Openable
implements IScriptFolder {
    private String name = "Sourced files@" + this.getScriptProject().getElementName();

    protected TclSourcesElement(ModelElement parent) {
        super(parent);
    }

    public String getElementName() {
        return this.name;
    }

    protected Object createElementInfo() {
        return new OpenableElementInfo();
    }

    public int getElementType() {
        return 4;
    }

    public int getKind() throws ModelException {
        return 1;
    }

    public IResource getResource() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TclSourcesElement other = (TclSourcesElement)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        IScriptProject scriptProject;
        IInterpreterInstall install;
        block5: {
            install = null;
            scriptProject = this.getScriptProject();
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)scriptProject);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (install != null) {
            HashSet<TclSourcesSourceModule> vChildren = new HashSet<TclSourcesSourceModule>();
            HashSet<IPath> sources = new HashSet<IPath>();
            HashMap<IPath, String> originalNames = new HashMap<IPath, String>();
            HashSet<String> pseudoElements = new HashSet<String>();
            TclSourcesUtils.fillSources(install, scriptProject, sources, originalNames, pseudoElements);
            if (!sources.isEmpty()) {
                IPath[] paths = sources.toArray(new IPath[sources.size()]);
                IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)scriptProject);
                int i = 0;
                while (i < paths.length) {
                    IPath path = paths[i];
                    ExternalEntryFile storage = new ExternalEntryFile(EnvironmentPathUtils.getFile((IEnvironment)environment, (IPath)path));
                    TclSourcesSourceModule module = new TclSourcesSourceModule((ModelElement)this, environment.convertPathToString(path).replace(environment.getSeparatorChar(), '_'), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, (IStorage)storage, (String)originalNames.get(path));
                    vChildren.add(module);
                    ++i;
                }
            }
            info.setChildren(vChildren.toArray(new IModelElement[vChildren.size()]));
        }
        return true;
    }

    protected char getHandleMementoDelimiter() {
        return '}';
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ModelElement classFile = (ModelElement)this.getSourceModule(classFileName);
                if (classFile != null) {
                    return classFile.getHandleFromMemento(memento, owner);
                }
            }
            case '}': {
                return MementoModelElementUtil.getHandleFromMemento((MementoTokenizer)memento, (IParent)this, (WorkingCopyOwner)owner);
            }
        }
        return null;
    }

    public boolean containsScriptResources() throws ModelException {
        Object elementInfo = this.getElementInfo();
        if (!(elementInfo instanceof ScriptFolderInfo)) {
            return false;
        }
        ScriptFolderInfo scriptElementInfo = (ScriptFolderInfo)elementInfo;
        return scriptElementInfo.containsScriptResources();
    }

    public boolean hasChildren() throws ModelException {
        return this.getChildren().length > 0;
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK TCL Package:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    public ISourceModule createSourceModule(String name, String contents, boolean force, IProgressMonitor monitor) throws ModelException {
        return null;
    }

    public Object[] getForeignResources() throws ModelException {
        return ModelElementInfo.NO_NON_SCRIPT_RESOURCES;
    }

    public boolean exists() {
        return true;
    }

    public ISourceModule[] getSourceModules() throws ModelException {
        ArrayList list = this.getChildrenOfType(5);
        ISourceModule[] array = new ISourceModule[list.size()];
        list.toArray(array);
        return array;
    }

    public boolean hasSubfolders() throws ModelException {
        return false;
    }

    public boolean isRootFolder() {
        return false;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getElementName());
    }

    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
    }

    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    public ISourceModule getSourceModule(String name) {
        block4: {
            IModelElement[] children = null;
            try {
                children = this.getChildren();
                int i = 0;
                while (i < children.length) {
                    IModelElement child = children[i];
                    if (child instanceof ISourceModule && name.equals(child.getElementName())) {
                        return (ISourceModule)child;
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }
}

